/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.types;

import java.io.Serializable;
import java.util.Date;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.util.DateUtil;

public abstract class DmcTypeDate
extends DmcAttribute<Date>
implements Serializable {
    public DmcTypeDate() {
    }

    public DmcTypeDate(DmcAttributeInfo ai) {
        super(ai);
    }

    @Override
    public Date typeCheck(Object value) throws DmcValueException {
        Date rc = null;
        if (value instanceof Date) {
            rc = (Date)value;
        } else if (value instanceof Long) {
            rc = new Date((Long)value);
        } else if (value instanceof String) {
            Long temp = null;
            try {
                temp = Long.valueOf((String)value);
                rc = new Date(temp);
            }
            catch (NumberFormatException e) {
                try {
                    rc = DateUtil.parse((String)value);
                }
                catch (DmcValueException ex) {
                    throw new DmcValueException("Invalid String format for Date: " + value + " - should be either a long value or YYYYMMDD:HHMMSS");
                }
            }
        } else {
            throw new DmcValueException("Object of class: " + value.getClass().getName() + " passed where object compatible with Date expected.");
        }
        return rc;
    }

    @Override
    public Date cloneValue(Date original) {
        return new Date(original.getTime());
    }

    @Override
    protected String formatValue(Date value) {
        return DateUtil.formatComplete(value);
    }

    @Override
    public void serializeValue(DmcOutputStreamIF dos, Date value) throws Exception {
        dos.writeLong(value.getTime());
    }

    @Override
    public Date deserializeValue(DmcInputStreamIF dis) throws Exception {
        return new Date(dis.readLong());
    }
}

