/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.types;

import java.io.Serializable;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;

public abstract class DmcTypeDouble
extends DmcAttribute<Double>
implements Serializable {
    public DmcTypeDouble() {
    }

    public DmcTypeDouble(DmcAttributeInfo ai) {
        super(ai);
    }

    @Override
    public Double typeCheck(Object value) throws DmcValueException {
        Double rc = null;
        if (value instanceof Double) {
            rc = (Double)value;
        } else if (value instanceof Integer) {
            rc = new Double(((Integer)value).intValue());
        } else if (value instanceof String) {
            String v = (String)value;
            try {
                rc = Double.valueOf(v);
            }
            catch (NumberFormatException e) {
                throw new DmcValueException("Invalid Double value: " + v);
            }
        } else {
            throw new DmcValueException("Object of class: " + value.getClass().getName() + " passed where object compatible with Double expected.");
        }
        return rc;
    }

    @Override
    public Double cloneValue(Double original) {
        return new Double(original);
    }

    @Override
    public void serializeValue(DmcOutputStreamIF dos, Double value) throws Exception {
        dos.writeDouble(value);
    }

    @Override
    public Double deserializeValue(DmcInputStreamIF dis) throws Exception {
        return new Double(dis.readDouble());
    }
}

