/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.types;

import java.io.Serializable;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;

public abstract class DmcTypeFloat
extends DmcAttribute<Float>
implements Serializable {
    public DmcTypeFloat() {
    }

    public DmcTypeFloat(DmcAttributeInfo ai) {
        super(ai);
    }

    @Override
    public Float typeCheck(Object value) throws DmcValueException {
        Float rc = null;
        if (value instanceof Float) {
            rc = (Float)value;
        } else if (value instanceof Integer) {
            rc = (Float)value;
        } else if (value instanceof String) {
            String v = (String)value;
            try {
                rc = Float.valueOf(v);
            }
            catch (NumberFormatException e) {
                throw new DmcValueException("Invalid Float value: " + v);
            }
        } else {
            throw new DmcValueException("Object of class: " + value.getClass().getName() + " passed where object compatible with Float expected.");
        }
        return rc;
    }

    @Override
    public Float cloneValue(Float original) {
        return new Float(original.floatValue());
    }

    @Override
    public void serializeValue(DmcOutputStreamIF dos, Float value) throws Exception {
        dos.writeFloat(value.floatValue());
    }

    @Override
    public Float deserializeValue(DmcInputStreamIF dis) throws Exception {
        return new Float(dis.readFloat());
    }
}

