/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.types;

import java.io.Serializable;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;

public abstract class DmcTypeInteger
extends DmcAttribute<Integer>
implements Serializable {
    public DmcTypeInteger() {
    }

    public DmcTypeInteger(DmcAttributeInfo ai) {
        super(ai);
    }

    @Override
    public Integer typeCheck(Object value) throws DmcValueException {
        Integer rc = null;
        if (value instanceof Integer) {
            rc = (Integer)value;
        } else if (value instanceof String) {
            String v = (String)value;
            try {
                rc = Integer.valueOf(v);
            }
            catch (NumberFormatException e) {
                throw new DmcValueException("Invalid Integer value: " + v);
            }
        } else {
            throw new DmcValueException("Object of class: " + value.getClass().getName() + " passed where object compatible with Integer expected.");
        }
        return rc;
    }

    @Override
    public Integer cloneValue(Integer original) {
        return new Integer(original);
    }

    @Override
    public void serializeValue(DmcOutputStreamIF dos, Integer value) throws Exception {
        dos.writeInt(value);
    }

    @Override
    public Integer deserializeValue(DmcInputStreamIF dis) throws Exception {
        return new Integer(dis.readInt());
    }
}

