/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.types;

import java.io.Serializable;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeDmcObjectName;
import org.dmd.dmc.types.IntegerName;

public abstract class DmcTypeIntegerName
extends DmcTypeDmcObjectName<IntegerName>
implements Serializable {
    public DmcTypeIntegerName() {
    }

    public DmcTypeIntegerName(DmcAttributeInfo ai) {
        super(ai);
    }

    @Override
    public IntegerName typeCheck(Object value) throws DmcValueException {
        IntegerName rc = null;
        if (value instanceof IntegerName) {
            rc = (IntegerName)value;
        } else if (value instanceof Integer) {
            rc = new IntegerName((Integer)value);
        } else if (value instanceof String) {
            try {
                Integer n = Integer.valueOf((String)value);
                rc = new IntegerName(n);
            }
            catch (NumberFormatException e) {
                throw new DmcValueException("Invalid IntegerName value: " + value.toString());
            }
        } else {
            throw new DmcValueException("Object of class: " + value.getClass().getName() + " passed where object compatible with IntegerName expected.");
        }
        return rc;
    }

    @Override
    public IntegerName cloneValue(IntegerName original) {
        return new IntegerName(original.name);
    }

    @Override
    public void serializeValue(DmcOutputStreamIF dos, IntegerName value) throws Exception {
        value.serializeIt(dos);
    }

    @Override
    public IntegerName deserializeValue(DmcInputStreamIF dis) throws Exception {
        IntegerName rc = new IntegerName();
        rc.deserializeIt(dis);
        return rc;
    }
}

