/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.types;

import java.io.Serializable;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;

public abstract class DmcTypeLong
extends DmcAttribute<Long>
implements Serializable {
    public DmcTypeLong() {
    }

    public DmcTypeLong(DmcAttributeInfo ai) {
        super(ai);
    }

    @Override
    public Long typeCheck(Object value) throws DmcValueException {
        Long rc = null;
        if (value instanceof Long) {
            rc = (Long)value;
        } else if (value instanceof Integer) {
            rc = new Long(((Integer)value).intValue());
        } else if (value instanceof String) {
            String v = (String)value;
            try {
                rc = Long.valueOf(v);
            }
            catch (NumberFormatException e) {
                throw new DmcValueException("Invalid Long value: " + v);
            }
        } else {
            throw new DmcValueException("Object of class: " + value.getClass().getName() + " passed where object compatible with Long expected.");
        }
        return rc;
    }

    @Override
    public Long cloneValue(Long original) {
        return new Long(original);
    }

    @Override
    public void serializeValue(DmcOutputStreamIF dos, Long value) throws Exception {
        dos.writeLong(value);
    }

    @Override
    public Long deserializeValue(DmcInputStreamIF dis) throws Exception {
        return new Long(dis.readLong());
    }
}

