/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.types;

import java.io.Serializable;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DmcTypeDmcObjectName;
import org.dmd.dmc.types.LongName;

public abstract class DmcTypeLongName
extends DmcTypeDmcObjectName<LongName>
implements Serializable {
    public DmcTypeLongName() {
    }

    public DmcTypeLongName(DmcAttributeInfo ai) {
        super(ai);
    }

    @Override
    public LongName typeCheck(Object value) throws DmcValueException {
        LongName rc = null;
        if (value instanceof LongName) {
            rc = (LongName)value;
        } else if (value instanceof Long) {
            rc = new LongName((Long)value);
        } else if (value instanceof Integer) {
            rc = new LongName((Long)value);
        } else if (value instanceof String) {
            try {
                Long n = Long.valueOf((String)value);
                rc = new LongName(n);
            }
            catch (NumberFormatException e) {
                throw new DmcValueException("Invalid LongName value: " + value.toString());
            }
        } else {
            throw new DmcValueException("Object of class: " + value.getClass().getName() + " passed where object compatible with LongName expected.");
        }
        return rc;
    }

    @Override
    public LongName cloneValue(LongName original) {
        return new LongName(original.name);
    }

    @Override
    public void serializeValue(DmcOutputStreamIF dos, LongName value) throws Exception {
        value.serializeIt(dos);
    }

    @Override
    public LongName deserializeValue(DmcInputStreamIF dis) throws Exception {
        LongName rc = new LongName();
        rc.deserializeIt(dis);
        return rc;
    }
}

