/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.types;

import java.io.Serializable;
import java.util.Iterator;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.types.Modifier;

public abstract class DmcTypeModifier
extends DmcAttribute<Modifier>
implements Serializable {
    public DmcTypeModifier() {
    }

    public DmcTypeModifier(DmcAttributeInfo ai) {
        super(ai);
    }

    @Override
    public Modifier typeCheck(Object value) throws DmcValueException {
        Modifier rc = null;
        if (value instanceof Modifier) {
            rc = (Modifier)value;
        } else if (value instanceof String) {
            String v = (String)value;
            rc = new Modifier(v);
        } else {
            throw new DmcValueException("Object of class: " + value.getClass().getName() + " passed where object compatible with Modifier expected.");
        }
        return rc;
    }

    @Override
    public Modifier cloneValue(Modifier original) {
        return new Modifier(original);
    }

    @Override
    public void serializeValue(DmcOutputStreamIF dos, Modifier value) throws Exception {
        value.serializeIt(dos);
    }

    @Override
    public Modifier deserializeValue(DmcInputStreamIF dis) throws Exception {
        Modifier rc = new Modifier();
        rc.deserializeIt(dis);
        return rc;
    }

    public void resolved() throws DmcValueExceptionSet {
        DmcValueExceptionSet ex = null;
        Iterator mods = this.getMV();
        if (mods != null) {
            while (mods.hasNext()) {
                Modifier mod = (Modifier)mods.next();
                if (mod.isResolved()) continue;
                if (ex == null) {
                    ex = new DmcValueExceptionSet();
                }
                ex.add(new DmcValueException("The value for the " + (Object)((Object)mod.operation) + " modification on the " + mod.attributeName + " attribute is not resolved."));
            }
        }
        if (ex != null) {
            throw ex;
        }
    }
}

