/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.types;

import java.io.Serializable;
import java.util.Iterator;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcNameResolverIF;
import org.dmd.dmc.DmcNamedObjectIF;
import org.dmd.dmc.DmcNamedObjectREF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcObjectName;
import org.dmd.dmc.DmcOmni;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.Modifier;
import org.dmd.dms.generated.enums.ModifyTypeEnum;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public abstract class DmcTypeNamedObjectREF<HELPER extends DmcNamedObjectREF, NAMETYPE extends DmcObjectName>
extends DmcAttribute<HELPER>
implements Serializable {
    public DmcTypeNamedObjectREF() {
    }

    public DmcTypeNamedObjectREF(DmcAttributeInfo ai) {
        super(ai);
    }

    protected abstract HELPER getNewHelper();

    protected abstract NAMETYPE getNewName();

    protected abstract boolean isDMO(Object var1);

    protected abstract String getDMOClassName();

    public void resolveReferences(DmcNameResolverIF rx) throws DmcValueException {
        if (this.getAttributeInfo().valueType == ValueTypeEnum.SINGLE) {
            DmcNamedObjectREF ref = (DmcNamedObjectREF)this.getSV();
            if (ref.getObject() == null) {
                DmcNamedObjectIF obj = (DmcNamedObjectIF)((Object)rx.findNamedDMO(ref.getObjectName()));
                if (obj == null) {
                    throw new DmcValueException("Could not resolve reference to: " + ref.getObjectName() + " via attribute: " + this.getName());
                }
                ref.setObject(obj);
            }
        } else {
            Iterator it = this.getMV();
            if (it != null) {
                while (it.hasNext()) {
                    DmcNamedObjectREF ref = (DmcNamedObjectREF)it.next();
                    if (ref.getObject() != null) continue;
                    DmcNamedObjectIF obj = (DmcNamedObjectIF)((Object)rx.findNamedDMO(ref.getObjectName()));
                    if (obj == null) {
                        throw new DmcValueException("Could not resolve reference to: " + ref.getObjectName() + " via attribute: " + this.getName());
                    }
                    ref.setObject(obj);
                }
            }
        }
    }

    public void removeBackReferences() {
        if (DmcOmni.instance().backRefTracking() && DmcOmni.instance().trackThisAttribute(this.getAttributeInfo().id)) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.SINGLE) {
                DmcNamedObjectREF ref = (DmcNamedObjectREF)this.getSV();
                if (ref != null && ref.getObject() != null && ref.getBackrefModifier() != null) {
                    ((DmcObject)ref.getObject()).removeBackref(ref.getBackrefModifier());
                }
            } else {
                Iterator it = this.getMV();
                if (it != null) {
                    while (it.hasNext()) {
                        DmcNamedObjectREF ref = (DmcNamedObjectREF)it.next();
                        if (ref == null || ref.getObject() == null || ref.getBackrefModifier() == null) continue;
                        ((DmcObject)ref.getObject()).removeBackref(ref.getBackrefModifier());
                    }
                }
            }
        }
    }

    public boolean doLazyResolution(DmcObject referrer) {
        boolean deleteUs = false;
        if (this.weAreResolved()) {
            return deleteUs;
        }
        if (this.getAttributeInfo() == null) {
            throw new IllegalStateException("Unable to get attribute info for ID: " + this.ID);
        }
        if (this.getAttributeInfo().valueType == ValueTypeEnum.SINGLE) {
            DmcNamedObjectREF ref = (DmcNamedObjectREF)this.getSV();
            if (!this.resolveIt(referrer, ref)) {
                deleteUs = true;
            }
        } else if (this.getAttributeInfo().indexSize == 0) {
            Iterator it = this.getMV();
            while (it.hasNext()) {
                DmcNamedObjectREF ref = (DmcNamedObjectREF)it.next();
                if (this.resolveIt(referrer, ref)) continue;
                this.del(ref);
            }
            if (this.getMVSize() == 0) {
                deleteUs = true;
            }
        } else {
            boolean anyResolved = false;
            for (int index = 0; index < this.getMVSize(); ++index) {
                DmcNamedObjectREF ref = (DmcNamedObjectREF)this.getMVnth(index);
                if (ref == null) continue;
                if (this.resolveIt(referrer, ref)) {
                    anyResolved = true;
                    continue;
                }
                try {
                    this.setMVnth(index, null);
                    continue;
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("Nulling an indexed attribute slot should not cause an exception.");
                }
            }
            if (!anyResolved) {
                deleteUs = true;
            }
        }
        return deleteUs;
    }

    private boolean resolveIt(DmcObject referrer, DmcNamedObjectREF ref) {
        boolean resolved = true;
        DmcObject obj = DmcOmni.instance().findNamedDMO(ref.getObjectName());
        if (obj == null) {
            DmcOmni.instance().logDeadReference(referrer, this, ref.getObjectName());
            if (DmcOmni.instance().cleanUpDeadRefs()) {
                resolved = false;
            }
        } else {
            ref.setObject((DmcNamedObjectIF)((Object)obj));
            if (DmcOmni.instance().backRefTracking() && referrer.supportsBackrefTracking()) {
                Modifier backrefMod = null;
                DmcAttribute<?> mod = this.getNew();
                mod.setAttributeInfo(this.getAttributeInfo());
                try {
                    if (this.getAttributeInfo().valueType == ValueTypeEnum.SINGLE) {
                        mod.set(ref);
                    } else {
                        mod.add(ref);
                    }
                }
                catch (DmcValueException e) {
                    e.printStackTrace();
                }
                backrefMod = this.getAttributeInfo().valueType == ValueTypeEnum.SINGLE ? new Modifier(ModifyTypeEnum.SET, mod, referrer) : new Modifier(ModifyTypeEnum.ADD, mod, referrer);
                obj.addBackref(backrefMod);
                ref.setBackrefModifier(backrefMod);
            }
        }
        return resolved;
    }

    protected boolean weAreResolved() {
        boolean rc;
        block2: {
            block4: {
                Iterator it;
                block5: {
                    block3: {
                        rc = false;
                        if (this.getAttributeInfo().valueType != ValueTypeEnum.SINGLE) break block3;
                        DmcNamedObjectREF ref = (DmcNamedObjectREF)this.getSV();
                        if (ref.getObject() == null) break block2;
                        rc = true;
                        break block2;
                    }
                    if (this.getAttributeInfo().indexSize != 0) break block4;
                    it = this.getMV();
                    if (!DmcOmni.instance().cleanUpDeadRefs()) break block5;
                    DmcNamedObjectREF ref = (DmcNamedObjectREF)it.next();
                    if (ref.getObject() == null) break block2;
                    rc = true;
                    break block2;
                }
                rc = true;
                while (it.hasNext()) {
                    if (((DmcNamedObjectREF)it.next()).getObject() != null) continue;
                    rc = false;
                    break block2;
                }
                break block2;
            }
            rc = true;
            for (int index = 0; index < this.getMVSize(); ++index) {
                DmcNamedObjectREF ref = (DmcNamedObjectREF)this.getMVnth(index);
                if (ref == null || ref.getObject() != null) continue;
                rc = false;
                break;
            }
        }
        return rc;
    }
}

