/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.types;

import java.io.Serializable;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;

public abstract class DmcTypeShort
extends DmcAttribute<Short>
implements Serializable {
    public DmcTypeShort() {
    }

    public DmcTypeShort(DmcAttributeInfo ai) {
        super(ai);
    }

    @Override
    public Short typeCheck(Object value) throws DmcValueException {
        Short rc = null;
        if (value instanceof Short) {
            rc = (Short)value;
        } else if (value instanceof String) {
            String v = (String)value;
            try {
                rc = Short.valueOf(v);
            }
            catch (NumberFormatException e) {
                throw new DmcValueException("Invalid Short value: " + v);
            }
        } else {
            throw new DmcValueException("Object of class: " + value.getClass().getName() + " passed where object compatible with Short expected.");
        }
        return rc;
    }

    @Override
    public Short cloneValue(Short original) {
        return new Short(original);
    }

    @Override
    public void serializeValue(DmcOutputStreamIF dos, Short value) throws Exception {
        dos.writeShort(value.shortValue());
    }

    @Override
    public Short deserializeValue(DmcInputStreamIF dis) throws Exception {
        return new Short(dis.readShort());
    }
}

