/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.types;

import java.io.Serializable;
import org.dmd.dmc.DmcHierarchicObjectName;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcMappedAttributeIF;
import org.dmd.dmc.DmcObjectName;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;

public class DotName
extends DmcHierarchicObjectName
implements Serializable {
    public static final String className = "DotName";
    static final String dotCase = "[a-zA-Z0-9][a-zA-Z0-9_.:\\s/-]*";
    static final String nameCase = "[a-zA-Z][a-zA-Z0-9_]*";
    String name;
    transient DotName parent;

    public DotName() {
    }

    public DotName(String schema, String attribute) {
        if (!schema.matches(nameCase) || !attribute.matches(nameCase)) {
            throw new IllegalStateException("One of these strings doesn't match the DotName character set: " + schema + "  " + attribute);
        }
        this.name = schema + "." + attribute;
    }

    public DotName(String n) throws DmcValueException {
        if (!n.matches(dotCase)) {
            throw new DmcValueException("The string: " + n + " does not conform to dot name format.");
        }
        this.name = n;
    }

    public DotName(DotName dotName) {
        this.name = new String(dotName.name);
    }

    public DotName(DotName p, String child) throws DmcValueException {
        if (!child.matches(nameCase)) {
            throw new DmcValueException("The string: " + child + " does not conform to dot name format.");
        }
        this.name = new String(p.name + "." + child);
        this.parent = p;
    }

    public int getDepth() {
        int rc = 1;
        StringBuffer sb = new StringBuffer(this.name);
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != '.') continue;
            ++rc;
        }
        return rc;
    }

    @Override
    public String getNameString() {
        return this.name;
    }

    @Override
    public void setNameString(String n) throws DmcValueException {
        if (!n.matches(dotCase)) {
            throw new DmcValueException("The string: " + n + " does not conform to dot name format.");
        }
        this.name = n;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DotName) {
            return this.name.equals(((DotName)obj).name);
        }
        if (obj instanceof DmcObjectName) {
            return this.name.equals(((DmcObjectName)obj).getNameString());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public void deserializeIt(DmcInputStreamIF dis) throws Exception {
        this.name = dis.readUTF();
    }

    @Override
    public void serializeIt(DmcOutputStreamIF dos) throws Exception {
        dos.writeUTF(this.name);
    }

    @Override
    public int compareTo(DmcObjectName o) {
        if (o instanceof DotName) {
            return this.name.compareTo(((DotName)o).name);
        }
        return this.name.compareTo(o.getNameString());
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public DmcHierarchicObjectName getParentName() {
        int lastdot;
        if (this.parent == null && (lastdot = this.name.lastIndexOf(46)) != -1) {
            try {
                this.parent = new DotName(this.name.substring(0, lastdot));
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Shouldn't fail to get a parent name from a legal DotName");
            }
        }
        return this.parent;
    }

    public boolean isChild(DmcHierarchicObjectName n) {
        boolean rc = false;
        if (n instanceof DotName && ((DotName)n).name.startsWith(this.name)) {
            rc = true;
        }
        return rc;
    }

    public DotName trimRoot() {
        DotName rc = new DotName();
        int dotPos = this.name.indexOf(".");
        rc.name = dotPos == -1 ? "" : this.name.substring(dotPos + 1);
        return rc;
    }

    public boolean isParent(DmcHierarchicObjectName n) {
        boolean rc = false;
        if (n instanceof DotName && this.name.startsWith(((DotName)n).name)) {
            rc = true;
        }
        return rc;
    }

    public boolean isSibling(DmcHierarchicObjectName n) {
        boolean rc = false;
        if (n instanceof DotName && this.getParentName().equals(((DotName)n).getParentName())) {
            rc = true;
        }
        return rc;
    }

    @Override
    public Object getKey() {
        return this.name;
    }

    @Override
    public String getKeyAsString() {
        return this.name;
    }

    @Override
    public String getNameClass() {
        return className;
    }

    @Override
    public boolean valuesAreEqual(DmcMappedAttributeIF obj) {
        boolean rc = false;
        if (obj instanceof DotName) {
            DotName other = (DotName)obj;
            rc = this.name.equals(other.name);
        }
        return rc;
    }

    @Override
    public DmcObjectName cloneIt() {
        DotName rc = null;
        try {
            rc = new DotName(this.name);
        }
        catch (DmcValueException e) {
            throw new IllegalStateException("Shouldn't fail cloning a legal DotName");
        }
        return rc;
    }

    @Override
    public DmcObjectName getNew() {
        return new DotName();
    }

    @Override
    public String getPresentationString() {
        return this.name;
    }
}

