/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.types;

import java.io.Serializable;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcMappedAttributeIF;
import org.dmd.dmc.DmcObjectName;
import org.dmd.dmc.DmcObjectNameIF;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;

public class IntegerName
extends DmcObjectName
implements DmcObjectNameIF,
Serializable {
    public static final String className = "IntegerName";
    Integer name;

    public IntegerName() {
    }

    public IntegerName(Integer n) {
        this.name = n;
    }

    @Override
    public String getNameString() {
        return this.name.toString();
    }

    @Override
    public String toString() {
        return this.name.toString();
    }

    @Override
    public void setNameString(String n) throws DmcValueException {
        try {
            this.name = Integer.valueOf(n);
        }
        catch (NumberFormatException e) {
            throw new DmcValueException("Invalid IntegerName value: " + n);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IntegerName) {
            return this.name.equals(((IntegerName)obj).name);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public void deserializeIt(DmcInputStreamIF dis) throws Exception {
        this.name = dis.readInt();
    }

    @Override
    public void serializeIt(DmcOutputStreamIF dos) throws Exception {
        dos.writeInt(this.name);
    }

    @Override
    public int compareTo(DmcObjectName o) {
        if (o instanceof IntegerName) {
            return this.name.compareTo(((IntegerName)o).name);
        }
        return this.name.toString().compareTo(o.getNameString());
    }

    @Override
    public Object getKey() {
        return this.name;
    }

    @Override
    public String getKeyAsString() {
        return this.name.toString();
    }

    @Override
    public String getNameClass() {
        return className;
    }

    @Override
    public boolean valuesAreEqual(DmcMappedAttributeIF obj) {
        boolean rc = false;
        if (obj instanceof IntegerName) {
            IntegerName other = (IntegerName)obj;
            rc = this.name.equals(other.name);
        }
        return rc;
    }

    @Override
    public DmcObjectName cloneIt() {
        return new IntegerName(this.name);
    }

    @Override
    public DmcObjectName getNew() {
        return new IntegerName();
    }

    @Override
    public String getPresentationString() {
        return this.name.toString();
    }
}

