/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.types;

import java.io.Serializable;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcMappedAttributeIF;
import org.dmd.dmc.DmcOutputStreamIF;

public class IntegerToBoolean
implements DmcMappedAttributeIF,
Serializable {
    Integer key;
    Boolean value;

    public IntegerToBoolean() {
        this.key = null;
        this.value = null;
    }

    public IntegerToBoolean(Integer k) {
        this.key = k;
        this.value = false;
    }

    public IntegerToBoolean(Integer k, Boolean v) {
        this.key = k;
        this.value = v;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public String getKeyAsString() {
        if (this.key == null) {
            return "null";
        }
        return this.key.toString();
    }

    public String toString() {
        if (this.key == null) {
            if (this.value == null) {
                return "null null";
            }
            return "null " + this.value;
        }
        if (this.value == null) {
            return this.key.toString() + " null";
        }
        return this.key.toString() + " " + this.value;
    }

    public Integer getKeyAsInteger() {
        return this.key;
    }

    public Boolean getValue() {
        return this.value;
    }

    public void serializeIt(DmcOutputStreamIF dos) throws Exception {
        dos.writeInt(this.key);
        dos.writeBoolean(this.value);
    }

    public void deserializeIt(DmcInputStreamIF dis) throws Exception {
        this.key = dis.readInt();
        this.value = dis.readBoolean();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IntegerToBoolean) {
            return this.valuesAreEqual((IntegerToBoolean)obj);
        }
        return false;
    }

    @Override
    public boolean valuesAreEqual(DmcMappedAttributeIF obj) {
        boolean rc = false;
        if (obj instanceof IntegerToBoolean) {
            IntegerToBoolean other = (IntegerToBoolean)obj;
            rc = this.key.intValue() != other.getKeyAsInteger().intValue() ? false : this.value.equals(other.value);
        }
        return rc;
    }
}

