/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.types;

import java.io.Serializable;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcMappedAttributeIF;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.types.UUIDLite;

public class IntegerToUUIDLite
implements DmcMappedAttributeIF,
Serializable {
    Integer key;
    UUIDLite value;

    public IntegerToUUIDLite() {
        this.key = null;
        this.value = null;
    }

    public IntegerToUUIDLite(Integer k) {
        this.key = k;
        this.value = new UUIDLite();
    }

    public IntegerToUUIDLite(Integer k, UUIDLite v) {
        this.key = k;
        this.value = v;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public String getKeyAsString() {
        if (this.key == null) {
            return "null";
        }
        return this.key.toString();
    }

    public String toString() {
        if (this.key == null) {
            if (this.value == null) {
                return "null null";
            }
            return "null " + this.value;
        }
        if (this.value == null) {
            return this.key.toString() + " null";
        }
        return this.key.toString() + " " + this.value.toString();
    }

    public Integer getKeyAsInteger() {
        return this.key;
    }

    public UUIDLite getValue() {
        return this.value;
    }

    public void serializeIt(DmcOutputStreamIF dos) throws Exception {
        dos.writeInt(this.key);
        dos.writeUTF(this.value.toString());
    }

    public void deserializeIt(DmcInputStreamIF dis) throws Exception {
        this.key = dis.readInt();
        this.value = new UUIDLite(dis.readUTF());
    }

    public boolean equals(Object obj) {
        if (obj instanceof IntegerToUUIDLite) {
            return this.valuesAreEqual((IntegerToUUIDLite)obj);
        }
        return false;
    }

    @Override
    public boolean valuesAreEqual(DmcMappedAttributeIF obj) {
        boolean rc = false;
        if (obj instanceof IntegerToUUIDLite) {
            IntegerToUUIDLite other = (IntegerToUUIDLite)obj;
            rc = this.key.intValue() != other.getKeyAsInteger().intValue() ? false : this.value.equals(other.value);
        }
        return rc;
    }
}

