/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.types;

import java.io.Serializable;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcMappedAttributeIF;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;

public class LabelledIntegerDataPoint
implements DmcMappedAttributeIF,
Serializable {
    String label;
    int value;

    public LabelledIntegerDataPoint() {
        this.label = null;
        this.value = 0;
    }

    public LabelledIntegerDataPoint(LabelledIntegerDataPoint original) {
        this.label = original.label;
        this.value = original.value;
    }

    public void serializeIt(DmcOutputStreamIF dos) throws Exception {
        dos.writeUTF(this.label);
        dos.writeInt(this.value);
    }

    public void deserializeIt(DmcInputStreamIF dis) throws Exception {
        this.label = dis.readUTF();
        this.value = dis.readInt();
    }

    public LabelledIntegerDataPoint(String v) throws DmcValueException {
        this.set(v);
    }

    public void set(String val) throws DmcValueException {
        if (val == null) {
            throw new DmcValueException("null value passed to LabelledDataPoint.set()");
        }
        String v = val.trim();
        int lastSpace = v.lastIndexOf(" ");
        if (lastSpace == -1) {
            throw new DmcValueException("Incorrect number of tokens for an LabelledDataPoint: " + v);
        }
        this.label = v.substring(0, lastSpace).trim();
        try {
            this.value = Integer.parseInt(v.substring(lastSpace + 1));
        }
        catch (NumberFormatException ex) {
            throw new DmcValueException("Invalid integer value for an LabelledDataPoint: " + v.substring(lastSpace + 1));
        }
    }

    public String getLabel() {
        return this.label;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.label + " " + this.value;
    }

    public boolean equals(Object v) {
        return v instanceof LabelledIntegerDataPoint && this.label.equals(((LabelledIntegerDataPoint)v).label) && this.value == ((LabelledIntegerDataPoint)v).value;
    }

    @Override
    public Object getKey() {
        return this.label;
    }

    @Override
    public String getKeyAsString() {
        return this.label;
    }

    @Override
    public boolean valuesAreEqual(DmcMappedAttributeIF obj) {
        if (obj instanceof LabelledIntegerDataPoint) {
            LabelledIntegerDataPoint other = (LabelledIntegerDataPoint)obj;
            if (this.label.equals(other.label) && this.value == other.value) {
                return true;
            }
        }
        return false;
    }
}

