/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.types;

import java.io.Serializable;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcNamedObjectIF;
import org.dmd.dmc.DmcNamedObjectREF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcOmni;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ModifyTypeEnum;

public class Modifier
implements Serializable {
    ModifyTypeEnum operation;
    Boolean haveAttribute;
    String attributeName;
    int attributeID;
    String value;
    String partName;
    int index;
    DmcAttribute<?> attribute;
    transient DmcNamedObjectIF referringObject;
    transient DmcNamedObjectREF<?> refFromComplexType;

    public Modifier() {
        this.operation = ModifyTypeEnum.NONE;
        this.haveAttribute = false;
        this.attributeName = null;
        this.attributeID = -1;
        this.value = null;
        this.partName = null;
        this.index = -1;
        this.attribute = null;
        this.referringObject = null;
    }

    public Modifier(Modifier original) {
        this.operation = original.operation;
        this.haveAttribute = original.haveAttribute;
        this.attributeName = original.attributeName;
        this.attributeID = original.attributeID;
        this.value = original.value;
        this.partName = null;
        this.index = original.index;
        this.attribute = original.attribute;
        this.referringObject = original.referringObject;
    }

    public Modifier(ModifyTypeEnum op, DmcAttribute<?> attr) {
        this.operation = op;
        this.haveAttribute = true;
        this.attributeName = attr.getName();
        this.attributeID = attr.getID();
        this.value = null;
        this.partName = null;
        this.index = -1;
        this.attribute = attr;
        this.referringObject = null;
    }

    public Modifier(ModifyTypeEnum op, DmcAttributeInfo ai) {
        this.operation = op;
        this.haveAttribute = false;
        this.attributeName = ai.name;
        this.attributeID = ai.id;
        this.value = "none";
        this.partName = null;
        this.index = -1;
        this.attribute = null;
        this.referringObject = null;
    }

    public Modifier(ModifyTypeEnum op, DmcAttribute<?> attr, int idx) {
        this.operation = op;
        this.haveAttribute = true;
        this.attributeName = attr.getName();
        this.attributeID = attr.getID();
        this.value = null;
        this.partName = null;
        this.index = idx;
        this.attribute = attr;
        this.referringObject = null;
    }

    public Modifier(ModifyTypeEnum op, DmcAttributeInfo ai, int idx) {
        this.operation = op;
        this.haveAttribute = false;
        this.attributeName = ai.name;
        this.attributeID = ai.id;
        this.value = "none";
        this.partName = null;
        this.index = idx;
        this.attribute = null;
        this.referringObject = null;
    }

    public Modifier(ModifyTypeEnum op, DmcAttribute<?> attr, DmcObject referrer) {
        if (op == ModifyTypeEnum.SET) {
            this.operation = ModifyTypeEnum.REM;
        } else if (op == ModifyTypeEnum.ADD) {
            this.operation = ModifyTypeEnum.DEL;
        } else {
            throw new IllegalStateException("Only SET and ADD operations can be specified for a backref Modifier.");
        }
        this.haveAttribute = true;
        this.attributeName = attr.getName();
        this.attributeID = attr.getID();
        this.value = null;
        this.partName = null;
        this.index = -1;
        this.attribute = attr;
        this.referringObject = (DmcNamedObjectIF)((Object)referrer);
    }

    public Modifier(String pn, DmcObject referrer, DmcNamedObjectREF<?> ctr) {
        this.operation = ModifyTypeEnum.NONE;
        this.haveAttribute = false;
        this.attributeName = null;
        this.attributeID = 0;
        this.value = null;
        this.partName = pn;
        this.index = -1;
        this.attribute = null;
        this.referringObject = (DmcNamedObjectIF)((Object)referrer);
        this.refFromComplexType = ctr;
    }

    public Modifier(String pn, DmcObject referrer, DmcNamedObjectREF<?> ctr, int ai) {
        this.operation = ModifyTypeEnum.NONE;
        this.haveAttribute = false;
        this.attributeName = null;
        this.attributeID = ai;
        this.value = null;
        this.partName = pn;
        this.index = -1;
        this.attribute = null;
        this.referringObject = (DmcNamedObjectIF)((Object)referrer);
        this.refFromComplexType = ctr;
    }

    public Modifier(String pn, DmcObject referrer, DmcNamedObjectREF<?> ctr, int ai, String an) {
        this.operation = ModifyTypeEnum.NONE;
        this.haveAttribute = false;
        this.attributeName = an;
        this.attributeID = ai;
        this.value = null;
        this.partName = pn;
        this.index = -1;
        this.attribute = null;
        this.referringObject = (DmcNamedObjectIF)((Object)referrer);
        this.refFromComplexType = ctr;
    }

    public DmcNamedObjectREF<?> getRefFromComplexType() {
        return this.refFromComplexType;
    }

    public Modifier(ModifyTypeEnum op, DmcAttribute<?> attr, DmcObject referrer, int idx) {
        if (op != ModifyTypeEnum.NTH) {
            throw new IllegalStateException("Only the NTH operation can be specified for a backref Modifier with an index.");
        }
        this.operation = ModifyTypeEnum.NTH;
        this.haveAttribute = true;
        this.attributeName = attr.getName();
        this.attributeID = attr.getID();
        this.value = null;
        this.partName = null;
        this.index = idx;
        this.attribute = attr;
        this.referringObject = (DmcNamedObjectIF)((Object)referrer);
    }

    public Modifier(String v) throws DmcValueException {
        if (v == null) {
            throw new DmcValueException("Null value passed to Modifier()");
        }
        int space1 = v.indexOf(" ");
        int space2 = v.indexOf(" ", space1 + 1);
        if (space1 == -1) {
            throw new DmcValueException("Incorrect number of tokens for Modifier: " + v);
        }
        String trimmed = v.trim();
        this.attributeName = trimmed.substring(0, space1);
        if (space2 == -1) {
            String op = trimmed.substring(space1 + 1);
            this.operation = ModifyTypeEnum.get(op);
            if (this.operation == null) {
                throw new DmcValueException("Unknown modify operation: " + op);
            }
            if (this.operation != ModifyTypeEnum.REM) {
                throw new DmcValueException("Missing value for modify operation: " + op);
            }
        } else {
            String op = trimmed.substring(space1 + 1, space2);
            this.operation = ModifyTypeEnum.get(op);
            if (this.operation == null) {
                throw new DmcValueException("Unknown modify operation: " + op);
            }
            if (this.operation == ModifyTypeEnum.REM) {
                throw new DmcValueException("Extraneous tokens in a REM operation. Should be just " + this.attributeName + " REM");
            }
            if (this.operation == ModifyTypeEnum.NTH) {
                int space3 = trimmed.indexOf(" ", space2 + 1);
                if (space3 != -1) {
                    this.value = trimmed.substring(space3 + 1).trim();
                }
            } else {
                this.value = trimmed.substring(space2 + 1).trim();
            }
        }
        this.haveAttribute = false;
    }

    public int getAttributeID() {
        if (this.attribute == null) {
            return this.attributeID;
        }
        return this.attribute.getID();
    }

    public DmcAttributeInfo getAttributeInfo() {
        if (this.attribute == null) {
            if (this.attributeID == -1) {
                return DmcOmni.instance().getAttributeInfo(this.attributeName);
            }
            return DmcOmni.instance().getInfo(this.attributeID);
        }
        return this.attribute.getAttributeInfo();
    }

    public DmcAttribute<?> getAttribute() {
        if (this.attribute != null) {
            this.attribute.getAttributeInfo();
        }
        return this.attribute;
    }

    public DmcNamedObjectIF getReferringObject() {
        return this.referringObject;
    }

    public boolean isResolved() {
        if (this.attribute == null) {
            if (this.operation == ModifyTypeEnum.REM) {
                return true;
            }
            return this.operation == ModifyTypeEnum.NTH;
        }
        return true;
    }

    public ModifyTypeEnum getModifyType() {
        return this.operation;
    }

    public int getIndex() {
        return this.index;
    }

    public String getAttributeName() {
        if (this.attributeName == null) {
            if (this.attribute == null) {
                throw new IllegalStateException("Malformed Modifier, neither attributeName nor attribute is available.");
            }
            return this.attribute.getName();
        }
        return this.attributeName;
    }

    public Object getValue() {
        return this.value;
    }

    public String getPartName() {
        return this.partName;
    }

    public String toString() {
        if (this.attribute != null && this.attribute.getAttributeInfo() == null) {
            this.attribute.setAttributeInfo(DmcOmni.instance().getAttributeInfo(this.getAttributeName()));
        }
        if (this.operation == ModifyTypeEnum.REM) {
            return this.getAttributeName() + " " + (Object)((Object)this.operation);
        }
        if (this.operation == ModifyTypeEnum.NTH) {
            if (this.value == null) {
                if (this.attribute == null) {
                    return this.getAttributeName() + " " + (Object)((Object)this.operation);
                }
                return this.getAttributeName() + " " + (Object)((Object)this.operation) + " " + this.index + " " + this.attribute.modifierFormat();
            }
            if (this.value.equals("none")) {
                return this.attributeName + " " + (Object)((Object)this.operation) + " " + this.index;
            }
            return this.attributeName + " " + (Object)((Object)this.operation) + " " + this.index + " " + this.value.toString();
        }
        if (this.value == null) {
            return this.getAttributeName() + " " + (Object)((Object)this.operation) + " " + this.attribute.modifierFormat();
        }
        return this.attributeName + " " + (Object)((Object)this.operation) + " " + this.value.toString();
    }

    public void serializeIt(DmcOutputStreamIF dos) throws Exception {
        dos.writeInt(this.operation.intValue());
        dos.writeBoolean(this.haveAttribute);
        if (this.haveAttribute.booleanValue()) {
            this.attribute.serializeIt(dos);
        } else {
            dos.writeUTF(this.attributeName);
            dos.writeInt(this.attributeID);
            dos.writeUTF(this.value);
        }
        if (this.operation == ModifyTypeEnum.NTH) {
            dos.writeInt(this.index);
        }
    }

    public void deserializeIt(DmcInputStreamIF dis) throws Exception {
        this.operation = ModifyTypeEnum.get(dis.readInt());
        this.haveAttribute = dis.readBoolean();
        if (this.haveAttribute.booleanValue()) {
            this.attribute = dis.getAttributeInstance();
            this.attribute.deserializeIt(dis);
        } else {
            this.attributeName = dis.readUTF();
            this.attributeID = dis.readInt();
            this.value = dis.readUTF();
        }
        if (this.operation == ModifyTypeEnum.NTH) {
            this.index = dis.readInt();
        }
    }
}

