/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.types;

import java.io.Serializable;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcMappedAttributeIF;
import org.dmd.dmc.DmcOutputStreamIF;

public class StringToString
implements DmcMappedAttributeIF,
Serializable,
Comparable<StringToString> {
    String key;
    String value;

    public StringToString() {
        this.key = null;
        this.value = null;
    }

    public StringToString(String k) {
        if (k == null) {
            throw new IllegalStateException("The key value of a StringToString cannot be null");
        }
        this.key = k;
        this.value = "";
    }

    public StringToString(String k, String v) {
        if (k == null) {
            throw new IllegalStateException("The key value of a StringToString cannot be null");
        }
        this.key = k;
        this.value = v;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public String getKeyAsString() {
        if (this.key == null) {
            return "null";
        }
        return this.key;
    }

    public String toString() {
        if (this.key == null) {
            if (this.value == null) {
                return "null null";
            }
            return "null " + this.value;
        }
        if (this.value == null) {
            return this.key + " null";
        }
        return this.key + " " + this.value;
    }

    public String getValue() {
        return this.value;
    }

    public void serializeIt(DmcOutputStreamIF dos) throws Exception {
        dos.writeUTF(this.key);
        dos.writeUTF(this.value);
    }

    public void deserializeIt(DmcInputStreamIF dis) throws Exception {
        this.key = dis.readUTF();
        this.value = dis.readUTF();
    }

    public boolean equals(Object obj) {
        if (obj instanceof StringToString) {
            return this.valuesAreEqual((StringToString)obj);
        }
        return false;
    }

    @Override
    public boolean valuesAreEqual(DmcMappedAttributeIF obj) {
        boolean rc = false;
        if (obj instanceof StringToString) {
            StringToString other = (StringToString)obj;
            rc = this.key.equals(other.key) ? this.value.equals(other.value) : false;
        }
        return rc;
    }

    @Override
    public int compareTo(StringToString o) {
        if (this.key == null) {
            return -1;
        }
        if (o.key == null) {
            return 1;
        }
        return this.key.compareTo(o.key);
    }
}

