/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.types;

import java.io.Serializable;
import java.util.Date;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcMappedAttributeIF;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.util.DateUtil;

public class TimeDoubleDataPoint
implements DmcMappedAttributeIF,
Serializable {
    Date date;
    double value;

    public TimeDoubleDataPoint() {
        this.date = null;
        this.value = 0.0;
    }

    public TimeDoubleDataPoint(TimeDoubleDataPoint original) {
        this.date = original.date;
        this.value = original.value;
    }

    public void serializeIt(DmcOutputStreamIF dos) throws Exception {
        dos.writeLong(this.date.getTime());
        dos.writeDouble(this.value);
    }

    public void deserializeIt(DmcInputStreamIF dis) throws Exception {
        this.date = new Date(dis.readLong());
        this.value = dis.readDouble();
    }

    public TimeDoubleDataPoint(Date d, int v) {
        this.date = d;
        this.value = v;
    }

    public TimeDoubleDataPoint(String v) throws DmcValueException {
        this.set(v);
    }

    public void set(String val) throws DmcValueException {
        if (val == null) {
            throw new DmcValueException("null value passed to TimeDataPoint.set()");
        }
        String v = val.trim();
        int space = v.lastIndexOf(" ");
        if (space == -1) {
            throw new DmcValueException("Incorrect number of tokens for an TimeDataPoint: " + v);
        }
        this.date = DateUtil.parse(v.substring(0, space));
        try {
            this.value = Double.parseDouble(v.substring(space + 1));
        }
        catch (NumberFormatException ex) {
            throw new DmcValueException("Invalid Y value for an TimeDataPoint: " + v.substring(space + 1));
        }
    }

    public Date getDate() {
        return this.date;
    }

    public double getValue() {
        return this.value;
    }

    public String toString() {
        return DateUtil.formatComplete(this.date) + " " + this.value;
    }

    public boolean equals(Object v) {
        return v instanceof TimeDoubleDataPoint && this.date.equals(((TimeDoubleDataPoint)v).date) && this.value == ((TimeDoubleDataPoint)v).value;
    }

    @Override
    public Object getKey() {
        return this.date;
    }

    @Override
    public String getKeyAsString() {
        return DateUtil.formatComplete(this.date);
    }

    @Override
    public boolean valuesAreEqual(DmcMappedAttributeIF obj) {
        if (obj instanceof TimeDoubleDataPoint) {
            TimeDoubleDataPoint other = (TimeDoubleDataPoint)obj;
            if (this.date.equals(other.date) && this.value == other.value) {
                return true;
            }
        }
        return false;
    }
}

