/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.types;

import java.io.Serializable;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;

public class UUIDLite
implements Comparable<Object>,
Serializable {
    long mostSigBits;
    long leastSigBits;
    transient String asString;
    transient int hash;

    public UUIDLite() {
        this.mostSigBits = 0L;
        this.leastSigBits = 0L;
        this.asString = null;
        this.hash = -1;
    }

    public UUIDLite(String s) throws DmcValueException {
        this.parseString(s);
        this.asString = null;
        this.hash = -1;
    }

    public UUIDLite(UUIDLite u) {
        this.mostSigBits = u.mostSigBits;
        this.leastSigBits = u.leastSigBits;
        this.asString = null;
        this.hash = -1;
    }

    public UUIDLite(long msb, long lsb) {
        this.mostSigBits = msb;
        this.leastSigBits = lsb;
        this.asString = null;
        this.hash = -1;
    }

    public long getMostSignificantBits() {
        return this.mostSigBits;
    }

    public long getLeastSignificantBits() {
        return this.leastSigBits;
    }

    void initHash() {
        int msbHash = (int)(this.mostSigBits ^ this.mostSigBits >>> 32);
        int lsbHash = (int)(this.leastSigBits ^ this.leastSigBits >>> 32);
        this.hash = msbHash ^ lsbHash;
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.initHash();
        }
        return this.hash;
    }

    private void parseString(String uuid) throws DmcValueException {
        int i;
        if (uuid == null) {
            throw new NullPointerException();
        }
        int[] position = new int[5];
        int lastPosition = 1;
        int startPosition = 0;
        for (i = 0; i < position.length && lastPosition > 0; ++i) {
            position[i] = uuid.indexOf("-", startPosition);
            lastPosition = position[i];
            startPosition = position[i] + 1;
        }
        if (i != position.length || lastPosition != -1) {
            throw new DmcValueException("String does not conform to UUID format: " + uuid);
        }
        long m1 = Long.parseLong(uuid.substring(0, position[0]), 16);
        long m2 = Long.parseLong(uuid.substring(position[0] + 1, position[1]), 16);
        long m3 = Long.parseLong(uuid.substring(position[1] + 1, position[2]), 16);
        long lsb1 = Long.parseLong(uuid.substring(position[2] + 1, position[3]), 16);
        long lsb2 = Long.parseLong(uuid.substring(position[3] + 1), 16);
        this.mostSigBits = m1 << 32 | m2 << 16 | m3;
        this.leastSigBits = lsb1 << 48 | lsb2;
    }

    public String toString() {
        if (this.asString == null) {
            StringBuilder builder = new StringBuilder(36);
            String msbStr = Long.toHexString(this.mostSigBits);
            if (msbStr.length() < 16) {
                int diff = 16 - msbStr.length();
                for (int i = 0; i < diff; ++i) {
                    builder.append('0');
                }
            }
            builder.append(msbStr);
            builder.insert(8, '-');
            builder.insert(13, '-');
            builder.append('-');
            String lsbStr = Long.toHexString(this.leastSigBits);
            if (lsbStr.length() < 16) {
                int diff = 16 - lsbStr.length();
                for (int i = 0; i < diff; ++i) {
                    builder.append('0');
                }
            }
            builder.append(lsbStr);
            builder.insert(23, '-');
            this.asString = builder.toString();
        }
        return this.asString;
    }

    @Override
    public int compareTo(Object obj) {
        int rc = -1;
        if (obj == this) {
            rc = 0;
        } else if (obj instanceof UUIDLite) {
            UUIDLite uuid = (UUIDLite)obj;
            if (this.mostSigBits != uuid.mostSigBits) {
                return this.mostSigBits < uuid.mostSigBits ? -1 : 1;
            }
            if (this.mostSigBits == uuid.mostSigBits) {
                if (this.leastSigBits != uuid.leastSigBits) {
                    return this.leastSigBits < uuid.leastSigBits ? -1 : 1;
                }
                if (this.leastSigBits == uuid.leastSigBits) {
                    rc = 0;
                }
            }
        }
        return rc;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof UUIDLite)) {
            return false;
        }
        UUIDLite that = (UUIDLite)object;
        return this.leastSigBits == that.leastSigBits && this.mostSigBits == that.mostSigBits;
    }

    public void serializeIt(DmcOutputStreamIF dos) throws Exception {
        dos.writeLong(this.leastSigBits);
        dos.writeLong(this.mostSigBits);
    }

    public void deserializeIt(DmcInputStreamIF dis) throws Exception {
        this.leastSigBits = dis.readLong();
        this.mostSigBits = dis.readLong();
    }
}

