/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.util;

import java.util.ArrayList;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.IntegerVar;
import org.dmd.dmc.util.ParsedNameValuePair;

public class ComplexTypeSplitter {
    public static boolean debug = false;

    public static ArrayList<ParsedNameValuePair> parse(String initialInput) throws DmcValueException {
        return ComplexTypeSplitter.parse(initialInput, ' ');
    }

    public static ArrayList<ParsedNameValuePair> parse(String initialInput, char separator) throws DmcValueException {
        return ComplexTypeSplitter.parse(initialInput, separator, -1);
    }

    public static ArrayList<ParsedNameValuePair> parse(String initialInput, char separator, int stopAfter) throws DmcValueException {
        if (initialInput == null) {
            throw new DmcValueException("No content to parse!");
        }
        ArrayList<ParsedNameValuePair> rc = new ArrayList<ParsedNameValuePair>();
        ParsedNameValuePair nvp = null;
        if (stopAfter == 0) {
            rc.add(new ParsedNameValuePair(initialInput));
            return rc;
        }
        String input = initialInput.trim();
        if ((input = input.replaceAll("(\\s)+", " ")).length() == 0) {
            throw new DmcValueException("No content to parse!");
        }
        IntegerVar position = new IntegerVar();
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == '\"') {
                position.set(i);
                nvp = ComplexTypeSplitter.parseQuotedText(input, null, position);
                rc.add(nvp);
                i = position.intValue();
            } else {
                if (input.charAt(i) == '=') {
                    throw new DmcValueException("Missing name for value");
                }
                position.set(i);
                nvp = ComplexTypeSplitter.parsePart(input, position, separator, stopAfter, rc.size());
                if (nvp != null) {
                    rc.add(nvp);
                }
                i = position.intValue();
            }
            if (i + 1 != input.length() || input.charAt(i) != separator) continue;
            rc.add(new ParsedNameValuePair());
        }
        return rc;
    }

    private static ParsedNameValuePair parseQuotedText(String input, String namePart, IntegerVar position) throws DmcValueException {
        ParsedNameValuePair rc = null;
        if (debug) {
            System.out.println("    -> parseQuoted i = " + position);
        }
        if (position.intValue() + 1 == input.length()) {
            throw new DmcValueException("Unmatched \"" + ComplexTypeSplitter.showErrorLocation(position.intValue() + 1, input));
        }
        for (int i = position.intValue() + 1; i < input.length(); ++i) {
            if (input.charAt(i) != '\"') continue;
            String quotedPart = input.substring(position.intValue() + 1, i);
            if (quotedPart.length() == 0) {
                quotedPart = "";
            }
            rc = new ParsedNameValuePair(namePart, quotedPart);
            position.set(i);
            break;
        }
        if (rc == null) {
            throw new DmcValueException("Unmatched \"" + ComplexTypeSplitter.showErrorLocation(input.length(), input));
        }
        if (debug) {
            System.out.println("    <- parseQuoted = " + position + "  - '" + input.charAt(position.intValue()) + "'");
        }
        return rc;
    }

    private static ParsedNameValuePair parsePart(String input, IntegerVar position, char separator, int stopAfter, int nvpCount) throws DmcValueException {
        ParsedNameValuePair rc = null;
        String namePart = null;
        boolean haveEquals = false;
        int afterEqualsPos = -1;
        int startPos = position.intValue();
        if (debug) {
            System.out.println("-> parsePart i = " + startPos);
        }
        for (int i = startPos; i < input.length(); ++i) {
            if (debug) {
                System.out.println("    i = " + i + "  - '" + input.charAt(i) + "'");
            }
            if (stopAfter != -1 && stopAfter == nvpCount) {
                rc = i + 1 == input.length() ? new ParsedNameValuePair(input.substring(i)) : new ParsedNameValuePair(input.substring(i));
                position.set(input.length());
                break;
            }
            if (input.charAt(i) == '\"') {
                if (namePart == null) {
                    throw new DmcValueException("Misplaced double quote (or missing double quote), expecting part of a name or an equals sign." + ComplexTypeSplitter.showErrorLocation(i, input));
                }
                if (!haveEquals) {
                    throw new DmcValueException("Missing = for value assignment." + ComplexTypeSplitter.showErrorLocation(i, input));
                }
                position.set(i);
                rc = ComplexTypeSplitter.parseQuotedText(input, namePart, position);
                break;
            }
            if (input.charAt(i) == '=') {
                haveEquals = true;
                afterEqualsPos = i + 1;
                namePart = input.substring(startPos, i);
                continue;
            }
            if (input.charAt(i) != separator) continue;
            if (i == startPos) {
                if (debug) {
                    System.out.println("    SEPARATOR AT START");
                }
                if (i == 0) {
                    rc = new ParsedNameValuePair();
                    break;
                }
                if (input.charAt(i - 1) == separator) {
                    rc = new ParsedNameValuePair();
                    break;
                }
                if (debug) {
                    System.out.println("<- parsePart = " + position + "  - '" + input.charAt(position.intValue()) + "'  NULL");
                }
                return null;
            }
            if (namePart == null) {
                namePart = input.substring(startPos, i);
                if (namePart.length() == 0) {
                    namePart = null;
                }
                rc = new ParsedNameValuePair(namePart);
                position.set(i);
                break;
            }
            if (!haveEquals) continue;
            if (i > afterEqualsPos) {
                rc = new ParsedNameValuePair(namePart, input.substring(afterEqualsPos, i));
                position.set(i);
                break;
            }
            throw new DmcValueException("Missing value after equals (=) - no spaces allowed on either side of equals." + ComplexTypeSplitter.showErrorLocation(i, input));
        }
        if (rc == null) {
            if (namePart == null) {
                rc = new ParsedNameValuePair(input.substring(startPos));
                position.set(input.length());
            } else if (haveEquals) {
                if (afterEqualsPos >= input.length()) {
                    throw new DmcValueException("Missing value after = " + ComplexTypeSplitter.showErrorLocation(input.length(), input));
                }
                rc = new ParsedNameValuePair(namePart, input.substring(afterEqualsPos));
                position.set(input.length());
            }
        }
        if (debug) {
            if (position.intValue() < input.length()) {
                System.out.println("<- parsePart = " + position + "  - '" + input.charAt(position.intValue()) + "'");
            } else {
                System.out.println("<- parsePart = " + position + "  - <EOL>");
            }
        }
        return rc;
    }

    private static String showErrorLocation(int position, String input) {
        StringBuffer sb = new StringBuffer("\n" + input + "\n");
        for (int i = 0; i < position; ++i) {
            sb.append(" ");
        }
        sb.append("^");
        return sb.toString();
    }
}

