/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.util;

import java.util.Date;
import org.dmd.dmc.DmcValueException;

public class DateUtil {
    static long dayMillis = 86400000L;
    static long hourMillis = 3600000L;
    static String[] months = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};

    public static Date parse(String value) throws DmcValueException {
        Date rc = new Date();
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        if (value.length() != 15) {
            throw new DmcValueException("Invalid date (incorrect length): " + value);
        }
        if (value.charAt(8) != ':') {
            throw new DmcValueException("Invalid date (missing colon): " + value);
        }
        try {
            year = Integer.parseInt(value.substring(0, 4));
        }
        catch (NumberFormatException ex) {
            throw new DmcValueException("Invalid year: " + value.substring(0, 4));
        }
        try {
            month = Integer.parseInt(value.substring(4, 6));
            if (month < 1 || month > 12) {
                throw new DmcValueException("Invalid month: " + month);
            }
        }
        catch (NumberFormatException ex) {
            throw new DmcValueException("Invalid month: " + value.substring(4, 6));
        }
        try {
            day = Integer.parseInt(value.substring(6, 8));
            if (day < 1 || day > 31) {
                throw new DmcValueException("Invalid day: " + day);
            }
        }
        catch (NumberFormatException ex) {
            throw new DmcValueException("Invalid day: " + value.substring(6, 8));
        }
        try {
            hour = Integer.parseInt(value.substring(9, 11));
            if (hour < 0 || hour > 23) {
                throw new DmcValueException("Invalid hour: " + hour);
            }
        }
        catch (NumberFormatException ex) {
            throw new DmcValueException("Invalid hour: " + value.substring(9, 11));
        }
        try {
            minute = Integer.parseInt(value.substring(11, 13));
            if (minute < 0 || minute > 59) {
                throw new DmcValueException("Invalid minute: " + minute);
            }
        }
        catch (NumberFormatException ex) {
            throw new DmcValueException("Invalid minute: " + value.substring(11, 13));
        }
        try {
            second = Integer.parseInt(value.substring(13));
            if (second < 0 || second > 59) {
                throw new DmcValueException("Invalid second: " + second);
            }
        }
        catch (NumberFormatException ex) {
            throw new DmcValueException("Invalid second: " + value.substring(13));
        }
        rc.setTime(0L);
        rc.setYear(year - 1900);
        rc.setMonth(month - 1);
        rc.setDate(day);
        rc.setHours(hour);
        rc.setMinutes(minute);
        rc.setSeconds(second);
        return rc;
    }

    public static String formatComplete(Date date) {
        String yearStr = "" + (date.getYear() + 1900);
        int month = date.getMonth() + 1;
        String monthStr = (month < 10 ? "0" : "") + month;
        int day = date.getDate();
        String dayStr = (day < 10 ? "0" : "") + day;
        int hour = date.getHours();
        String hourStr = (hour < 10 ? "0" : "") + hour;
        int minute = date.getMinutes();
        String minuteStr = (minute < 10 ? "0" : "") + minute;
        int second = date.getSeconds();
        String secondStr = (second < 10 ? "0" : "") + second;
        return yearStr + monthStr + dayStr + ":" + hourStr + minuteStr + secondStr;
    }

    public static String formatMonthDay(Date date) {
        String monthStr = months[date.getMonth()];
        int day = date.getDate();
        String dayStr = (day < 10 ? "0" : "") + day;
        return monthStr + " " + dayStr;
    }

    public static String formatHourMinute(Date date) {
        int hour = date.getHours();
        String hourStr = (hour < 10 ? "0" : "") + hour;
        int minute = date.getMinutes();
        String minuteStr = (minute < 10 ? "0" : "") + minute;
        return hourStr + ":" + minuteStr;
    }

    public static void addDays(Date date, int d) {
        long current = date.getTime();
        date.setTime(current + (long)d * dayMillis);
    }

    public static void subtractDays(Date date, int d) {
        long current = date.getTime();
        date.setTime(current - (long)d * dayMillis);
    }

    public static void addHours(Date date, int h) {
        long current = date.getTime();
        date.setTime(current + (long)h * hourMillis);
    }

    public static void subtractHours(Date date, int h) {
        long current = date.getTime();
        date.setTime(current - (long)h * hourMillis);
    }
}

