/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmc.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.dmc.util.NamedStringArray;

public class DmcUncheckedObject {
    protected TreeMap<String, NamedStringArray> attributes = new TreeMap();
    public ArrayList<String> classes;
    public int lineNumber;

    public DmcUncheckedObject() {
        this.classes = new ArrayList();
    }

    public DmcUncheckedObject(ArrayList<String> classNames, int ln) {
        this.classes = new ArrayList<String>(classNames);
        this.lineNumber = ln;
    }

    public String getConstructionClass() {
        if (this.classes.size() == 0) {
            throw new IllegalStateException("Construction class not set on this object:\n" + this.toOIF());
        }
        return this.classes.get(0);
    }

    public void setConstructionClass(String cn) {
        this.classes = new ArrayList();
        this.classes.add(cn);
    }

    public Iterator<String> getClasses() {
        return this.classes.iterator();
    }

    public void addToClasses(String c) {
        this.classes.add(c);
    }

    public void rem(String attribute) {
        this.attributes.remove(attribute);
    }

    public void addValue(String name, String value) {
        NamedStringArray attr = this.attributes.get(name);
        if (attr == null) {
            attr = new NamedStringArray(name);
            this.attributes.put(name, attr);
        }
        attr.add(value);
    }

    public String toOIF() {
        int longest = 0;
        for (NamedStringArray nsa : this.attributes.values()) {
            if (nsa.getName().length() <= longest) continue;
            longest = nsa.getName().length();
        }
        return this.toOIF(longest + 2);
    }

    private String toOIF(int padding) {
        StringBuffer sb = new StringBuffer();
        for (String str : this.classes) {
            sb.append(str + " ");
        }
        sb.append("\n");
        for (NamedStringArray nsa : this.attributes.values()) {
            nsa.toOIF(padding, sb);
        }
        return sb.toString();
    }

    public String getSV(String attrname) {
        NamedStringArray values = this.attributes.get(attrname);
        if (values == null) {
            return null;
        }
        if (values.size() > 1) {
            throw new IllegalStateException("Used getSV() on a multi-valued attribute: " + attrname);
        }
        return ((String)values.get(0)).trim();
    }

    public DmcUncheckedObject getOneOfMe() {
        return new DmcUncheckedObject();
    }

    public Iterator<String> getAttributeNames() {
        return this.attributes.keySet().iterator();
    }

    public void addAux(String cd) {
        this.classes.add(cd);
    }

    public NamedStringArray get(String name) {
        return this.attributes.get(name);
    }
}

