/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmg.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmg.generated.types.ActifactGeneratorREF;
import org.dmd.dmg.generated.types.DmcTypeActifactGeneratorREF;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeActifactGeneratorREFSET
extends DmcTypeActifactGeneratorREF
implements Serializable {
    private static final Iterator<ActifactGeneratorREF> emptyList = new HashSet().iterator();
    protected Set<ActifactGeneratorREF> value;

    public DmcTypeActifactGeneratorREFSET() {
        this.value = null;
    }

    public DmcTypeActifactGeneratorREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<ActifactGeneratorREF>() : new TreeSet<ActifactGeneratorREF>();
    }

    public DmcTypeActifactGeneratorREFSET getNew() {
        return new DmcTypeActifactGeneratorREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<ActifactGeneratorREF> cloneIt() {
        DmcTypeActifactGeneratorREFSET dmcTypeActifactGeneratorREFSET = this;
        synchronized (dmcTypeActifactGeneratorREFSET) {
            DmcTypeActifactGeneratorREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ActifactGeneratorREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActifactGeneratorREF add(Object v) throws DmcValueException {
        DmcTypeActifactGeneratorREFSET dmcTypeActifactGeneratorREFSET = this;
        synchronized (dmcTypeActifactGeneratorREFSET) {
            ActifactGeneratorREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActifactGeneratorREF del(Object v) {
        DmcTypeActifactGeneratorREFSET dmcTypeActifactGeneratorREFSET = this;
        synchronized (dmcTypeActifactGeneratorREFSET) {
            ActifactGeneratorREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ActifactGeneratorREF> getMV() {
        DmcTypeActifactGeneratorREFSET dmcTypeActifactGeneratorREFSET = this;
        synchronized (dmcTypeActifactGeneratorREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<ActifactGeneratorREF>(this.value).iterator();
            }
            return new TreeSet<ActifactGeneratorREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ActifactGeneratorREF> getMVCopy() {
        DmcTypeActifactGeneratorREFSET dmcTypeActifactGeneratorREFSET = this;
        synchronized (dmcTypeActifactGeneratorREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<ActifactGeneratorREF>();
                }
                return new HashSet<ActifactGeneratorREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<ActifactGeneratorREF>(this.value);
            }
            return new TreeSet<ActifactGeneratorREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeActifactGeneratorREFSET dmcTypeActifactGeneratorREFSET = this;
        synchronized (dmcTypeActifactGeneratorREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeActifactGeneratorREFSET dmcTypeActifactGeneratorREFSET = this;
        synchronized (dmcTypeActifactGeneratorREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                ActifactGeneratorREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

