/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmg.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmg.generated.dmo.DmgConfigDMO;
import org.dmd.dmg.generated.types.DmcTypeDmgConfigREF;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeDmgConfigREFSET
extends DmcTypeDmgConfigREF
implements Serializable {
    private static final Iterator<DmgConfigDMO> emptyList = new HashSet().iterator();
    protected Set<DmgConfigDMO> value;

    public DmcTypeDmgConfigREFSET() {
        this.value = null;
    }

    public DmcTypeDmgConfigREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<DmgConfigDMO>() : new TreeSet<DmgConfigDMO>();
    }

    public DmcTypeDmgConfigREFSET getNew() {
        return new DmcTypeDmgConfigREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<DmgConfigDMO> cloneIt() {
        DmcTypeDmgConfigREFSET dmcTypeDmgConfigREFSET = this;
        synchronized (dmcTypeDmgConfigREFSET) {
            DmcTypeDmgConfigREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (DmgConfigDMO val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmgConfigDMO add(Object v) throws DmcValueException {
        DmcTypeDmgConfigREFSET dmcTypeDmgConfigREFSET = this;
        synchronized (dmcTypeDmgConfigREFSET) {
            DmgConfigDMO rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmgConfigDMO del(Object v) {
        DmcTypeDmgConfigREFSET dmcTypeDmgConfigREFSET = this;
        synchronized (dmcTypeDmgConfigREFSET) {
            DmgConfigDMO rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<DmgConfigDMO> getMV() {
        DmcTypeDmgConfigREFSET dmcTypeDmgConfigREFSET = this;
        synchronized (dmcTypeDmgConfigREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<DmgConfigDMO>(this.value).iterator();
            }
            return new TreeSet<DmgConfigDMO>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DmgConfigDMO> getMVCopy() {
        DmcTypeDmgConfigREFSET dmcTypeDmgConfigREFSET = this;
        synchronized (dmcTypeDmgConfigREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<DmgConfigDMO>();
                }
                return new HashSet<DmgConfigDMO>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<DmgConfigDMO>(this.value);
            }
            return new TreeSet<DmgConfigDMO>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeDmgConfigREFSET dmcTypeDmgConfigREFSET = this;
        synchronized (dmcTypeDmgConfigREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeDmgConfigREFSET dmcTypeDmgConfigREFSET = this;
        synchronized (dmcTypeDmgConfigREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                DmgConfigDMO val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

