/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmg.generated.types;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.CamelCaseName;
import org.dmd.dmg.generated.types.DmcTypeGenerationContextREF;
import org.dmd.dmg.generated.types.GenerationContextREF;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeGenerationContextREFMAP
extends DmcTypeGenerationContextREF
implements Serializable {
    private static final Iterator<GenerationContextREF> emptyList = new HashMap().values().iterator();
    protected Map<CamelCaseName, GenerationContextREF> value;

    public DmcTypeGenerationContextREFMAP() {
        this.value = null;
    }

    public DmcTypeGenerationContextREFMAP(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<CamelCaseName, GenerationContextREF>() : new TreeMap<CamelCaseName, GenerationContextREF>();
    }

    public CamelCaseName firstKey() {
        if (this.getAttributeInfo().valueType == ValueTypeEnum.TREEMAPPED) {
            if (this.value == null) {
                return null;
            }
            TreeMap map = (TreeMap)this.value;
            return (CamelCaseName)map.firstKey();
        }
        throw new IllegalStateException("Attribute " + this.getAttributeInfo().name + " is HASHMAPPED and doesn't support firstKey()");
    }

    public DmcTypeGenerationContextREFMAP getNew() {
        return new DmcTypeGenerationContextREFMAP(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<GenerationContextREF> cloneIt() {
        DmcTypeGenerationContextREFMAP dmcTypeGenerationContextREFMAP = this;
        synchronized (dmcTypeGenerationContextREFMAP) {
            DmcTypeGenerationContextREFMAP rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (GenerationContextREF val : this.value.values()) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenerationContextREF add(Object v) throws DmcValueException {
        DmcTypeGenerationContextREFMAP dmcTypeGenerationContextREFMAP = this;
        synchronized (dmcTypeGenerationContextREFMAP) {
            CamelCaseName key;
            GenerationContextREF oldval;
            GenerationContextREF newval = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if ((oldval = this.value.put(key = (CamelCaseName)newval.getKey(), newval)) != null && oldval.valuesAreEqual(newval)) {
                newval = null;
            }
            return newval;
        }
    }

    @Override
    public GenerationContextREF del(Object key) {
        DmcTypeGenerationContextREFMAP dmcTypeGenerationContextREFMAP = this;
        synchronized (dmcTypeGenerationContextREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof CamelCaseName) {
                return this.value.remove(key);
            }
            throw new IllegalStateException("Incompatible key type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<GenerationContextREF> getMV() {
        DmcTypeGenerationContextREFMAP dmcTypeGenerationContextREFMAP = this;
        synchronized (dmcTypeGenerationContextREFMAP) {
            if (this.value == null) {
                return emptyList;
            }
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<CamelCaseName, GenerationContextREF>(this.value) : new TreeMap<CamelCaseName, GenerationContextREF>(this.value);
            return clone.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<CamelCaseName, GenerationContextREF> getMVCopy() {
        DmcTypeGenerationContextREFMAP dmcTypeGenerationContextREFMAP = this;
        synchronized (dmcTypeGenerationContextREFMAP) {
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? (this.value == null ? new HashMap() : new HashMap<CamelCaseName, GenerationContextREF>(this.value)) : (this.value == null ? new TreeMap() : new TreeMap<CamelCaseName, GenerationContextREF>(this.value));
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeGenerationContextREFMAP dmcTypeGenerationContextREFMAP = this;
        synchronized (dmcTypeGenerationContextREFMAP) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    @Override
    public GenerationContextREF getByKey(Object key) {
        DmcTypeGenerationContextREFMAP dmcTypeGenerationContextREFMAP = this;
        synchronized (dmcTypeGenerationContextREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof CamelCaseName) {
                return this.value.get((CamelCaseName)key);
            }
            throw new IllegalStateException("Incompatible type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeGenerationContextREFMAP dmcTypeGenerationContextREFMAP = this;
        synchronized (dmcTypeGenerationContextREFMAP) {
            if (this.value == null) {
                return false;
            }
            try {
                GenerationContextREF val = this.typeCheck(v);
                return this.value.containsValue(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        DmcTypeGenerationContextREFMAP dmcTypeGenerationContextREFMAP = this;
        synchronized (dmcTypeGenerationContextREFMAP) {
            if (this.value == null) {
                return false;
            }
            if (key instanceof CamelCaseName) {
                return this.value.containsKey(key);
            }
            return false;
        }
    }
}

