/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmg.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmg.generated.types.DmcTypeGenerationContextREF;
import org.dmd.dmg.generated.types.GenerationContextREF;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeGenerationContextREFSET
extends DmcTypeGenerationContextREF
implements Serializable {
    private static final Iterator<GenerationContextREF> emptyList = new HashSet().iterator();
    protected Set<GenerationContextREF> value;

    public DmcTypeGenerationContextREFSET() {
        this.value = null;
    }

    public DmcTypeGenerationContextREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<GenerationContextREF>() : new TreeSet<GenerationContextREF>();
    }

    public DmcTypeGenerationContextREFSET getNew() {
        return new DmcTypeGenerationContextREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<GenerationContextREF> cloneIt() {
        DmcTypeGenerationContextREFSET dmcTypeGenerationContextREFSET = this;
        synchronized (dmcTypeGenerationContextREFSET) {
            DmcTypeGenerationContextREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (GenerationContextREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenerationContextREF add(Object v) throws DmcValueException {
        DmcTypeGenerationContextREFSET dmcTypeGenerationContextREFSET = this;
        synchronized (dmcTypeGenerationContextREFSET) {
            GenerationContextREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenerationContextREF del(Object v) {
        DmcTypeGenerationContextREFSET dmcTypeGenerationContextREFSET = this;
        synchronized (dmcTypeGenerationContextREFSET) {
            GenerationContextREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<GenerationContextREF> getMV() {
        DmcTypeGenerationContextREFSET dmcTypeGenerationContextREFSET = this;
        synchronized (dmcTypeGenerationContextREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<GenerationContextREF>(this.value).iterator();
            }
            return new TreeSet<GenerationContextREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<GenerationContextREF> getMVCopy() {
        DmcTypeGenerationContextREFSET dmcTypeGenerationContextREFSET = this;
        synchronized (dmcTypeGenerationContextREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<GenerationContextREF>();
                }
                return new HashSet<GenerationContextREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<GenerationContextREF>(this.value);
            }
            return new TreeSet<GenerationContextREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeGenerationContextREFSET dmcTypeGenerationContextREFSET = this;
        synchronized (dmcTypeGenerationContextREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeGenerationContextREFSET dmcTypeGenerationContextREFSET = this;
        synchronized (dmcTypeGenerationContextREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                GenerationContextREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

