/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmg.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmg.types.DmcTypeGenerator;
import org.dmd.dmg.types.Generator;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeGeneratorSET
extends DmcTypeGenerator
implements Serializable {
    private static final Iterator<Generator> emptyList = new HashSet().iterator();
    protected Set<Generator> value;

    public DmcTypeGeneratorSET() {
        this.value = null;
    }

    public DmcTypeGeneratorSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<Generator>() : new TreeSet<Generator>();
    }

    public DmcTypeGeneratorSET getNew() {
        return new DmcTypeGeneratorSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<Generator> cloneIt() {
        DmcTypeGeneratorSET dmcTypeGeneratorSET = this;
        synchronized (dmcTypeGeneratorSET) {
            DmcTypeGeneratorSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (Generator val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Generator add(Object v) throws DmcValueException {
        DmcTypeGeneratorSET dmcTypeGeneratorSET = this;
        synchronized (dmcTypeGeneratorSET) {
            Generator rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Generator del(Object v) {
        DmcTypeGeneratorSET dmcTypeGeneratorSET = this;
        synchronized (dmcTypeGeneratorSET) {
            Generator rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Generator> getMV() {
        DmcTypeGeneratorSET dmcTypeGeneratorSET = this;
        synchronized (dmcTypeGeneratorSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<Generator>(this.value).iterator();
            }
            return new TreeSet<Generator>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Generator> getMVCopy() {
        DmcTypeGeneratorSET dmcTypeGeneratorSET = this;
        synchronized (dmcTypeGeneratorSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<Generator>();
                }
                return new HashSet<Generator>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<Generator>(this.value);
            }
            return new TreeSet<Generator>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeGeneratorSET dmcTypeGeneratorSET = this;
        synchronized (dmcTypeGeneratorSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeGeneratorSET dmcTypeGeneratorSET = this;
        synchronized (dmcTypeGeneratorSET) {
            if (this.value == null) {
                return false;
            }
            try {
                Generator val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

