/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmg.generated.types;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dmg.generated.types.DmcTypeMethodGeneratorREF;
import org.dmd.dmg.generated.types.MethodGeneratorREF;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeMethodGeneratorREFMAP
extends DmcTypeMethodGeneratorREF
implements Serializable {
    private static final Iterator<MethodGeneratorREF> emptyList = new HashMap().values().iterator();
    protected Map<DefinitionName, MethodGeneratorREF> value;

    public DmcTypeMethodGeneratorREFMAP() {
        this.value = null;
    }

    public DmcTypeMethodGeneratorREFMAP(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<DefinitionName, MethodGeneratorREF>() : new TreeMap<DefinitionName, MethodGeneratorREF>();
    }

    public DefinitionName firstKey() {
        if (this.getAttributeInfo().valueType == ValueTypeEnum.TREEMAPPED) {
            if (this.value == null) {
                return null;
            }
            TreeMap map = (TreeMap)this.value;
            return (DefinitionName)map.firstKey();
        }
        throw new IllegalStateException("Attribute " + this.getAttributeInfo().name + " is HASHMAPPED and doesn't support firstKey()");
    }

    public DmcTypeMethodGeneratorREFMAP getNew() {
        return new DmcTypeMethodGeneratorREFMAP(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<MethodGeneratorREF> cloneIt() {
        DmcTypeMethodGeneratorREFMAP dmcTypeMethodGeneratorREFMAP = this;
        synchronized (dmcTypeMethodGeneratorREFMAP) {
            DmcTypeMethodGeneratorREFMAP rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (MethodGeneratorREF val : this.value.values()) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MethodGeneratorREF add(Object v) throws DmcValueException {
        DmcTypeMethodGeneratorREFMAP dmcTypeMethodGeneratorREFMAP = this;
        synchronized (dmcTypeMethodGeneratorREFMAP) {
            DefinitionName key;
            MethodGeneratorREF oldval;
            MethodGeneratorREF newval = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if ((oldval = this.value.put(key = (DefinitionName)newval.getKey(), newval)) != null && oldval.valuesAreEqual(newval)) {
                newval = null;
            }
            return newval;
        }
    }

    @Override
    public MethodGeneratorREF del(Object key) {
        DmcTypeMethodGeneratorREFMAP dmcTypeMethodGeneratorREFMAP = this;
        synchronized (dmcTypeMethodGeneratorREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof DefinitionName) {
                return this.value.remove(key);
            }
            throw new IllegalStateException("Incompatible key type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<MethodGeneratorREF> getMV() {
        DmcTypeMethodGeneratorREFMAP dmcTypeMethodGeneratorREFMAP = this;
        synchronized (dmcTypeMethodGeneratorREFMAP) {
            if (this.value == null) {
                return emptyList;
            }
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<DefinitionName, MethodGeneratorREF>(this.value) : new TreeMap<DefinitionName, MethodGeneratorREF>(this.value);
            return clone.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<DefinitionName, MethodGeneratorREF> getMVCopy() {
        DmcTypeMethodGeneratorREFMAP dmcTypeMethodGeneratorREFMAP = this;
        synchronized (dmcTypeMethodGeneratorREFMAP) {
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? (this.value == null ? new HashMap() : new HashMap<DefinitionName, MethodGeneratorREF>(this.value)) : (this.value == null ? new TreeMap() : new TreeMap<DefinitionName, MethodGeneratorREF>(this.value));
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeMethodGeneratorREFMAP dmcTypeMethodGeneratorREFMAP = this;
        synchronized (dmcTypeMethodGeneratorREFMAP) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    @Override
    public MethodGeneratorREF getByKey(Object key) {
        DmcTypeMethodGeneratorREFMAP dmcTypeMethodGeneratorREFMAP = this;
        synchronized (dmcTypeMethodGeneratorREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof DefinitionName) {
                return this.value.get((DefinitionName)key);
            }
            throw new IllegalStateException("Incompatible type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeMethodGeneratorREFMAP dmcTypeMethodGeneratorREFMAP = this;
        synchronized (dmcTypeMethodGeneratorREFMAP) {
            if (this.value == null) {
                return false;
            }
            try {
                MethodGeneratorREF val = this.typeCheck(v);
                return this.value.containsValue(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        DmcTypeMethodGeneratorREFMAP dmcTypeMethodGeneratorREFMAP = this;
        synchronized (dmcTypeMethodGeneratorREFMAP) {
            if (this.value == null) {
                return false;
            }
            if (key instanceof DefinitionName) {
                return this.value.containsKey(key);
            }
            return false;
        }
    }
}

