/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmg.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmg.generated.types.DmcTypeMethodGeneratorREF;
import org.dmd.dmg.generated.types.MethodGeneratorREF;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeMethodGeneratorREFSET
extends DmcTypeMethodGeneratorREF
implements Serializable {
    private static final Iterator<MethodGeneratorREF> emptyList = new HashSet().iterator();
    protected Set<MethodGeneratorREF> value;

    public DmcTypeMethodGeneratorREFSET() {
        this.value = null;
    }

    public DmcTypeMethodGeneratorREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<MethodGeneratorREF>() : new TreeSet<MethodGeneratorREF>();
    }

    public DmcTypeMethodGeneratorREFSET getNew() {
        return new DmcTypeMethodGeneratorREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<MethodGeneratorREF> cloneIt() {
        DmcTypeMethodGeneratorREFSET dmcTypeMethodGeneratorREFSET = this;
        synchronized (dmcTypeMethodGeneratorREFSET) {
            DmcTypeMethodGeneratorREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (MethodGeneratorREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MethodGeneratorREF add(Object v) throws DmcValueException {
        DmcTypeMethodGeneratorREFSET dmcTypeMethodGeneratorREFSET = this;
        synchronized (dmcTypeMethodGeneratorREFSET) {
            MethodGeneratorREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MethodGeneratorREF del(Object v) {
        DmcTypeMethodGeneratorREFSET dmcTypeMethodGeneratorREFSET = this;
        synchronized (dmcTypeMethodGeneratorREFSET) {
            MethodGeneratorREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<MethodGeneratorREF> getMV() {
        DmcTypeMethodGeneratorREFSET dmcTypeMethodGeneratorREFSET = this;
        synchronized (dmcTypeMethodGeneratorREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<MethodGeneratorREF>(this.value).iterator();
            }
            return new TreeSet<MethodGeneratorREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<MethodGeneratorREF> getMVCopy() {
        DmcTypeMethodGeneratorREFSET dmcTypeMethodGeneratorREFSET = this;
        synchronized (dmcTypeMethodGeneratorREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<MethodGeneratorREF>();
                }
                return new HashSet<MethodGeneratorREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<MethodGeneratorREF>(this.value);
            }
            return new TreeSet<MethodGeneratorREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeMethodGeneratorREFSET dmcTypeMethodGeneratorREFSET = this;
        synchronized (dmcTypeMethodGeneratorREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeMethodGeneratorREFSET dmcTypeMethodGeneratorREFSET = this;
        synchronized (dmcTypeMethodGeneratorREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                MethodGeneratorREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

