/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmg.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmg.generated.types.DmcTypeWrapperGeneratorREF;
import org.dmd.dmg.generated.types.WrapperGeneratorREF;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeWrapperGeneratorREFSET
extends DmcTypeWrapperGeneratorREF
implements Serializable {
    private static final Iterator<WrapperGeneratorREF> emptyList = new HashSet().iterator();
    protected Set<WrapperGeneratorREF> value;

    public DmcTypeWrapperGeneratorREFSET() {
        this.value = null;
    }

    public DmcTypeWrapperGeneratorREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<WrapperGeneratorREF>() : new TreeSet<WrapperGeneratorREF>();
    }

    public DmcTypeWrapperGeneratorREFSET getNew() {
        return new DmcTypeWrapperGeneratorREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<WrapperGeneratorREF> cloneIt() {
        DmcTypeWrapperGeneratorREFSET dmcTypeWrapperGeneratorREFSET = this;
        synchronized (dmcTypeWrapperGeneratorREFSET) {
            DmcTypeWrapperGeneratorREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (WrapperGeneratorREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WrapperGeneratorREF add(Object v) throws DmcValueException {
        DmcTypeWrapperGeneratorREFSET dmcTypeWrapperGeneratorREFSET = this;
        synchronized (dmcTypeWrapperGeneratorREFSET) {
            WrapperGeneratorREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WrapperGeneratorREF del(Object v) {
        DmcTypeWrapperGeneratorREFSET dmcTypeWrapperGeneratorREFSET = this;
        synchronized (dmcTypeWrapperGeneratorREFSET) {
            WrapperGeneratorREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<WrapperGeneratorREF> getMV() {
        DmcTypeWrapperGeneratorREFSET dmcTypeWrapperGeneratorREFSET = this;
        synchronized (dmcTypeWrapperGeneratorREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<WrapperGeneratorREF>(this.value).iterator();
            }
            return new TreeSet<WrapperGeneratorREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<WrapperGeneratorREF> getMVCopy() {
        DmcTypeWrapperGeneratorREFSET dmcTypeWrapperGeneratorREFSET = this;
        synchronized (dmcTypeWrapperGeneratorREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<WrapperGeneratorREF>();
                }
                return new HashSet<WrapperGeneratorREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<WrapperGeneratorREF>(this.value);
            }
            return new TreeSet<WrapperGeneratorREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeWrapperGeneratorREFSET dmcTypeWrapperGeneratorREFSET = this;
        synchronized (dmcTypeWrapperGeneratorREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeWrapperGeneratorREFSET dmcTypeWrapperGeneratorREFSET = this;
        synchronized (dmcTypeWrapperGeneratorREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                WrapperGeneratorREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

