/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmg.generators;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dmg.DarkMatterGeneratorIF;
import org.dmd.dmg.generated.dmo.DmgConfigDMO;
import org.dmd.dmg.util.GeneratorUtils;
import org.dmd.dmg.util.SchemaFormatter;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.ClassDefinition;
import org.dmd.dms.ExtendedReferenceTypeDefinition;
import org.dmd.dms.MetaSchemaAG;
import org.dmd.dms.SchemaDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.TypeDefinition;
import org.dmd.dms.generated.dmw.ClassDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.ExtendedReferenceTypeDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.SchemaDefinitionDMW;
import org.dmd.dms.generated.dmw.TypeDefinitionIterableDMW;
import org.dmd.dms.generated.enums.ClassTypeEnum;
import org.dmd.dms.generated.enums.DataTypeEnum;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.enums.WrapperTypeEnum;
import org.dmd.dms.util.TypeAndAttr;
import org.dmd.util.FileUpdateManager;
import org.dmd.util.ManagedFileWriter;
import org.dmd.util.codegen.ImplementsManager;
import org.dmd.util.codegen.ImportManager;
import org.dmd.util.codegen.Manipulator;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.formatting.CodeFormatter;
import org.dmd.util.parsing.ConfigFinder;
import org.dmd.util.parsing.ConfigLocation;

public abstract class BaseDMWGenerator
implements DarkMatterGeneratorIF {
    protected String gendir;
    protected String dmwdir;
    protected String extendedDir;
    protected String fileHeader;
    protected ArrayList<AttributeDefinition> allAttr;
    protected PrintStream progress;
    protected SchemaManager schema;
    protected SchemaFormatter sformatter = new SchemaFormatter();
    protected StringBuffer attributeInfo;
    protected boolean anyMVAttributes;
    protected boolean anySVAttributes;
    protected boolean anyMVRefs;
    protected boolean anyAttributes;
    protected String genContext;
    protected String genSuffix;
    protected Boolean useWrappedObjectRefs = true;
    protected Boolean fullJavaEnvironment;
    protected String baseWrapperImport;
    String baseWrapper;
    protected String namedWrapperImport;
    String namedWrapper;
    protected String hierarchicWrapperImport;
    String hierarchicWrapper;

    @Override
    public void gatherUserInput(DmgConfigDMO config, ConfigLocation loc, ConfigFinder f, SchemaManager sm) {
    }

    @Override
    public void setProgressStream(PrintStream ps) {
        this.progress = ps;
    }

    @Override
    public void setFileHeader(String fh) {
        this.fileHeader = fh;
    }

    protected void createExtendedWrapperClasses(DmgConfigDMO config, ConfigLocation loc, ConfigFinder f, SchemaManager sm) throws IOException, ResultException {
        ClassDefinitionIterableDMW cdefs;
        int lastdot = -1;
        lastdot = this.baseWrapperImport.lastIndexOf(".");
        this.baseWrapper = this.baseWrapperImport.substring(lastdot + 1);
        lastdot = this.namedWrapperImport.lastIndexOf(".");
        this.namedWrapper = this.namedWrapperImport.substring(lastdot + 1);
        lastdot = this.hierarchicWrapperImport.lastIndexOf(".");
        this.hierarchicWrapper = this.hierarchicWrapperImport.substring(lastdot + 1);
        SchemaDefinition sd = sm.isSchema(config.getSchemaToLoad());
        if (sd.getDmwPackage(this.genContext) == null) {
            System.err.println("The " + sd.getName() + " schema must define a dmwTypeToPackage mapping for this context: " + this.genContext);
            System.err.println("You should do this for all other schemas on which this schema depends.\n");
            System.err.println("Example: dmwTypeToPackage gxt com.example.client\n");
            System.exit(1);
        }
        if ((cdefs = sd.getClassDefList()) != null) {
            while (cdefs.hasNext()) {
                ClassDefinition cd = (ClassDefinition)cdefs.next();
                if (cd.getUseWrapperType() != WrapperTypeEnum.EXTENDED || !cd.generateWrapper(this.genContext)) continue;
                cd.adjustJavaClass(this.genContext, this.genSuffix);
                if (cd.getClassType() == ClassTypeEnum.AUXILIARY) continue;
                if (cd.getJavaClass() == null) {
                    ResultException ex = new ResultException();
                    ex.addError("The " + cd.getName() + " class must define the javaClass attribute to facilitate wrapper creation.");
                    ex.result.lastResult().fileName(cd.getFile());
                    ex.result.lastResult().lineNumber(cd.getLineNumber());
                    throw ex;
                }
                this.dumpExtendedClass(config, loc, f, sm, cd);
            }
        }
    }

    protected void dumpExtendedClass(DmgConfigDMO config, ConfigLocation loc, ConfigFinder f, SchemaManager sm, ClassDefinition cd) throws IOException {
    }

    protected void createWrappers(DmgConfigDMO config, ConfigLocation loc, ConfigFinder f, SchemaManager sm) throws IOException, ResultException {
        ClassDefinitionIterableDMW cdefs;
        int lastdot = -1;
        lastdot = this.baseWrapperImport.lastIndexOf(".");
        this.baseWrapper = this.baseWrapperImport.substring(lastdot + 1);
        lastdot = this.namedWrapperImport.lastIndexOf(".");
        this.namedWrapper = this.namedWrapperImport.substring(lastdot + 1);
        lastdot = this.hierarchicWrapperImport.lastIndexOf(".");
        this.hierarchicWrapper = this.hierarchicWrapperImport.substring(lastdot + 1);
        SchemaDefinition sd = sm.isSchema(config.getSchemaToLoad());
        if (sd.getDmwPackage(this.genContext) == null) {
            System.err.println("The " + sd.getName() + " schema must define a dmwTypeToPackage mapping for this context: " + this.genContext);
            System.err.println("You should do this for all other schemas on which this schema depends.\n");
            System.err.println("Example: dmwTypeToPackage gxt com.example.client\n");
            System.exit(1);
        }
        if ((cdefs = sd.getClassDefList()) != null) {
            while (cdefs.hasNext()) {
                ClassDefinition cd = (ClassDefinition)cdefs.next();
                if (!cd.generateWrapper(this.genContext)) continue;
                cd.adjustJavaClass(this.genContext, this.genSuffix);
                if (cd.getClassType() == ClassTypeEnum.AUXILIARY) {
                    this.dumpAUX(cd, this.dmwdir);
                    continue;
                }
                if (cd.getJavaClass() == null) {
                    ResultException ex = new ResultException();
                    ex.addError("The " + cd.getName() + " class must define the javaClass attribute to facilitate wrapper creation.");
                    ex.result.lastResult().fileName(cd.getFile());
                    ex.result.lastResult().lineNumber(cd.getLineNumber());
                    throw ex;
                }
                this.dumpWrapper(config, loc, f, sm, cd);
            }
        }
        if (this.useWrappedObjectRefs.booleanValue()) {
            TypeDefinitionIterableDMW tdefs = sd.getInternalTypeDefList();
            while (tdefs.hasNext()) {
                TypeDefinition td = (TypeDefinition)tdefs.next();
                ClassDefinition cd = td.getOriginalClass();
                if (cd == null) continue;
                this.dumpIterable(config, loc, f, sm, cd, sd);
            }
            ExtendedReferenceTypeDefinitionIterableDMW extrefs = sd.getExtendedReferenceTypeDefList();
            while (extrefs.hasNext()) {
                ExtendedReferenceTypeDefinition ertd = (ExtendedReferenceTypeDefinition)extrefs.next();
                ClassDefinition cd = ertd.getExtendedReferenceClass();
                this.dumpExtendedReferenceIterable(config, loc, f, sm, cd, sd, ertd);
            }
        }
    }

    void dumpIterable(DmgConfigDMO config, ConfigLocation loc, ConfigFinder f, SchemaManager sm, ClassDefinition cd, SchemaDefinition thisSchema) throws IOException {
        if (cd.getIsNamedBy() == null) {
            return;
        }
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(this.dmwdir, cd.getName().getNameString() + "IterableDMW.java");
        String CAST = cd.getDmeClass();
        String REF = cd.getDmtClass();
        out.write("package " + cd.getDMWPackage() + ".generated.dmw;\n\n");
        out.write("import java.util.Iterator;\n\n");
        out.write("import org.dmd.dmw.DmwContainerIterator;\n");
        out.write("import " + cd.getDmtREFImport() + ";\n");
        if (cd.getUseWrapperType() == WrapperTypeEnum.EXTENDED) {
            out.write("import " + cd.getDmeImport() + ";\n");
            CAST = cd.getDmeClass();
        } else {
            out.write("import " + cd.getDmwImport() + ";\n");
            CAST = cd.getDmwClass();
        }
        out.write("/**\n");
        out.write(" * The " + cd.getName() + "IteratorDMW will cast from an underlying " + REF + " class to \n");
        out.write(" * the associated wrapper class: " + CAST + " when accessing object references in a wrapper context.\n");
        out.write(" * <P>\n");
        out.write(" * Generated from the " + ((SchemaDefinitionDMW)cd.getDefinedIn()).getName() + " schema at version " + ((SchemaDefinition)cd.getDefinedIn()).getVersion() + "\n");
        out.write(" * <P>\n");
        out.write(" * This code was auto-generated by the dmggenerator utility and shouldn't be altered manually!\n");
        out.write(" * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write(" */\n");
        out.write("public class " + cd.getName() + "IterableDMW extends DmwContainerIterator<" + CAST + "," + REF + "> {\n");
        out.write("\n");
        out.write("    public final static " + cd.getName() + "IterableDMW emptyList = new " + cd.getName() + "IterableDMW();\n");
        out.write("\n");
        out.write("    protected " + cd.getName() + "IterableDMW(){\n");
        out.write("        super();\n");
        out.write("    }\n");
        out.write("\n");
        out.write("    public " + cd.getName() + "IterableDMW(Iterator<" + REF + "> it){\n");
        out.write("        super(it);\n");
        out.write("    }\n");
        out.write("\n");
        out.write("}\n\n");
        ((BufferedWriter)out).close();
    }

    void dumpExtendedReferenceIterable(DmgConfigDMO config, ConfigLocation loc, ConfigFinder f, SchemaManager sm, ClassDefinition cd, SchemaDefinition thisSchema, ExtendedReferenceTypeDefinition ertd) throws IOException {
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(this.dmwdir, ertd.getName().getNameString() + "IterableDMW.java");
        String CAST = cd.getDmeClass();
        String REF = ertd.getName().getNameString();
        TypeDefinition td = sm.tdef(ertd.getName().getNameString());
        out.write("package " + cd.getDMWPackage() + ".generated.dmw;\n\n");
        out.write("import java.util.Iterator;\n\n");
        out.write("import org.dmd.dmw.DmwContainerIterator;\n");
        out.write("import " + td.getPrimitiveType() + ";\n");
        if (cd.getUseWrapperType() == WrapperTypeEnum.EXTENDED) {
            out.write("import " + cd.getDmeImport() + ";\n");
            CAST = cd.getDmeClass();
        } else {
            out.write("import " + cd.getDmwImport() + ";\n");
            CAST = cd.getDmwClass();
        }
        out.write("\n");
        out.write("/**\n");
        out.write(" * The " + ertd.getName().getNameString() + "IteratorDMW will cast from an underlying " + REF + " class to \n");
        out.write(" * the associated wrapper class: " + CAST + " when accessing object references in a wrapper context.\n");
        out.write(" * <P>\n");
        out.write(" * Generated from the " + ((SchemaDefinitionDMW)td.getDefinedIn()).getName() + " schema at version " + ((SchemaDefinition)td.getDefinedIn()).getVersion() + "\n");
        out.write(" * <P>\n");
        out.write(" * This code was auto-generated by the dmggenerator utility and shouldn't be altered manually!\n");
        out.write(" * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write(" */\n");
        out.write("public class " + ertd.getName().getNameString() + "IterableDMW extends DmwContainerIterator<" + CAST + "," + REF + "> {\n");
        out.write("\n");
        out.write("    public final static " + ertd.getName().getNameString() + "IterableDMW emptyList = new " + ertd.getName().getNameString() + "IterableDMW();\n");
        out.write("\n");
        out.write("    protected " + ertd.getName().getNameString() + "IterableDMW(){\n");
        out.write("        super();\n");
        out.write("    }\n");
        out.write("\n");
        out.write("    public " + ertd.getName().getNameString() + "IterableDMW(Iterator<" + REF + "> it){\n");
        out.write("        super(it);\n");
        out.write("    }\n");
        out.write("\n");
        out.write("}\n\n");
        ((BufferedWriter)out).close();
    }

    boolean isDefinition(ClassDefinition cd, ImportManager imports) {
        boolean rc = false;
        if (cd.isInstanceOfThis(MetaSchemaAG._DSDefinition)) {
            rc = true;
            imports.addImport("org.dmd.dmc.definitions.DmcDefinitionIF", "The object is a domain specific definition");
        }
        return rc;
    }

    void dumpWrapper(DmgConfigDMO config, ConfigLocation loc, ConfigFinder f, SchemaManager sm, ClassDefinition cd) throws IOException {
        this.attributeInfo = new StringBuffer();
        this.createIfRequired(this.dmwdir);
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(this.dmwdir, cd.getName().getNameString() + this.genSuffix + ".java");
        out.write("package " + cd.getDmwPackage(this.genContext) + ".generated." + this.genContext + ";\n\n");
        this.allAttr = new ArrayList();
        ImportManager imports = new ImportManager();
        this.getAttributesAndImports(cd, this.allAttr, imports);
        String accessFunctions = this.getAccessFunctions(cd, imports);
        this.getAdditionalWrapperImports(config, loc, f, sm, cd, imports);
        boolean isDefinition = this.isDefinition(cd, imports);
        out.write(imports.getFormattedImports() + "\n\n");
        ImplementsManager implManager = new ImplementsManager();
        String impl = "";
        if (cd.getIsNamedBy() != null) {
            if (cd.getIsNamedBy().getType().getIsHierarchicName().booleanValue()) {
                implManager.addImplements("DmcHierarchicNamedObjectIF");
                impl = "implements DmcHierarchicNamedObjectIF";
            } else {
                implManager.addImplements("DmcNamedObjectIF");
                impl = "implements DmcNamedObjectIF";
            }
        }
        if (this.genContext.equals("dmw") && cd.getUsesWrapperInterfaceSize() > 0) {
            Iterator<String> wit = cd.getUsesWrapperInterface();
            while (wit.hasNext()) {
                String tmp = wit.next();
                int lastDot = tmp.lastIndexOf(".");
                implManager.addImplements(tmp.substring(lastDot + 1));
            }
        }
        if (isDefinition) {
            implManager.addImplements("DmcDefinitionIF");
            impl = impl.length() > 0 ? impl + ", DmcDefinitionIF " : "implements DmcDefinitionIF ";
        } else {
            impl = impl + " ";
        }
        this.getAdditionalWrapperInterfaces(config, loc, f, sm, cd, implManager);
        impl = implManager.getFormattedImplementations();
        out.write("/**\n");
        CodeFormatter.dumpCodeComment(cd.getDescription(), (BufferedWriter)out, " * ");
        out.write(" * <P>\n");
        out.write(" * Generated from the " + ((SchemaDefinitionDMW)cd.getDefinedIn()).getName() + " schema at version " + ((SchemaDefinition)cd.getDefinedIn()).getVersion() + "\n");
        out.write(" * <P>\n");
        out.write(" * This code was auto-generated by the dmggenerator utility and shouldn't be alterred manually!\n");
        out.write(" * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write(" */\n");
        if (cd.getDerivedFrom() == null) {
            if (cd.getClassType() == ClassTypeEnum.ABSTRACT) {
                if (cd.getIsNamedBy() == null) {
                    out.write("abstract public class " + cd.getName() + this.genSuffix + " extends " + this.baseWrapper + " " + impl + "{\n");
                } else if (cd.getIsNamedBy().getType().getIsHierarchicName().booleanValue()) {
                    out.write("abstract public class " + cd.getName() + this.genSuffix + " extends " + this.hierarchicWrapper + " " + impl + "{\n");
                } else {
                    out.write("abstract public class " + cd.getName() + this.genSuffix + " extends " + this.namedWrapper + " " + impl + "{\n");
                }
            } else if (cd.getIsNamedBy() == null) {
                out.write("public class " + cd.getName() + this.genSuffix + " extends " + this.baseWrapper + " " + impl + "{\n");
            } else if (cd.getIsNamedBy().getType().getIsHierarchicName().booleanValue()) {
                out.write("public class " + cd.getName() + this.genSuffix + " extends " + this.hierarchicWrapper + " " + impl + "{\n");
            } else {
                out.write("public class " + cd.getName() + this.genSuffix + " extends " + this.namedWrapper + " " + impl + "{\n");
            }
        } else {
            if (cd.getDerivedFrom().getDMWPackage() != null) {
                cd.getDerivedFrom().adjustJavaClass(this.genContext, this.genSuffix);
            }
            if (cd.getDerivedFrom().getDmwWrapperType(this.genContext) == WrapperTypeEnum.EXTENDED) {
                if (cd.getDmwWrapperType(this.genContext) == WrapperTypeEnum.EXTENDED) {
                    out.write("abstract public class " + cd.getName() + this.genSuffix + " extends " + cd.getDerivedFrom().getName() + " " + impl + "{\n");
                } else if (cd.getClassType() == ClassTypeEnum.ABSTRACT) {
                    out.write("abstract public class " + cd.getName() + this.genSuffix + " extends " + cd.getDerivedFrom().getName() + " " + impl + "{\n");
                } else {
                    out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                    out.write("public class " + cd.getName() + this.genSuffix + " extends " + cd.getDerivedFrom().getName() + " " + impl + "{\n");
                }
            } else if (cd.getClassType() == ClassTypeEnum.ABSTRACT) {
                out.write("abstract public class " + cd.getName() + this.genSuffix + " extends " + cd.getDerivedFrom().getName() + this.genSuffix + " " + impl + "{\n");
            } else if (this.genContext.equals("dmw") && cd.getUsesWrapperInterfaceSize() > 0) {
                out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                out.write("abstract public class " + cd.getName() + this.genSuffix + " extends " + cd.getDerivedFrom().getName() + this.genSuffix + " " + impl + "{\n");
            } else {
                out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                out.write("public class " + cd.getName() + this.genSuffix + " extends " + cd.getDerivedFrom().getName() + this.genSuffix + " " + impl + "{\n");
            }
        }
        out.write("\n");
        this.dumpAdditionalWrapperDefinitions(config, loc, f, sm, cd, out);
        if (cd.getClassType() == ClassTypeEnum.ABSTRACT) {
            out.write("    protected " + cd.getName() + this.genSuffix + "() {\n");
            out.write("        super();\n");
            out.write("    }\n\n");
            if (cd.getDmwWrapperType(this.genContext) == WrapperTypeEnum.EXTENDED) {
                out.write("    abstract public " + cd.getName() + " getModificationRecorder();\n\n");
            } else {
                out.write("    abstract public " + cd.getName() + this.genSuffix + " getModificationRecorder();\n\n");
            }
        } else {
            String schemaName = GeneratorUtils.dotNameToCamelCase(((SchemaDefinitionDMW)cd.getDefinedIn()).getName().getNameString()) + "SchemaAG";
            String classDef = cd.getDmwPackage(this.genContext) + ".generated." + schemaName + "._" + cd.getName();
            if (this.fullJavaEnvironment.booleanValue()) {
                out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                out.write("    public " + cd.getName() + this.genSuffix + "() {\n");
                out.write("        super(new " + cd.getName() + "DMO(), " + classDef + ");\n");
                out.write("    }\n\n");
                out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                out.write("    public " + cd.getName() + this.genSuffix + "(DmcTypeModifierMV mods) {\n");
                out.write("        super(new " + cd.getName() + "DMO(mods), " + classDef + ");\n");
                out.write("    }\n\n");
            } else {
                out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                out.write("    public " + cd.getName() + this.genSuffix + "() {\n");
                out.write("        super(new " + cd.getName() + "DMO());\n");
                out.write("    }\n\n");
                out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                out.write("    public " + cd.getName() + this.genSuffix + "(DmcTypeModifierMV mods) {\n");
                out.write("        super(new " + cd.getName() + "DMO(mods));\n");
                out.write("    }\n\n");
            }
            if (cd.getIsNamedBy() == null) {
                if (cd.getDmwWrapperType(this.genContext) == WrapperTypeEnum.EXTENDED) {
                    out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                    out.write("    public " + cd.getName() + " getModificationRecorder(){\n");
                    out.write("        " + cd.getName() + " rc = new " + cd.getName() + "();\n");
                    out.write("        rc.setModifier(new DmcTypeModifierMV(MetaDMSAG.__modify));\n");
                    out.write("        return(rc);\n");
                    out.write("    }\n\n");
                } else {
                    out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                    out.write("    public " + cd.getName() + this.genSuffix + " getModificationRecorder(){\n");
                    out.write("        " + cd.getName() + this.genSuffix + " rc = new " + cd.getName() + this.genSuffix + "(new DmcTypeModifierMV(MetaDMSAG.__modify));\n");
                    out.write("        return(rc);\n");
                    out.write("    }\n\n");
                }
            } else {
                String upper = Manipulator.capFirstChar(cd.getIsNamedBy().getObjectName().toString());
                if (cd.getDmwWrapperType(this.genContext) == WrapperTypeEnum.EXTENDED) {
                    out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                    out.write("    public " + cd.getName() + " getModificationRecorder(){\n");
                    out.write("        " + cd.getName() + " rc = new " + cd.getName() + "();\n");
                    out.write("        rc.set" + upper + "(get" + upper + "());\n");
                    out.write("        rc.setModifier(new DmcTypeModifierMV(MetaDMSAG.__modify));\n");
                    out.write("        return(rc);\n");
                    out.write("    }\n\n");
                } else {
                    out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                    out.write("    public " + cd.getName() + this.genSuffix + " getModificationRecorder(){\n");
                    out.write("        " + cd.getName() + this.genSuffix + " rc = new " + cd.getName() + this.genSuffix + "();\n");
                    out.write("        rc.set" + upper + "(get" + upper + "());\n");
                    out.write("        rc.setModifier(new DmcTypeModifierMV(MetaDMSAG.__modify));\n");
                    out.write("        return(rc);\n");
                    out.write("    }\n\n");
                }
            }
            if (this.fullJavaEnvironment.booleanValue()) {
                out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                out.write("    public " + cd.getName() + "DMW(" + cd.getName() + "DMO obj) {\n");
                out.write("        super(obj, " + classDef + ");\n");
                out.write("    }\n\n");
            }
        }
        this.createCloneItMethod(out, config, loc, f, sm, cd);
        out.write("    public " + cd.getName() + "DMO getDMO() {\n");
        out.write("        return((" + cd.getName() + "DMO) core);\n");
        out.write("    }\n\n");
        if (this.fullJavaEnvironment.booleanValue()) {
            out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("    protected " + cd.getName() + this.genSuffix + "(" + cd.getName() + "DMO obj, ClassDefinition cd) {\n");
            out.write("        super(obj,cd);\n");
            out.write("    }\n\n");
        } else if (cd.getClassType() == ClassTypeEnum.ABSTRACT) {
            out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("    protected " + cd.getName() + this.genSuffix + "(" + cd.getName() + "DMO obj) {\n");
            out.write("        super(obj);\n");
            out.write("    }\n\n");
        } else {
            out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("    public " + cd.getName() + this.genSuffix + "(" + cd.getName() + "DMO obj) {\n");
            out.write("        super(obj);\n");
            out.write("    }\n\n");
        }
        out.write(accessFunctions);
        this.dumpAdditionalWrapperFunctions(config, loc, f, sm, cd, out);
        out.write("\n");
        out.write("}\n");
        ((BufferedWriter)out).close();
    }

    public void getAdditionalWrapperImports(DmgConfigDMO config, ConfigLocation loc, ConfigFinder f, SchemaManager sm, ClassDefinition cd, ImportManager imports) throws IOException {
    }

    public void getAdditionalWrapperInterfaces(DmgConfigDMO config, ConfigLocation loc, ConfigFinder f, SchemaManager sm, ClassDefinition cd, ImplementsManager implManager) throws IOException {
    }

    public void dumpAdditionalWrapperDefinitions(DmgConfigDMO config, ConfigLocation loc, ConfigFinder f, SchemaManager sm, ClassDefinition cd, BufferedWriter out) throws IOException {
    }

    public void dumpAdditionalWrapperFunctions(DmgConfigDMO config, ConfigLocation loc, ConfigFinder f, SchemaManager sm, ClassDefinition cd, BufferedWriter out) throws IOException {
    }

    protected void createCloneItMethod(BufferedWriter out, DmgConfigDMO config, ConfigLocation loc, ConfigFinder f, SchemaManager sm, ClassDefinition cd) throws IOException {
    }

    protected void dumpAUX(ClassDefinition cd, String outdir) throws IOException {
        this.attributeInfo = new StringBuffer();
        this.allAttr = new ArrayList();
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(outdir, cd.getName().getNameString() + ".java");
        String tmp = GeneratorUtils.dotNameToCamelCase(((SchemaDefinitionDMW)cd.getDefinedIn()).getName().getNameString());
        String schemaName = ((SchemaDefinition)cd.getDefinedIn()).getDmwPackage(this.genContext) + ".generated." + tmp + "SchemaAG";
        String classDef = schemaName + "._" + cd.getName();
        out.write("package " + ((SchemaDefinition)cd.getDefinedIn()).getDmwPackage(this.genContext) + ".generated.dmw;\n\n");
        this.anyMVAttributes = false;
        this.anySVAttributes = false;
        this.anyMVRefs = false;
        this.allAttr = new ArrayList();
        ImportManager imports = new ImportManager();
        this.getAttributesAndImports(cd, this.allAttr, imports);
        imports.addImport("org.dmd.dms.generated.enums.ValueTypeEnum", "For AUX base functionality");
        imports.addImport("org.dmd.dms.generated.enums.DataTypeEnum", "For AUX base functionality");
        out.write(imports.getFormattedImports() + "\n\n");
        out.write(this.getAuxClassHeader(cd, DebugInfo.getWhereWeAreNow()));
        out.write(" {\n\n");
        out.write("    public final static ClassDefinition _auxClass = " + classDef + ";\n");
        out.write(this.attributeInfo.toString() + "\n");
        out.write(this.getCommonAUXFunctions());
        out.write(this.getAUXAccessFunctions(cd));
        out.write("\n");
        out.write("\n\n}\n");
        ((BufferedWriter)out).close();
    }

    void appendAttributeInfo(StringBuffer out, String n, int ID, String t, ValueTypeEnum vte, DataTypeEnum dte) {
        out.append("    public final static DmcAttributeInfo __" + n + " = new DmcAttributeInfo(");
        out.append("\"" + n + "\",");
        out.append(ID + ",");
        out.append("\"" + t + "\",");
        out.append("ValueTypeEnum." + vte.toString() + ",");
        out.append("DataTypeEnum." + dte.toString() + ");\n");
    }

    public void getAttributesAndImports(ClassDefinition cd, ArrayList<AttributeDefinition> allAttr, ImportManager imports) {
        TreeMap<DefinitionName, TypeDefinition> types = new TreeMap<DefinitionName, TypeDefinition>();
        TreeMap<DefinitionName, TypeDefinition> iterables = new TreeMap<DefinitionName, TypeDefinition>();
        TreeSet<String> genericImports = new TreeSet<String>();
        TreeMap<String, TypeAndAttr> typeAndAttr = new TreeMap<String, TypeAndAttr>();
        boolean needDmwOmni = false;
        this.anyAttributes = false;
        cd.adjustJavaClass(this.genContext, this.genSuffix);
        for (AttributeDefinition ad : cd.getAllAttributesAtThisLevel().values()) {
            boolean shouldAddType = true;
            this.anyAttributes = true;
            TypeDefinition td = ad.getType();
            if (ad.getGenericArgs() != null && ad.getGenericArgs().equals("<DmcObjectName>")) {
                needDmwOmni = true;
            }
            switch (ad.getValueType()) {
                case SINGLE: {
                    this.anySVAttributes = true;
                    break;
                }
                case HASHMAPPED: 
                case TREEMAPPED: {
                    this.anyMVAttributes = true;
                    if (ad.getType().getIsRefType().booleanValue()) {
                        this.anyMVRefs = true;
                    }
                    iterables.put(td.getName(), td);
                    break;
                }
                case MULTI: 
                case HASHSET: 
                case TREESET: {
                    this.anyMVAttributes = true;
                    if (ad.getType().getIsRefType().booleanValue()) {
                        this.anyMVRefs = true;
                    }
                    iterables.put(td.getName(), td);
                }
            }
            if (shouldAddType) {
                types.put(td.getName(), td);
                TypeAndAttr ta = new TypeAndAttr(td, ad.getValueType(), ad.getIndexSize());
                typeAndAttr.put(ta.name, ta);
            }
            this.appendAttributeInfo(this.attributeInfo, ad.getName().getNameString(), ad.getDmdID(), ad.getType().getName().getNameString(), ad.getValueType(), ad.getDataType());
            if (ad.getGenericArgsImport() != null) {
                genericImports.add(ad.getGenericArgsImport());
            }
            if (!(ad.getValueType() == ValueTypeEnum.SINGLE || ad.getType().getIsExtendedRefType().booleanValue() || ad.getIndexSize() != null && ad.getType().getIsRefType().booleanValue())) {
                if (this.useWrappedObjectRefs.booleanValue() && cd.getClassType() != ClassTypeEnum.AUXILIARY) {
                    imports.addImport(((SchemaDefinition)ad.getDefinedIn()).getDMSASGImport(), "Attribute " + ad.getName() + " from the " + ((SchemaDefinitionDMW)ad.getDefinedIn()).getName() + " schema");
                } else if (ad.getValueType() == ValueTypeEnum.HASHMAPPED || ad.getValueType() == ValueTypeEnum.TREEMAPPED) {
                    imports.addImport(((SchemaDefinition)ad.getDefinedIn()).getDMSASGImport(), "Attribute " + ad.getName() + " from the " + ((SchemaDefinitionDMW)ad.getDefinedIn()).getName() + " schema");
                } else if (!ad.getType().getIsRefType().booleanValue() && cd.getClassType() != ClassTypeEnum.AUXILIARY) {
                    imports.addImport(((SchemaDefinition)ad.getDefinedIn()).getDMSASGImport(), "Attribute " + ad.getName() + " from the " + ((SchemaDefinitionDMW)ad.getDefinedIn()).getName() + " schema");
                }
            }
            allAttr.add(ad);
        }
        if (cd.getIsNamedBy() != null) {
            AttributeDefinition isNamedBy = cd.getIsNamedBy();
            String nameAttributeType = isNamedBy.getType().getPrimitiveType();
            imports.addImport(nameAttributeType, "Is named by");
        }
        if (this.useWrappedObjectRefs.booleanValue()) {
            imports.addImport("org.dmd.dms.ClassDefinition", "Passing derived class def up the hierarchy");
        }
        if (cd.getClassType() != ClassTypeEnum.ABSTRACT && cd.getClassType() != ClassTypeEnum.AUXILIARY) {
            imports.addImport("org.dmd.dms.generated.types.DmcTypeModifierMV", "Required for MODREC constructor");
            imports.addImport("org.dmd.dms.generated.dmo.MetaDMSAG", "Required for MODREC constructor");
        }
        if (cd.getDmwWrapperType(this.genContext) == WrapperTypeEnum.EXTENDED) {
            imports.addImport(cd.getDmeImport(), "Required for getModificationRecorder()");
        }
        if (this.genContext.equals("dmw") && cd.getUsesWrapperInterfaceSize() > 0) {
            if (cd.getDmwWrapperType(this.genContext) != WrapperTypeEnum.EXTENDED) {
                throw new IllegalStateException("The ClassDefinition: " + cd.getName() + " must useWrapperType EXTENDED in order to specify useWrapperInterface");
            }
            Iterator<String> wit = cd.getUsesWrapperInterface();
            while (wit.hasNext()) {
                imports.addImport(wit.next(), "Uses wrapper type");
            }
        }
        if (cd.getClassType() == ClassTypeEnum.AUXILIARY && this.anyMVAttributes) {
            imports.addImport("java.util.Iterator", "To iterate over MV attributes in an AUX class");
        }
        if (needDmwOmni) {
            imports.addImport("org.dmd.dmw.DmwOmni", "Have DmcObjectName attributes");
        }
        if (this.anyAttributes) {
            imports.addImport("org.dmd.dmc.*", "If any attributes");
        }
        for (String s : genericImports) {
            imports.addImport(s, "Generic args import");
        }
        for (TypeAndAttr ta : typeAndAttr.values()) {
            TypeDefinition td = ta.td;
            if (td.getIsRefType().booleanValue()) {
                if (this.useWrappedObjectRefs.booleanValue()) {
                    td.adjustJavaClass();
                    if (!td.getIsExtendedRefType().booleanValue() || ta.valueType != ValueTypeEnum.SINGLE) {
                        imports.addImport(td.getAuxHolderImport(), "Is reference type");
                    }
                    if (ta.valueType == ValueTypeEnum.SINGLE) {
                        if (td.getOriginalClass().getIsNamedBy() == null) {
                            imports.addImport(td.getOriginalClass().getDmoImport(), "Reference to unnamed object");
                        } else if (!td.getIsExtendedRefType().booleanValue()) {
                            imports.addImport(td.getOriginalClass().getDmtREFImport(), "Is reference type REF");
                        }
                    }
                    if (cd.getClassType() == ClassTypeEnum.AUXILIARY) {
                        imports.addImport(ta.getImport(), "Reference in an auxiliary class");
                    }
                    if (td.getOriginalClass().getIsNamedBy() != null && (ta.valueType == ValueTypeEnum.TREEMAPPED || ta.valueType == ValueTypeEnum.HASHMAPPED || ta.indexed) && !ta.td.getIsExtendedRefType().booleanValue()) {
                        imports.addImport(td.getOriginalClass().getDmtREFImport(), "To support getMVCopy() for REFs " + ta.name);
                    }
                } else {
                    if (ta.valueType == ValueTypeEnum.SINGLE) {
                        if (td.getOriginalClass().getIsNamedBy() == null) {
                            imports.addImport(td.getOriginalClass().getDmoImport(), "Reference to unnamed object");
                        } else if (!td.getIsExtendedRefType().booleanValue()) {
                            imports.addImport(td.getOriginalClass().getDmtREFImport(), "Is reference type REF");
                        }
                    }
                    imports.addImport(td.getPrimitiveType(), "DMO reference");
                    if (td.getHelperClassName() != null) {
                        imports.addImport(td.getHelperClassName(), "Helper class");
                    }
                }
            } else if (td.getPrimitiveType() != null) {
                imports.addImport(td.getPrimitiveType(), "Primitive type");
            } else if (cd.getClassType() == ClassTypeEnum.AUXILIARY) {
                imports.addImport(ta.getImport(), "Type in an auxiliary class");
            }
            if (td.getAltType() != null && td.getAltTypeImport() != null) {
                imports.addImport(td.getAltTypeImport(), "Alternative type for " + td.getName() + " values");
            }
            if (td.getKeyImport() != null) {
                imports.addImport(td.getKeyImport(), "Key class");
            }
            switch (ta.valueType) {
                case SINGLE: {
                    break;
                }
                case MULTI: {
                    if (ta.indexed || td.getIsRefType().booleanValue() && td.getOriginalClass().getIsNamedBy() == null || !this.useWrappedObjectRefs.booleanValue() || !td.getIsRefType().booleanValue()) break;
                    imports.addImport("java.util.ArrayList", "To support getMVCopy()");
                    break;
                }
                case HASHMAPPED: {
                    if (!this.useWrappedObjectRefs.booleanValue()) break;
                    imports.addImport("java.util.HashMap", "To support getMVCopy()");
                    break;
                }
                case TREEMAPPED: {
                    if (!this.useWrappedObjectRefs.booleanValue()) break;
                    imports.addImport("java.util.TreeMap", "To support getMVCopy()");
                    break;
                }
                case HASHSET: {
                    if (td.getIsRefType().booleanValue()) {
                        if (td.getOriginalClass().getIsNamedBy() == null || !this.useWrappedObjectRefs.booleanValue()) break;
                        imports.addImport("java.util.HashSet", "To support getMVCopy()");
                        break;
                    }
                    imports.addImport("java.util.HashSet", "To support getMVCopy()");
                    break;
                }
                case TREESET: {
                    if (td.getIsRefType().booleanValue()) {
                        if (td.getOriginalClass().getIsNamedBy() == null || !this.useWrappedObjectRefs.booleanValue()) break;
                        imports.addImport("java.util.TreeSet", "To support getMVCopy()");
                        break;
                    }
                    imports.addImport("java.util.TreeSet", "To support getMVCopy()");
                }
            }
        }
        if (cd.getClassType() == ClassTypeEnum.ABSTRACT) {
            imports.addImport(cd.getDmoImport(), "Abstract class");
        }
        if (cd.getDerivedFrom() == null) {
            if (cd.getIsNamedBy() == null) {
                imports.addImport(this.baseWrapperImport, "Unnamed object wrapper");
            } else if (cd.getIsNamedBy().getType().getIsHierarchicName().booleanValue()) {
                imports.addImport(this.hierarchicWrapperImport, "Hierarchic object wrapper");
            } else {
                imports.addImport(this.namedWrapperImport, "Named object wrapper");
            }
        } else {
            cd.getDerivedFrom().adjustJavaClass(this.genContext, this.genSuffix);
            imports.addImport(cd.getDerivedFrom().getJavaClass(), "Derived class");
        }
        if (cd.getClassType() != ClassTypeEnum.AUXILIARY && cd.getClassType() != ClassTypeEnum.ABSTRACT) {
            imports.addImport(cd.getDmoImport(), "Class not auxiliary or abstract");
        }
    }

    String getAccessFunctions(ClassDefinition cd, ImportManager imports) {
        StringBuffer sb = new StringBuffer();
        if (cd.getIsNamedBy() != null) {
            AttributeDefinition isNamedBy = cd.getIsNamedBy();
            String nameType = isNamedBy.getType().getName().getNameString();
            StringBuffer attrNameCapped = new StringBuffer();
            attrNameCapped.append(cd.getIsNamedBy().getName());
            attrNameCapped.setCharAt(0, Character.toUpperCase(attrNameCapped.charAt(0)));
            String dmocast = "((" + cd.getName() + "DMO) core)";
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public " + nameType + " getObjectName(){\n");
            sb.append("        return(" + dmocast + ".get" + attrNameCapped.toString() + "());\n");
            sb.append("    }\n\n");
            sb.append("    public int hashCode(){\n");
            sb.append("        return(getObjectName().hashCode());\n");
            sb.append("    }\n\n");
            sb.append("    public DmcAttribute<?> getObjectNameAttribute(){\n");
            sb.append("        return(" + dmocast + ".getObjectNameAttribute());\n");
            sb.append("    }\n\n");
            sb.append("    public boolean equals(Object obj){\n");
            sb.append("        if (obj instanceof " + cd.getName() + this.genSuffix + "){\n");
            sb.append("            return( getObjectName().equals( ((" + cd.getName() + this.genSuffix + ") obj).getObjectName()) );\n");
            sb.append("        }\n");
            sb.append("        return(false);\n");
            sb.append("    }\n\n");
            if (cd.getIsNamedBy().getType().getIsHierarchicName().booleanValue()) {
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public " + nameType + " getHierarchicObjectName(){\n");
                sb.append("        return(" + dmocast + ".get" + attrNameCapped.toString() + "());\n");
                sb.append("    }\n\n");
            }
        }
        for (AttributeDefinition ad : this.allAttr) {
            switch (ad.getValueType()) {
                case SINGLE: {
                    this.formatSV(cd, ad, sb, imports);
                    break;
                }
                case MULTI: 
                case HASHSET: 
                case TREESET: {
                    this.formatMV(cd, ad, sb, imports);
                    break;
                }
                case HASHMAPPED: 
                case TREEMAPPED: {
                    this.formatMAPPED(cd, ad, sb, imports);
                }
            }
        }
        return sb.toString();
    }

    void formatSV(ClassDefinition cd, AttributeDefinition ad, StringBuffer sb, ImportManager imports) {
        int lastPeriod;
        String typeClassName = ad.getType().getTypeClassName();
        String attrType = "DmcType" + ad.getType().getName();
        String typeName = ad.getType().getName().getNameString();
        String genericArgs = ad.getGenericArgs();
        if (genericArgs == null) {
            genericArgs = "<?>";
        }
        String auxHolderClass = ad.getType().getAuxHolderClass();
        if (ad.getType().getIsRefType().booleanValue()) {
            attrType = attrType + "REF";
            typeName = typeName + "REF";
        }
        if (typeClassName != null && (lastPeriod = typeClassName.lastIndexOf(46)) != -1) {
            attrType = typeClassName.substring(lastPeriod + 1);
        }
        String dmocast = "((" + cd.getName() + "DMO) core)";
        StringBuffer functionName = new StringBuffer();
        functionName.append(ad.getName());
        functionName.setCharAt(0, Character.toUpperCase(functionName.charAt(0)));
        if (ad.getType().getIsRefType().booleanValue()) {
            if (ad.getType().getOriginalClass().getIsNamedBy() == null) {
                String cname = null;
                cname = ad.getType().getOriginalClass().getDmwWrapperType(this.genContext) == WrapperTypeEnum.EXTENDED ? ad.getType().getOriginalClass().getName().getNameString() : ad.getType().getOriginalClass().getName().getNameString() + this.genSuffix;
                sb.append("    /**\n");
                sb.append("     * @return A " + cname + " object.\n");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public " + cname + " get" + functionName + "(){\n");
                sb.append("        " + ad.getType().getName() + "DMO dmo = " + dmocast + ".get" + functionName + "();\n");
                sb.append("        if (dmo == null)\n");
                sb.append("            return(null);\n");
                sb.append("        \n");
                sb.append("        return((" + cname + ")dmo.getContainer());\n");
                sb.append("    }\n\n");
            } else {
                String suffix = "";
                suffix = ad.getType().getOriginalClass().getDmwWrapperType(this.genContext) == WrapperTypeEnum.EXTENDED ? "" : this.genSuffix;
                String REF = "REF";
                if (ad.getType().getIsExtendedRefType().booleanValue()) {
                    REF = "";
                }
                if (this.useWrappedObjectRefs.booleanValue()) {
                    if (ad.getType().getPrimitiveType() != null && ad.getType().getIsExtendedRefType().booleanValue()) {
                        imports.addImport(ad.getType().getPrimitiveType(), "For get() of " + ad.getType().getName().getNameString());
                    }
                    sb.append("    /**\n");
                    sb.append("     * @return A " + ad.getType().getName() + suffix + " object.\n");
                    sb.append("     */\n");
                    sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public " + ad.getType().getName() + suffix + " get" + functionName + "(){\n");
                    sb.append("        " + ad.getType().getName() + REF + " ref = " + dmocast + ".get" + functionName + "();\n");
                    sb.append("        if (ref == null)\n");
                    sb.append("            return(null);\n");
                    sb.append("        \n");
                    sb.append("        if (ref.getObject() == null)\n");
                    sb.append("            return(null);\n");
                    sb.append("        \n");
                    sb.append("        return((" + ad.getType().getName() + suffix + ")ref.getObject().getContainer());\n");
                    sb.append("    }\n\n");
                } else {
                    sb.append("    /**\n");
                    sb.append("     * @return A reference to a " + ad.getType().getName() + " object.\n");
                    sb.append("     */\n");
                    sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public " + ad.getType().getName() + REF + " get" + functionName + "(){\n");
                    sb.append("        " + ad.getType().getName() + REF + " ref = " + dmocast + ".get" + functionName + "();\n");
                    sb.append("        if (ref == null)\n");
                    sb.append("            return(null);\n");
                    sb.append("        \n");
                    sb.append("        return(ref);\n");
                    sb.append("    }\n\n");
                }
            }
        } else {
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            if (typeName.equals("DmcAttribute")) {
                sb.append("    public DmcAttribute" + genericArgs + " get" + functionName + "(){\n");
                sb.append("        return(" + dmocast + ".get" + functionName + "());\n");
            } else if (typeName.equals("Boolean")) {
                sb.append("    public " + typeName + " is" + functionName + "(){\n");
                sb.append("        return(" + dmocast + ".is" + functionName + "());\n");
            } else {
                sb.append("    public " + typeName + " get" + functionName + "(){\n");
                sb.append("        return(" + dmocast + ".get" + functionName + "());\n");
            }
            sb.append("    }\n\n");
        }
        if (ad.getType().getIsRefType().booleanValue()) {
            if (this.useWrappedObjectRefs.booleanValue()) {
                if (ad.getType().getIsExtendedRefType().booleanValue()) {
                    sb.append("    /**\n");
                    sb.append("     * Sets the " + ad.getName() + " to the specified value.\n");
                    sb.append("     * @param value A value compatible with " + ad.getType().getName() + "\n");
                    sb.append("     */\n");
                    sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public void set" + functionName + "(" + ad.getType().getName() + " value) {\n");
                    sb.append("        " + dmocast + ".set" + functionName + "(value);\n");
                    sb.append("    }\n\n");
                    sb.append("    /**\n");
                    sb.append("     * Sets the " + ad.getName() + " to the specified value.\n");
                    sb.append("     * @param value A value compatible with " + ad.getType().getName() + "\n");
                    sb.append("     */\n");
                    sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public void set" + functionName + "(Object value) throws DmcValueException {\n");
                    sb.append("        " + dmocast + ".set" + functionName + "(value);\n");
                    sb.append("    }\n\n");
                } else {
                    sb.append("    /**\n");
                    sb.append("     * Sets the " + ad.getName() + " to the specified value.\n");
                    sb.append("     * @param value A value compatible with " + typeName + "\n");
                    sb.append("     */\n");
                    sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public void set" + functionName + "(" + auxHolderClass + " value) {\n");
                    sb.append("        " + dmocast + ".set" + functionName + "(value.getDMO());\n");
                    sb.append("    }\n\n");
                    sb.append("    /**\n");
                    sb.append("     * Sets the " + ad.getName() + " to the specified value.\n");
                    sb.append("     * @param value A value compatible with " + typeName + "\n");
                    sb.append("     * @throws DmcValueException is the value is incorrect\n");
                    sb.append("     */\n");
                    sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public void set" + functionName + "(Object value) throws DmcValueException {\n");
                    sb.append("        " + dmocast + ".set" + functionName + "(value);\n");
                    sb.append("    }\n\n");
                }
            } else {
                if (ad.getType().getIsExtendedRefType().booleanValue()) {
                    sb.append("    /**\n");
                    sb.append("     * Sets the " + ad.getName() + " to the specified value.\n");
                    sb.append("     * @param value A value compatible with " + ad.getType().getName() + "\n");
                    sb.append("     */\n");
                    sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public void set" + functionName + "(" + ad.getType().getName() + " value) {\n");
                    sb.append("        " + dmocast + ".set" + functionName + "(value);\n");
                    sb.append("    }\n\n");
                } else {
                    sb.append("    /**\n");
                    sb.append("     * Sets the " + ad.getName() + " to the specified value.\n");
                    sb.append("     * @param value A value compatible with " + ad.getType().getName() + "DMO\n");
                    sb.append("     */\n");
                    sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public void set" + functionName + "(" + ad.getType().getName() + "DMO value) {\n");
                    sb.append("        " + dmocast + ".set" + functionName + "(value);\n");
                    sb.append("    }\n\n");
                }
                sb.append("    /**\n");
                sb.append("     * Sets the " + ad.getName() + " to the specified value.\n");
                sb.append("     * @param value A value compatible with " + ad.getType().getName() + "\n");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public void set" + functionName + "(Object value) throws DmcValueException {\n");
                sb.append("        " + dmocast + ".set" + functionName + "(value);\n");
                sb.append("    }\n\n");
            }
        } else {
            if (genericArgs.equals("<DmcObjectName>")) {
                sb.append("    /**\n");
                sb.append("     * Sets " + ad.getName() + " to the specified value.\n");
                sb.append("     * @param value A value compatible with DmcObjectName\n");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public void set" + functionName + "(DmcObjectName value) throws DmcValueException {\n");
                sb.append("        DmcAttribute<DmcObjectName>\tnameattr = DmwOmni.instance().getNameAttribute(value);\n");
                sb.append("        nameattr.set(value);\n");
                sb.append("        " + dmocast + ".setObjName(nameattr);\n");
                sb.append("    }\n\n");
            }
            sb.append("    /**\n");
            sb.append("     * Sets " + ad.getName() + " to the specified value.\n");
            sb.append("     * @param value A value compatible with " + attrType + "\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public void set" + functionName + "(Object value) throws DmcValueException {\n");
            sb.append("        " + dmocast + ".set" + functionName + "(value);\n");
            sb.append("    }\n\n");
            sb.append("    /**\n");
            sb.append("     * Sets " + ad.getName() + " to the specified value.\n");
            sb.append("     * @param value " + typeName + "\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            if (typeName.equals("DmcAttribute")) {
                sb.append("    public void set" + functionName + "(DmcAttribute" + genericArgs + " value){\n");
            } else {
                sb.append("    public void set" + functionName + "(" + typeName + " value){\n");
            }
            sb.append("        " + dmocast + ".set" + functionName + "(value);\n");
            sb.append("    }\n\n");
            if (ad.getType().getAltType() != null) {
                sb.append("    /**\n");
                sb.append("     * Sets " + ad.getName() + " to the specified value.\n");
                sb.append("     * @param value " + typeName + "\n");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public void set" + functionName + "(" + ad.getType().getAltType() + " value){\n");
                sb.append("        " + dmocast + ".set" + functionName + "(value);\n");
                sb.append("    }\n\n");
            }
        }
        sb.append("    /**\n");
        sb.append("     * Removes the " + ad.getName() + " attribute value.\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    public void rem" + functionName + "(){\n");
        sb.append("        " + dmocast + ".rem" + functionName + "();\n");
        sb.append("    }\n\n");
    }

    void formatMV(ClassDefinition cd, AttributeDefinition ad, StringBuffer sb, ImportManager imports) {
        int lastPeriod;
        String typeClassName = ad.getType().getTypeClassName();
        String attrType = "DmcType" + ad.getType().getName();
        String typeName = ad.getType().getName().getNameString();
        String auxHolderClass = ad.getType().getAuxHolderClass();
        if (ad.getType().getIsRefType().booleanValue()) {
            attrType = attrType + "REF";
        }
        if (typeClassName != null && (lastPeriod = typeClassName.lastIndexOf(46)) != -1) {
            attrType = typeClassName.substring(lastPeriod + 1);
        }
        StringBuffer functionName = new StringBuffer();
        functionName.append(ad.getName());
        functionName.setCharAt(0, Character.toUpperCase(functionName.charAt(0)));
        String dmocast = "((" + cd.getName() + "DMO) core)";
        sb.append("    /**\n");
        sb.append("     * @return The number of " + typeName + " items.\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    public int get" + functionName + "Size(){\n");
        sb.append("        return(" + dmocast + ".get" + functionName + "Size());\n");
        sb.append("    }\n\n");
        sb.append("    /**\n");
        sb.append("     * @return true if there are no " + typeName + "DMO items.\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    public boolean get" + functionName + "IsEmpty(){\n");
        sb.append("        if (" + dmocast + ".get" + functionName + "Size() == 0)\n");
        sb.append("            return(true);\n");
        sb.append("        return(false);\n");
        sb.append("    }\n\n");
        sb.append("    /**\n");
        sb.append("     * @return true if there are any " + typeName + "DMO items.\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    public boolean get" + functionName + "HasValue(){\n");
        sb.append("        if (" + dmocast + ".get" + functionName + "Size() == 0)\n");
        sb.append("            return(false);\n");
        sb.append("        return(true);\n");
        sb.append("    }\n\n");
        if (ad.getType().getIsRefType().booleanValue()) {
            String justdmo = ad.getType().getOriginalClass().getName().getNameString() + "DMO";
            String itClass = ad.getType().getOriginalClass().getDmwIteratorClass();
            if (ad.getType().getIsExtendedRefType().booleanValue()) {
                itClass = ad.getType().getName().getNameString() + "IterableDMW";
            }
            if (ad.getIndexSize() == null) {
                if (this.useWrappedObjectRefs.booleanValue()) {
                    imports.addImport(ad.getType().getDmwIteratorImport(), "For multi-valued " + ad.getType().getName().getNameString());
                    imports.addImport(((SchemaDefinition)ad.getDefinedIn()).getDMSASGImport(), "Attribute from the " + ((SchemaDefinitionDMW)ad.getDefinedIn()).getName() + " schema");
                    sb.append("    /**\n");
                    sb.append("     * @return An Iterator of " + typeName + "DMO objects.\n");
                    sb.append("     */\n");
                    sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public " + itClass + " get" + functionName + "Iterable(){\n");
                    sb.append("        DmcAttribute<?> attr = core.get(" + ad.getDMSAGReference() + ");\n");
                    sb.append("        if (attr == null)\n");
                    sb.append("            return(" + itClass + ".emptyList);\n");
                    sb.append("        \n");
                    sb.append("        return(new " + itClass + "(" + dmocast + ".get" + functionName + "()));\n");
                    sb.append("    }\n\n");
                } else {
                    imports.addImport("java.util.Iterator", "Multi-valued attribute access");
                    sb.append("    /**\n");
                    sb.append("     * @return An Iterator of " + typeName + "DMO objects.\n");
                    sb.append("     */\n");
                    sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                    if (ad.getType().getOriginalClass().getIsNamedBy() == null) {
                        sb.append("    public Iterator<" + typeName + "DMO> get" + functionName + "(){\n");
                    } else if (ad.getType().getIsExtendedRefType().booleanValue()) {
                        imports.addImport(ad.getType().getPrimitiveType(), "Multi-valued attribute access");
                        sb.append("    public Iterator<" + typeName + "> get" + functionName + "(){\n");
                    } else {
                        sb.append("    public Iterator<" + typeName + "REF> get" + functionName + "(){\n");
                    }
                    sb.append("        return(" + dmocast + ".get" + functionName + "());\n");
                    sb.append("    }\n\n");
                }
                if (this.useWrappedObjectRefs.booleanValue()) {
                    if (ad.getType().getIsExtendedRefType().booleanValue()) {
                        imports.addImport(ad.getType().getPrimitiveType(), "For addition of MV " + ad.getType().getName().getNameString());
                        sb.append("    /**\n");
                        sb.append("     * Adds another " + ad.getName() + " value.\n");
                        sb.append("     * @param value A value compatible with " + typeName + "\n");
                        sb.append("     */\n");
                        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                        sb.append("    public DmcAttribute<?> add" + functionName + "(" + ad.getType().getName().getNameString() + " value){\n");
                        sb.append("        DmcAttribute<?> attr = " + dmocast + ".add" + functionName + "(value);\n");
                        sb.append("        return(attr);\n");
                        sb.append("    }\n\n");
                    } else {
                        if (ad.getType().getPrimitiveType() != null) {
                            imports.addImport(ad.getType().getPrimitiveType(), "For multi-valued adds of " + ad.getType().getName().getNameString());
                        }
                        sb.append("    /**\n");
                        sb.append("     * Adds another " + ad.getName() + " value.\n");
                        sb.append("     * @param value A value compatible with " + typeName + "\n");
                        sb.append("     * @return the attribute instance\n");
                        sb.append("     */\n");
                        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                        sb.append("    public DmcAttribute<?> add" + functionName + "(" + auxHolderClass + " value){\n");
                        sb.append("        DmcAttribute<?> attr = " + dmocast + ".add" + functionName + "(((" + justdmo + ")value.getDmcObject()));\n");
                        sb.append("        return(attr);\n");
                        sb.append("    }\n\n");
                    }
                } else if (ad.getType().getIsExtendedRefType().booleanValue()) {
                    imports.addImport(ad.getType().getPrimitiveType(), "Extended ref type");
                    sb.append("    /**\n");
                    sb.append("     * Adds another " + ad.getName() + " value.\n");
                    sb.append("     * @param value A value compatible with " + typeName + "\n");
                    sb.append("     */\n");
                    sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public DmcAttribute<?> add" + functionName + "(" + typeName + " value){\n");
                    sb.append("        return(" + dmocast + ".add" + functionName + "(value));\n");
                    sb.append("    }\n\n");
                } else {
                    sb.append("    /**\n");
                    sb.append("     * Adds another " + ad.getName() + " value.\n");
                    sb.append("     * @param value A value compatible with " + typeName + "DMO\n");
                    sb.append("     */\n");
                    sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public DmcAttribute<?> add" + functionName + "(" + typeName + "DMO value){\n");
                    sb.append("        return(" + dmocast + ".add" + functionName + "(value));\n");
                    sb.append("    }\n\n");
                }
                if (this.useWrappedObjectRefs.booleanValue()) {
                    if (ad.getType().getIsExtendedRefType().booleanValue()) {
                        sb.append("    /**\n");
                        sb.append("     * Deletes a " + ad.getName() + " value.\n");
                        sb.append("     * @param value The " + typeName + " to be deleted from set of attribute values.\n");
                        sb.append("     */\n");
                        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                        sb.append("    public void del" + functionName + "(" + typeName + " value){\n");
                        sb.append("        " + dmocast + ".del" + functionName + "(value);\n");
                        sb.append("    }\n\n");
                    } else {
                        sb.append("    /**\n");
                        sb.append("     * Deletes a " + ad.getName() + " value.\n");
                        sb.append("     * @param value The " + typeName + " to be deleted from set of attribute values.\n");
                        sb.append("     */\n");
                        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                        sb.append("    public void del" + functionName + "(" + auxHolderClass + " value){\n");
                        sb.append("        " + dmocast + ".del" + functionName + "(value.getDMO());\n");
                        sb.append("    }\n\n");
                    }
                } else if (ad.getType().getIsExtendedRefType().booleanValue()) {
                    sb.append("    /**\n");
                    sb.append("     * Deletes a " + ad.getName() + " value.\n");
                    sb.append("     * @param value The " + typeName + " to be deleted from set of attribute values.\n");
                    sb.append("     */\n");
                    sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public void del" + functionName + "(" + typeName + " value){\n");
                    sb.append("        " + dmocast + ".del" + functionName + "(value);\n");
                    sb.append("    }\n\n");
                } else {
                    sb.append("    /**\n");
                    sb.append("     * Deletes a " + ad.getName() + " value.\n");
                    sb.append("     * @param value The " + typeName + " to be deleted from set of attribute values.\n");
                    sb.append("     */\n");
                    sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public void del" + functionName + "(" + typeName + "DMO value){\n");
                    sb.append("        " + dmocast + ".del" + functionName + "(value);\n");
                    sb.append("    }\n\n");
                }
                if (ad.getType().getOriginalClass().getIsNamedBy() != null) {
                    String collectionClass = null;
                    String dmwClass = null;
                    boolean isMULTI = false;
                    dmwClass = ad.getType().getOriginalClass().getDmwWrapperType(this.genContext) == WrapperTypeEnum.EXTENDED ? ad.getType().getOriginalClass().getName().getNameString() : ad.getType().getOriginalClass().getName().getNameString() + this.genSuffix;
                    switch (ad.getValueType()) {
                        case MULTI: {
                            collectionClass = "ArrayList";
                            isMULTI = true;
                            break;
                        }
                        case HASHSET: {
                            collectionClass = "HashSet";
                            break;
                        }
                        case TREESET: {
                            collectionClass = "TreeSet";
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Mapped attributes not supported here: " + cd.getName() + " " + ad.getName());
                        }
                    }
                    if (this.useWrappedObjectRefs.booleanValue()) {
                        imports.addImport(ad.getType().getDmwIteratorImport(), "For multi-valued " + ad.getType().getName().getNameString());
                        sb.append("    /**\n");
                        sb.append("     * @return A COPY of the collection of " + typeName + " objects.\n");
                        sb.append("     */\n");
                        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                        sb.append("    public " + collectionClass + "<" + dmwClass + "> get" + functionName + "Copy(){\n");
                        sb.append("        DmcAttribute<?> attr = " + dmocast + ".get(" + ad.getDMSAGReference() + ");\n");
                        sb.append("        if (attr == null)\n");
                        sb.append("            return(new " + collectionClass + "<" + dmwClass + ">());\n");
                        sb.append("        \n");
                        if (isMULTI) {
                            sb.append("        " + collectionClass + "<" + dmwClass + "> rc = new " + collectionClass + "<" + dmwClass + ">(attr.getMVSize());\n");
                        } else {
                            sb.append("        " + collectionClass + "<" + dmwClass + "> rc = new " + collectionClass + "<" + dmwClass + ">();\n");
                        }
                        sb.append("        \n");
                        sb.append("        " + itClass + " it = get" + functionName + "Iterable();\n");
                        sb.append("        while(it.hasNext()){\n");
                        sb.append("            rc.add(it.next());\n");
                        sb.append("        }\n");
                        sb.append("        \n");
                        sb.append("        return(rc);\n");
                        sb.append("    }\n\n");
                    }
                }
            } else {
                if (this.useWrappedObjectRefs.booleanValue()) {
                    imports.addImport(ad.getType().getPrimitiveType(), "For setNth of " + ad.getType().getName().getNameString());
                    if (ad.getType().getIsExtendedRefType().booleanValue()) {
                        sb.append("    /**\n");
                        sb.append("     * Sets the " + ad.getName() + " value at the specified index.\n");
                        sb.append("     * @param value A value compatible with " + ad.getType().getName().getNameString() + "\n");
                        sb.append("     */\n");
                        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                        sb.append("    public DmcAttribute<?> setNth" + functionName + "(int index, " + ad.getType().getName().getNameString() + " value){\n");
                        sb.append("        return(" + dmocast + ".setNth" + functionName + "(index, value));\n");
                        sb.append("    }\n\n");
                    } else {
                        sb.append("    /**\n");
                        sb.append("     * Sets the " + ad.getName() + " value at the specified index.\n");
                        sb.append("     * @param value A value compatible with " + typeName + "\n");
                        sb.append("     */\n");
                        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                        sb.append("    public DmcAttribute<?> setNth" + functionName + "(int index, " + auxHolderClass + " value){\n");
                        sb.append("        if (value == null)\n");
                        sb.append("            return(" + dmocast + ".setNth" + functionName + "(index, null));\n");
                        sb.append("        else\n");
                        sb.append("            return(" + dmocast + ".setNth" + functionName + "(index, ((" + justdmo + ")value.getDmcObject())));\n");
                        sb.append("    }\n\n");
                    }
                } else if (ad.getType().getIsExtendedRefType().booleanValue()) {
                    sb.append("    /**\n");
                    sb.append("     * Sets the " + ad.getName() + " value at the specified index.\n");
                    sb.append("     * @param value A value compatible with " + typeName + "\n");
                    sb.append("     */\n");
                    sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public DmcAttribute<?> setNth" + functionName + "(int index, " + typeName + " value){\n");
                    sb.append("        return(" + dmocast + ".setNth" + functionName + "(index, value));\n");
                    sb.append("    }\n\n");
                } else {
                    sb.append("    /**\n");
                    sb.append("     * Sets the " + ad.getName() + " value at the specified index.\n");
                    sb.append("     * @param value A value compatible with " + typeName + "\n");
                    sb.append("     */\n");
                    sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public DmcAttribute<?> setNth" + functionName + "(int index, " + justdmo + " value){\n");
                    sb.append("        return(" + dmocast + ".setNth" + functionName + "(index, value));\n");
                    sb.append("    }\n\n");
                }
                if (ad.getType().getIsRefType().booleanValue()) {
                    if (ad.getType().getOriginalClass().getIsNamedBy() == null) {
                        String cname = null;
                        cname = ad.getType().getOriginalClass().getDmwWrapperType(this.genContext) == WrapperTypeEnum.EXTENDED ? ad.getType().getOriginalClass().getName().getNameString() : ad.getType().getOriginalClass().getName().getNameString() + "DMW";
                        if (this.useWrappedObjectRefs.booleanValue()) {
                            sb.append("    /**\n");
                            sb.append("     * @return The " + cname + " object at the specified index.\n");
                            sb.append("     */\n");
                            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                            sb.append("    public " + cname + " getNth" + functionName + "(int index){\n");
                            sb.append("        " + ad.getType().getName() + "DMO dmo = " + dmocast + ".getNth" + functionName + "(index);\n");
                            sb.append("        if (dmo == null)\n");
                            sb.append("            return(null);\n");
                            sb.append("        \n");
                            sb.append("        return((" + cname + ")dmo.getContainer());\n");
                            sb.append("    }\n\n");
                        } else {
                            sb.append("    /**\n");
                            sb.append("     * @return The " + cname + " object at the specified index.\n");
                            sb.append("     */\n");
                            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                            sb.append("    public " + typeName + "DMO getNth" + functionName + "(int index){\n");
                            sb.append("        return(" + dmocast + ".getNth" + functionName + "(index));\n");
                            sb.append("    }\n\n");
                        }
                    } else {
                        String suffix = "";
                        suffix = ad.getType().getOriginalClass().getDmwWrapperType(this.genContext) == WrapperTypeEnum.EXTENDED ? "" : this.genSuffix;
                        if (this.useWrappedObjectRefs.booleanValue()) {
                            if (ad.getType().getIsExtendedRefType().booleanValue()) {
                                String refType = ad.getType().getOriginalClass().getName().getNameString() + "DMW";
                                if (ad.getType().getOriginalClass().getDmwWrapperType(this.genContext) == WrapperTypeEnum.EXTENDED) {
                                    refType = ad.getType().getOriginalClass().getName().getNameString();
                                }
                                sb.append("    /**\n");
                                sb.append("     * @return The " + ad.getType().getName() + suffix + " object at the specified index.\n");
                                sb.append("     */\n");
                                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                                sb.append("    public " + refType + " getNth" + functionName + "(int index){\n");
                                sb.append("        " + ad.getType().getName() + " ref = " + dmocast + ".getNth" + functionName + "(index);\n");
                                sb.append("        if (ref == null)\n");
                                sb.append("            return(null);\n");
                                sb.append("        \n");
                                sb.append("        if (ref.getObject() == null)\n");
                                sb.append("            return(null);\n");
                                sb.append("        \n");
                                sb.append("        return((" + refType + ")ref.getObject().getContainer());\n");
                                sb.append("    }\n\n");
                            } else {
                                sb.append("    /**\n");
                                sb.append("     * @return The " + ad.getType().getName() + suffix + " object at the specified index.\n");
                                sb.append("     */\n");
                                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                                sb.append("    public " + ad.getType().getName() + suffix + " getNth" + functionName + "(int index){\n");
                                sb.append("        " + ad.getType().getName() + "REF ref = " + dmocast + ".getNth" + functionName + "(index);\n");
                                sb.append("        if (ref == null)\n");
                                sb.append("            return(null);\n");
                                sb.append("        \n");
                                sb.append("        if (ref.getObject() == null)\n");
                                sb.append("            return(null);\n");
                                sb.append("        \n");
                                sb.append("        return((" + ad.getType().getName() + suffix + ")ref.getObject().getContainer());\n");
                                sb.append("    }\n\n");
                            }
                        } else if (ad.getType().getIsExtendedRefType().booleanValue()) {
                            sb.append("    /**\n");
                            sb.append("     * @return The reference to the " + ad.getType().getName() + " object at the specified index.\n");
                            sb.append("     */\n");
                            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                            sb.append("    public " + ad.getType().getName() + " getNth" + functionName + "(int index){\n");
                            sb.append("        return(" + dmocast + ".getNth" + functionName + "(index));\n");
                            sb.append("    }\n\n");
                        }
                        if (this.useWrappedObjectRefs.booleanValue()) {
                            if (ad.getType().getIsExtendedRefType().booleanValue()) {
                                sb.append("    /**\n");
                                sb.append("     * @return The reference to the " + ad.getType().getName() + " object at the specified index.\n");
                                sb.append("     */\n");
                                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                                sb.append("    public " + ad.getType().getName() + " getNth" + functionName + "REF(int index){\n");
                                sb.append("        " + ad.getType().getName() + " ref = " + dmocast + ".getNth" + functionName + "REF(index);\n");
                                sb.append("        return(ref);\n");
                                sb.append("    }\n\n");
                            } else {
                                sb.append("    /**\n");
                                sb.append("     * @return The reference to the " + ad.getType().getName() + suffix + " object at the specified index.\n");
                                sb.append("     */\n");
                                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                                sb.append("    public " + ad.getType().getName() + suffix + "REF getNth" + functionName + "REF(int index){\n");
                                sb.append("        " + ad.getType().getName() + "REF ref = " + dmocast + ".getNth" + functionName + "REF(index);\n");
                                sb.append("        return(ref);\n");
                                sb.append("    }\n\n");
                            }
                        } else if (ad.getType().getIsExtendedRefType().booleanValue()) {
                            sb.append("    /**\n");
                            sb.append("     * @return The reference to the " + ad.getType().getName() + " object at the specified index.\n");
                            sb.append("     */\n");
                            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                            sb.append("    public " + ad.getType().getName() + " getNth" + functionName + "REF(int index){\n");
                            sb.append("        return(" + dmocast + ".getNth" + functionName + "REF(index));\n");
                            sb.append("    }\n\n");
                        } else {
                            sb.append("    /**\n");
                            sb.append("     * @return The reference to the " + ad.getType().getName() + " object at the specified index.\n");
                            sb.append("     */\n");
                            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                            sb.append("    public " + ad.getType().getName() + "REF getNth" + functionName + "REF(int index){\n");
                            sb.append("        return(" + dmocast + ".getNth" + functionName + "REF(index));\n");
                            sb.append("    }\n\n");
                        }
                    }
                }
            }
        } else {
            String alt;
            if (this.useWrappedObjectRefs.booleanValue()) {
                String itClass = ad.getType().getDmwIteratorClass();
                imports.addImport(ad.getType().getDmwIteratorImport(), "For multi-valued " + ad.getType().getName().getNameString());
                sb.append("    /**\n");
                sb.append("     * @return An Iterator of " + typeName + " objects.\n");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public " + itClass + " get" + functionName + "Iterable(){\n");
                sb.append("        DmcAttribute<?> attr = core.get(" + ad.getDMSAGReference() + ");\n");
                sb.append("        if (attr == null)\n");
                sb.append("            return(" + itClass + ".emptyList);\n");
                sb.append("        \n");
                sb.append("        return(new " + itClass + "(" + dmocast + ".get" + functionName + "()));\n");
                sb.append("    }\n\n");
            } else {
                sb.append("    /**\n");
                sb.append("     * @return An Iterator of " + typeName + " objects.\n");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public Iterator<" + typeName + "> get" + functionName + "(){\n");
                sb.append("        return(" + dmocast + ".get" + functionName + "());\n");
                sb.append("    }\n\n");
            }
            sb.append("    /**\n");
            sb.append("     * Adds another " + ad.getName() + " value.\n");
            sb.append("     * @param value A value compatible with " + typeName + "\n");
            sb.append("     * @throws DmcValueException if value is incorrect\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public void add" + functionName + "(Object value) throws DmcValueException {\n");
            sb.append("        " + dmocast + ".add" + functionName + "(value);\n");
            sb.append("    }\n\n");
            if (ad.getIndexSize() == null) {
                sb.append("    /**\n");
                sb.append("     * Adds another " + ad.getName() + " value.\n");
                sb.append("     * @param value A value compatible with " + typeName + "\n");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public void add" + functionName + "(" + typeName + " value){\n");
                sb.append("        " + dmocast + ".add" + functionName + "(value);\n");
                sb.append("    }\n\n");
            } else {
                sb.append("    /**\n");
                sb.append("     * Sets a " + ad.getName() + " value at the specified index.\n");
                sb.append("     * @param index The index to set.\n");
                sb.append("     * @param value A value compatible with " + typeName + "\n");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public void setNth" + functionName + "(int index, " + typeName + " value){\n");
                sb.append("        " + dmocast + ".setNth" + functionName + "(index, value);\n");
                sb.append("    }\n\n");
                sb.append("    /**\n");
                sb.append("     * Gets the " + ad.getName() + " value at the specified index.\n");
                sb.append("     * @param index The index to retreive.\n");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public " + typeName + " getNth" + functionName + "(int index){\n");
                sb.append("        return(" + dmocast + ".getNth" + functionName + "(index));\n");
                sb.append("    }\n\n");
            }
            if (ad.getType().getAltType() != null) {
                alt = ad.getType().getAltType();
                if (ad.getIndexSize() == null) {
                    sb.append("    /**\n");
                    sb.append("     * Adds another " + alt + " value.\n");
                    sb.append("     * @param value A value compatible with " + alt + "\n");
                    sb.append("     */\n");
                    sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public void add" + functionName + "(" + alt + " value){\n");
                    sb.append("        " + dmocast + ".add" + functionName + "(value);\n");
                    sb.append("    }\n\n");
                } else {
                    sb.append("    /**\n");
                    sb.append("     * Sets a " + alt + " value at the specified index\n");
                    sb.append("     * @param value A value compatible with " + alt + "\n");
                    sb.append("     */\n");
                    sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public void setNth" + functionName + "(int index, " + alt + " value){\n");
                    sb.append("        " + dmocast + ".setNth" + functionName + "(index,value);\n");
                    sb.append("    }\n\n");
                }
            }
            sb.append("    /**\n");
            sb.append("     * @param value A value compatible with " + typeName + "\n");
            sb.append("     * @return true if the collection contains the " + ad.getName() + " value.\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public boolean " + ad.getName() + "Contains(" + typeName + " value){\n");
            sb.append("        return(" + dmocast + "." + ad.getName() + "Contains(value));\n");
            sb.append("    }\n\n");
            if (ad.getType().getAltType() != null) {
                alt = ad.getType().getAltType();
                sb.append("    /**\n");
                sb.append("     * @param value A value compatible with " + alt + "\n");
                sb.append("     * @return true if the collection contains the " + alt + " value.\n");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public boolean " + ad.getName() + "Contains(" + alt + " value){\n");
                sb.append("        return(" + dmocast + "." + ad.getName() + "Contains(value));\n");
                sb.append("    }\n\n");
            }
            String collectionClass = null;
            boolean supportsSize = false;
            switch (ad.getValueType()) {
                case MULTI: {
                    collectionClass = "ArrayList";
                    imports.addImport("java.util.ArrayList", "Support for MULTI attribute");
                    supportsSize = true;
                    break;
                }
                case HASHSET: {
                    collectionClass = "HashSet";
                    supportsSize = true;
                    break;
                }
                case TREESET: {
                    collectionClass = "TreeSet";
                    break;
                }
                default: {
                    throw new IllegalStateException("Mapped attributes not supported here: " + cd.getName() + " " + ad.getName());
                }
            }
            imports.addImport("java.util.Iterator", "Support copy of MV objects");
            sb.append("    /**\n");
            sb.append("     * @return A COPY of the collection of " + typeName + " objects.\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    @SuppressWarnings(\"unchecked\")\n");
            sb.append("    public " + collectionClass + "<" + ad.getType().getName() + "> get" + functionName + "Copy(){\n");
            sb.append("        DmcAttribute<?> attr = core.get(" + ad.getDMSAGReference() + ");\n");
            sb.append("        if (attr == null)\n");
            sb.append("            return(new " + collectionClass + "<" + ad.getType().getName() + ">());\n");
            sb.append("        \n");
            if (supportsSize) {
                sb.append("        " + collectionClass + "<" + ad.getType().getName() + "> rc = new " + collectionClass + "<" + ad.getType().getName() + ">(attr.getMVSize());\n");
            } else {
                sb.append("        " + collectionClass + "<" + ad.getType().getName() + "> rc = new " + collectionClass + "<" + ad.getType().getName() + ">();\n");
            }
            sb.append("        \n");
            sb.append("        Iterator<" + ad.getType().getName() + "> it = (Iterator<" + ad.getType().getName() + ">) attr.getMV();\n");
            sb.append("        while(it.hasNext()){\n");
            sb.append("            rc.add(it.next());\n");
            sb.append("        }\n");
            sb.append("        \n");
            sb.append("        return(rc);\n");
            sb.append("    }\n\n");
            sb.append("    /**\n");
            sb.append("     * Deletes a " + ad.getName() + " value.\n");
            sb.append("     * @param value The " + typeName + " to be deleted from set of attribute values.\n");
            sb.append("     * @throws DmcValueException if value is incorrect\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public void del" + functionName + "(Object value) throws DmcValueException {\n");
            sb.append("        " + dmocast + ".del" + functionName + "(value);\n");
            sb.append("    }\n\n");
            sb.append("    /**\n");
            sb.append("     * Deletes a " + ad.getName() + " value.\n");
            sb.append("     * @param value The " + typeName + " to be deleted from set of attribute values.\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public void del" + functionName + "(" + typeName + " value){\n");
            sb.append("        " + dmocast + ".del" + functionName + "(value);\n");
            sb.append("    }\n\n");
        }
        sb.append("    /**\n");
        sb.append("     * Removes the " + ad.getName() + " attribute value.\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    public void rem" + functionName + "(){\n");
        sb.append("        " + dmocast + ".rem" + functionName + "();\n");
        sb.append("    }\n\n");
    }

    void formatMAPPED(ClassDefinition cd, AttributeDefinition ad, StringBuffer sb, ImportManager imports) {
        String itClass;
        int lastPeriod;
        String typeClassName = ad.getType().getTypeClassName();
        String attrType = "DmcType" + ad.getType().getName();
        String typeName = ad.getType().getName().getNameString();
        String auxHolderClass = ad.getType().getAuxHolderClass();
        if (ad.getType().getIsRefType().booleanValue()) {
            attrType = attrType + "REF";
        }
        if (typeClassName != null && (lastPeriod = typeClassName.lastIndexOf(46)) != -1) {
            attrType = typeClassName.substring(lastPeriod + 1);
        }
        StringBuffer functionName = new StringBuffer();
        functionName.append(ad.getName());
        functionName.setCharAt(0, Character.toUpperCase(functionName.charAt(0)));
        String dmocast = "((" + cd.getName() + "DMO) core)";
        sb.append("    /**\n");
        sb.append("     * @return The number of " + typeName + "DMO items.\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    public int get" + functionName + "Size(){\n");
        sb.append("        DmcAttribute<?> attr = " + dmocast + ".get(" + ad.getDMSAGReference() + ");\n");
        sb.append("        if (attr == null)\n");
        sb.append("            return(0);\n");
        sb.append("        \n");
        sb.append("        return(attr.getMVSize());\n");
        sb.append("    }\n\n");
        sb.append("    /**\n");
        sb.append("     * @return true if there are no " + typeName + "DMO items.\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    public boolean get" + functionName + "IsEmpty(){\n");
        sb.append("        DmcAttribute<?> attr = " + dmocast + ".get(" + ad.getDMSAGReference() + ");\n");
        sb.append("        if (attr == null)\n");
        sb.append("            return(true);\n");
        sb.append("        \n");
        sb.append("        return(false);\n");
        sb.append("    }\n\n");
        sb.append("    /**\n");
        sb.append("     * @return true if there are any " + typeName + "DMO items.\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    public boolean get" + functionName + "HasValue(){\n");
        sb.append("        DmcAttribute<?> attr = " + dmocast + ".get(" + ad.getDMSAGReference() + ");\n");
        sb.append("        if (attr == null)\n");
        sb.append("            return(false);\n");
        sb.append("        \n");
        sb.append("        return(true);\n");
        sb.append("    }\n\n");
        if (this.useWrappedObjectRefs.booleanValue()) {
            sb.append("    /**\n");
            sb.append("     * @return The keyed " + typeName + " object if it's available and null otherwise.\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public " + typeName + " get" + functionName + "(Object key){\n");
            sb.append("        DmcAttribute<?> attr = " + dmocast + ".get(" + ad.getDMSAGReference() + ");\n");
            sb.append("        if (attr == null)\n");
            sb.append("            return(null);\n");
            sb.append("        \n");
            sb.append("        return((" + typeName + ")attr.getByKey(key));\n");
            sb.append("    }\n\n");
        } else {
            sb.append("    /**\n");
            sb.append("     * @return The keyed " + typeName + " object if it's available and null otherwise.\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            if (ad.getType().getIsRefType().booleanValue()) {
                sb.append("    public " + typeName + "REF get" + functionName + "(Object key){\n");
            } else {
                sb.append("    public " + typeName + " get" + functionName + "(Object key){\n");
            }
            sb.append("        return(" + dmocast + ".get" + functionName + "(key));\n");
            sb.append("    }\n\n");
        }
        if (ad.getValueType() == ValueTypeEnum.TREEMAPPED) {
            String keyClass = ad.getType().getKeyClass();
            if (ad.getType().getIsRefType().booleanValue()) {
                imports.addImport(ad.getType().getOriginalClass().getIsNamedBy().getType().getPrimitiveType(), "Name type");
                keyClass = ad.getType().getOriginalClass().getIsNamedBy().getType().getName().getNameString();
            }
            sb.append("    /**\n");
            sb.append("     * @return the first key of the map.\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public " + keyClass + " get" + functionName + "FirstKey(){\n");
            sb.append("        return(" + dmocast + ".get" + functionName + "FirstKey());\n");
            sb.append("    }\n\n");
        }
        if (ad.getType().getIsRefType().booleanValue()) {
            itClass = ad.getType().getOriginalClass().getDmwIteratorClass();
            if (ad.getType().getOriginalClass().getIsNamedBy() == null) {
                DebugInfo.debug("NOT GENERATING cast Iterable of straight objects.");
            } else {
                imports.addImport("java.util.Iterator", "Support MV object get()");
                if (this.useWrappedObjectRefs.booleanValue()) {
                    sb.append("    /**\n");
                    sb.append("     * @return An Iterable of " + typeName + " objects.\n");
                    sb.append("     */\n");
                    sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public " + itClass + " get" + functionName + "Iterable(){\n");
                    sb.append("        DmcAttribute<?> attr = " + dmocast + ".get(" + ad.getDMSAGReference() + ");\n");
                    sb.append("        if (attr == null)\n");
                    sb.append("            return(" + itClass + ".emptyList);\n");
                    sb.append("        \n");
                    sb.append("        Iterator<" + typeName + "REF> it = " + dmocast + ".get" + functionName + "();\n");
                    sb.append("        \n");
                    sb.append("        if (it == null)\n");
                    sb.append("            return(" + itClass + ".emptyList);\n");
                    sb.append("        \n");
                    sb.append("        return(new " + itClass + "(it));\n");
                    sb.append("    }\n\n");
                } else {
                    sb.append("    /**\n");
                    sb.append("     * @return An Iterator of " + typeName + "REFs.\n");
                    sb.append("     */\n");
                    sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public Iterator<" + typeName + "REF> get" + functionName + "(){\n");
                    sb.append("        return(" + dmocast + ".get" + functionName + "());\n");
                    sb.append("    }\n\n");
                }
            }
            if (this.useWrappedObjectRefs.booleanValue()) {
                sb.append("    /**\n");
                sb.append("     * Adds another " + ad.getName() + " value.\n");
                sb.append("     * @param value " + typeName + this.genSuffix + "\n");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public DmcAttribute<?> add" + functionName + "(" + auxHolderClass + " value) {\n");
                sb.append("        return(" + dmocast + ".add" + functionName + "(value.getDMO()));\n");
                sb.append("    }\n\n");
            } else {
                sb.append("    /**\n");
                sb.append("     * Adds another " + ad.getName() + " value.\n");
                sb.append("     * @param value " + typeName + this.genSuffix + "\n");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public DmcAttribute<?> add" + functionName + "(" + typeName + "DMO value) {\n");
                sb.append("        return(" + dmocast + ".add" + functionName + "(value));\n");
                sb.append("    }\n\n");
            }
            if (this.useWrappedObjectRefs.booleanValue()) {
                sb.append("    /**\n");
                sb.append("     * Deletes a " + ad.getName() + " value.\n");
                sb.append("     * @param value The " + typeName + " to be deleted from set of attribute values.\n");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public void del" + functionName + "(" + auxHolderClass + " value){\n");
                sb.append("        " + dmocast + ".del" + functionName + "(value.getDMO());\n");
                sb.append("    }\n\n");
            } else {
                sb.append("    /**\n");
                sb.append("     * Deletes a " + ad.getName() + " value.\n");
                sb.append("     * @param value The " + typeName + " to be deleted from set of attribute values.\n");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public void del" + functionName + "(" + typeName + "DMO value){\n");
                sb.append("        " + dmocast + ".del" + functionName + "(value);\n");
                sb.append("    }\n\n");
            }
            if (ad.getType().getOriginalClass().getIsNamedBy() != null) {
                String collectionClass = null;
                String dmwClass = null;
                String keyClass = ad.getType().getOriginalClass().getIsNamedBy().getType().getName().getNameString();
                dmwClass = ad.getType().getOriginalClass().getDmwWrapperType(this.genContext) == WrapperTypeEnum.EXTENDED ? ad.getType().getOriginalClass().getName().getNameString() : ad.getType().getOriginalClass().getName().getNameString() + this.genSuffix;
                switch (ad.getValueType()) {
                    case HASHMAPPED: {
                        collectionClass = "HashMap";
                        break;
                    }
                    case TREEMAPPED: {
                        collectionClass = "TreeMap";
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Single valued and set attriutes not handled here: " + cd.getName() + " " + ad.getName());
                    }
                }
                if (this.useWrappedObjectRefs.booleanValue()) {
                    imports.addImport(ad.getType().getOriginalClass().getIsNamedBy().getType().getPrimitiveType(), "Name type");
                    sb.append("    /**\n");
                    sb.append("     * @return A COPY of the collection of " + typeName + " objects.\n");
                    sb.append("     */\n");
                    sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public " + collectionClass + "<" + keyClass + "," + dmwClass + "> get" + functionName + "Copy(){\n");
                    sb.append("        DmcAttribute<?> attr = " + dmocast + ".get(" + ad.getDMSAGReference() + ");\n");
                    sb.append("        if (attr == null)\n");
                    sb.append("            return(new " + collectionClass + "<" + keyClass + "," + dmwClass + ">());\n");
                    sb.append("        \n");
                    sb.append("        " + collectionClass + "<" + keyClass + "," + dmwClass + "> rc = new " + collectionClass + "<" + keyClass + "," + dmwClass + ">();\n");
                    sb.append("        \n");
                    sb.append("        " + itClass + " it = get" + functionName + "Iterable();\n");
                    sb.append("        while(it.hasNext()){\n");
                    sb.append("            " + dmwClass + " obj = it.next();\n");
                    sb.append("            rc.put((" + keyClass + ") obj.getObjectName(),obj);\n");
                    sb.append("        }\n");
                    sb.append("        return(rc);\n");
                    sb.append("    }\n\n");
                }
            }
        } else {
            itClass = ad.getType().getDmwIteratorClass();
            if (this.useWrappedObjectRefs.booleanValue()) {
                imports.addImport(ad.getType().getDmwIteratorImport(), "For multi-valued " + ad.getType().getName().getNameString());
                sb.append("    /**\n");
                sb.append("     * @return An Iterator of " + typeName + " objects.\n");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public " + itClass + " get" + functionName + "Iterable(){\n");
                sb.append("        DmcAttribute<?> attr = " + dmocast + ".get(" + ad.getDMSAGReference() + ");\n");
                sb.append("        if (attr == null)\n");
                sb.append("            return(" + itClass + ".emptyList);\n");
                sb.append("        \n");
                sb.append("        return(new " + itClass + "(" + dmocast + ".get" + functionName + "()));\n");
                sb.append("    }\n\n");
            } else {
                imports.addImport("java.util.Iterator", "Multi-valued attribute access");
                sb.append("    /**\n");
                sb.append("     * @return An Iterator of " + typeName + " objects.\n");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public Iterator<" + typeName + "> get" + functionName + "(){\n");
                sb.append("        return(" + dmocast + ".get" + functionName + "());\n");
                sb.append("    }\n\n");
            }
            sb.append("    /**\n");
            sb.append("     * Adds another " + ad.getName() + " value.\n");
            sb.append("     * @param value A value compatible with " + typeName + "\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public void add" + functionName + "(Object value) throws DmcValueException {\n");
            sb.append("        " + dmocast + ".add" + functionName + "(value);\n");
            sb.append("    }\n\n");
            sb.append("    /**\n");
            sb.append("     * Adds another " + ad.getName() + " value.\n");
            sb.append("     * @param value " + typeName + "\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public void add" + functionName + "(" + typeName + " value) {\n");
            sb.append("        " + dmocast + ".add" + functionName + "(value);\n");
            sb.append("    }\n\n");
            sb.append("    /**\n");
            sb.append("     * Deletes a " + ad.getName() + " value.\n");
            sb.append("     * @param value The " + typeName + " to be deleted from set of attribute values.\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public void del" + functionName + "(Object value){\n");
            sb.append("        " + dmocast + ".del" + functionName + "(value);\n");
            sb.append("    }\n\n");
            sb.append("    /**\n");
            sb.append("     * Deletes a " + ad.getName() + " value.\n");
            sb.append("     * @param value The " + typeName + " to be deleted from set of attribute values.\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public void del" + functionName + "(" + ad.getType().getKeyClass() + " value){\n");
            sb.append("        " + dmocast + ".del" + functionName + "(value);\n");
            sb.append("    }\n\n");
            String collectionClass = null;
            String keyClass = ad.getType().getKeyClass();
            boolean supportsSize = false;
            switch (ad.getValueType()) {
                case HASHMAPPED: {
                    collectionClass = "HashMap";
                    supportsSize = true;
                    break;
                }
                case TREEMAPPED: {
                    collectionClass = "TreeMap";
                    break;
                }
                default: {
                    throw new IllegalStateException("Single valued and set attriutes not handled here: " + cd.getName() + " " + ad.getName());
                }
            }
            if (this.useWrappedObjectRefs.booleanValue()) {
                imports.addImport("java.util.Iterator", "Support copy of MV objects");
                sb.append("    /**\n");
                sb.append("     * @return A COPY of the collection of " + typeName + " objects.\n");
                sb.append("     */\n");
                sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    @SuppressWarnings(\"unchecked\")\n");
                sb.append("    public " + collectionClass + "<" + keyClass + "," + ad.getType().getName() + "> get" + functionName + "Copy(){\n");
                sb.append("        DmcAttribute<?> attr = " + dmocast + ".get(" + ad.getDMSAGReference() + ");\n");
                sb.append("        if (attr == null)\n");
                sb.append("            return(new " + collectionClass + "<" + keyClass + "," + ad.getType().getName() + ">());\n");
                sb.append("        \n");
                if (supportsSize) {
                    sb.append("        " + collectionClass + "<" + keyClass + "," + ad.getType().getName() + "> rc = new " + collectionClass + "<" + keyClass + "," + ad.getType().getName() + ">(attr.getMVSize());\n");
                } else {
                    sb.append("        " + collectionClass + "<" + keyClass + "," + ad.getType().getName() + "> rc = new " + collectionClass + "<" + keyClass + "," + ad.getType().getName() + ">();\n");
                }
                sb.append("        \n");
                sb.append("        Iterator<" + ad.getType().getName() + "> it = (Iterator<" + ad.getType().getName() + ">) attr.getMV();\n");
                sb.append("        while(it.hasNext()){\n");
                sb.append("            " + ad.getType().getName() + " obj = it.next();\n");
                sb.append("            rc.put((" + keyClass + ")obj.getKey(),obj);\n");
                sb.append("        }\n");
                sb.append("        \n");
                sb.append("        return(rc);\n");
                sb.append("    }\n\n");
            }
        }
        sb.append("    /**\n");
        sb.append("     * Removes the " + ad.getName() + " attribute value.\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    public void rem" + functionName + "(){\n");
        sb.append("        " + dmocast + ".rem" + functionName + "();\n");
        sb.append("    }\n\n");
    }

    String getCommonAUXFunctions() {
        StringBuffer sb = new StringBuffer();
        sb.append("    /**\n");
        sb.append("     * This method will check to see if the object has any of our attributes.\n");
        sb.append("     * If not, our aux class is automatically removed from the object.\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    static private void removeAuxIfRequired(" + this.baseWrapper + " corew){\n");
        sb.append("        boolean anyLeft = false;\n");
        sb.append("\n");
        for (AttributeDefinition ad : this.allAttr) {
            sb.append("        if (corew.getDmcObject().get(__" + ad.getName() + ") != null)\n");
            sb.append("            anyLeft = true;\n");
        }
        sb.append("\n");
        sb.append("        if (!anyLeft)\n");
        sb.append("            corew.removeAux(_auxClass);\n");
        sb.append("    }\n");
        sb.append("\n");
        sb.append("    /**\n");
        sb.append("     * This method will check to see if the object has our aux class.\n");
        sb.append("     * If not, we add our aux class the object.\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    static private void addAuxIfRequired(" + this.baseWrapper + " corew) throws DmcValueException {\n");
        sb.append("        if (!corew.hasAux(_auxClass))\n");
        sb.append("            corew.addAux(_auxClass);\n");
        sb.append("    }\n");
        sb.append("\n");
        sb.append("    /**\n");
        sb.append("     * This method checks if the object has this auxiliary class.\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    static public boolean hasAux(" + this.baseWrapper + " corew){\n");
        sb.append("        if (corew == null)\n");
        sb.append("            return(false);\n");
        sb.append("        return(corew.hasAux(_auxClass));\n");
        sb.append("    }\n");
        sb.append("\n");
        return sb.toString();
    }

    String getAuxClassHeader(ClassDefinition cd, String where) {
        StringBuffer sb = new StringBuffer();
        sb.append("/**\n");
        CodeFormatter.dumpCodeComment(cd.getDescription(), sb, " * ");
        sb.append(" * <P>\n");
        sb.append(" * Generated from the " + ((SchemaDefinitionDMW)cd.getDefinedIn()).getName() + " schema at version " + ((SchemaDefinition)cd.getDefinedIn()).getVersion() + "\n");
        sb.append(" * <P>\n");
        sb.append(" * This code was auto-generated by the dmogenerator utility and shouldn't be alterred manually!\n");
        sb.append(" * Generated from: " + where + "\n");
        sb.append(" */\n");
        sb.append("public class ");
        sb.append(cd.getName());
        return sb.toString();
    }

    String getAUXAccessFunctions(ClassDefinition cd) {
        StringBuffer sb = new StringBuffer();
        for (AttributeDefinition ad : this.allAttr) {
            switch (ad.getValueType()) {
                case SINGLE: {
                    this.formatAUXSV(cd, ad, sb);
                    break;
                }
                case MULTI: {
                    this.formatAUXMV(cd, ad, sb);
                    break;
                }
                case HASHMAPPED: 
                case TREEMAPPED: 
                case HASHSET: 
                case TREESET: {
                    throw new IllegalStateException("Mapped and Set attributes aren't currently supported on AUXILIARY classes. Occurred with:\n" + cd.toOIF());
                }
            }
        }
        return sb.toString();
    }

    void formatAUXSV(ClassDefinition cd, AttributeDefinition ad, StringBuffer sb) {
        int lastPeriod;
        String typeClassName = ad.getType().getTypeClassName();
        String attrType = "DmcType" + ad.getType().getName();
        String typeName = ad.getType().getName().getNameString();
        String nullReturnValue = ad.getType().getNullReturnValue();
        String staticName = "__" + ad.getName();
        if (ad.getNullReturnValue() != null) {
            nullReturnValue = ad.getNullReturnValue();
        }
        String auxHolderClass = ad.getType().getAuxHolderClass();
        if (ad.getType().getIsRefType().booleanValue()) {
            attrType = attrType + "REF";
            typeName = typeName + "REF";
        }
        if (typeClassName != null && (lastPeriod = typeClassName.lastIndexOf(46)) != -1) {
            attrType = typeClassName.substring(lastPeriod + 1);
        }
        StringBuffer functionName = new StringBuffer();
        functionName.append(ad.getName());
        functionName.setCharAt(0, Character.toUpperCase(functionName.charAt(0)));
        attrType = attrType + "SV";
        sb.append("    /**\n");
        sb.append("     * Removes the " + ad.getName() + " attribute from the object.\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    static public DmcAttribute<?> rem" + functionName + "(" + this.baseWrapper + " corew){\n");
        sb.append("        if (corew == null)\n");
        sb.append("            return(null);\n");
        sb.append("        DmcAttribute<?> rc = corew.getDmcObject().rem(__" + ad.getName() + ");\n");
        sb.append("        removeAuxIfRequired(corew);\n");
        sb.append("        return(rc);\n");
        sb.append("    }\n");
        sb.append("\n");
        if (ad.getType().getIsRefType().booleanValue()) {
            String REF = ad.getType().getOriginalClass().getName() + "REF";
            sb.append("    /**\n");
            sb.append("     * @return A " + auxHolderClass + " object.\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    static public " + auxHolderClass + " get" + functionName + "(" + this.baseWrapper + " corew){\n");
            sb.append("        DmcAttribute<?> attr = corew.getDmcObject().get(" + staticName + ");\n");
            sb.append("        if (attr == null)\n");
            sb.append("            return(null);\n");
            sb.append("        \n");
            sb.append("        " + REF + " ref = (" + REF + ") attr.getSV();\n");
            sb.append("        \n");
            sb.append("        return((" + auxHolderClass + ")ref.getObject().getContainer());\n");
            sb.append("    }\n\n");
        } else {
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    static public " + typeName + " get" + functionName + "(" + this.baseWrapper + " corew){\n");
            sb.append("        " + attrType + " attr = (" + attrType + ") corew.getDmcObject().get(__" + ad.getName() + ");\n");
            sb.append("        if (attr == null)\n");
            if (nullReturnValue == null) {
                sb.append("            return(null);\n");
            } else {
                sb.append("            return(" + nullReturnValue + ");\n");
            }
            sb.append("\n");
            sb.append("        return(attr.getSV());\n");
            sb.append("    }\n\n");
        }
        if (ad.getType().getIsRefType().booleanValue()) {
            sb.append("    /**\n");
            sb.append("     * Sets the " + ad.getName() + " to the specified value.\n");
            sb.append("     * @param value A value compatible with " + typeName + "\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    static public void set" + functionName + "(" + this.baseWrapper + " corew, Object value) throws DmcValueException {\n");
            sb.append("        DmcAttribute<?> attr = corew.getDmcObject().get(" + staticName + ");\n");
            sb.append("        if (attr == null){\n");
            sb.append("            attr = new " + attrType + "();\n");
            sb.append("            addAuxIfRequired(corew);\n");
            sb.append("        }\n\n");
            sb.append("        attr.set(value);\n");
            sb.append("        corew.getDmcObject().set(" + staticName + ", attr);\n");
            sb.append("    }\n\n");
        } else {
            sb.append("    /**\n");
            sb.append("     * Sets " + ad.getName() + " to the specified value.\n");
            sb.append("     * @param value A value compatible with " + attrType + "\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    static public void set" + functionName + "(" + this.baseWrapper + " corew, Object value) throws DmcValueException {\n");
            sb.append("        DmcAttribute<?> attr = corew.getDmcObject().get(" + staticName + ");\n");
            sb.append("        if (attr == null){\n");
            sb.append("            attr = new " + attrType + "();\n");
            sb.append("            addAuxIfRequired(corew);\n");
            sb.append("        }\n");
            sb.append("        \n");
            sb.append("        attr.set(value);\n");
            sb.append("        corew.getDmcObject().set(" + staticName + ",attr);\n");
            sb.append("    }\n\n");
        }
    }

    void formatAUXMV(ClassDefinition cd, AttributeDefinition ad, StringBuffer sb) {
        int lastPeriod;
        String typeClassName = ad.getType().getTypeClassName();
        String attrType = "DmcType" + ad.getType().getName();
        String typeName = ad.getType().getName().getNameString();
        String auxHolderClass = ad.getType().getAuxHolderClass();
        if (ad.getType().getIsRefType().booleanValue()) {
            attrType = attrType + "REF";
        }
        if (typeClassName != null && (lastPeriod = typeClassName.lastIndexOf(46)) != -1) {
            attrType = typeClassName.substring(lastPeriod + 1);
        }
        StringBuffer functionName = new StringBuffer();
        functionName.append(ad.getName());
        functionName.setCharAt(0, Character.toUpperCase(functionName.charAt(0)));
        attrType = attrType + "MV";
        sb.append("    /**\n");
        sb.append("     * Removes the " + ad.getName() + " attribute from the object.\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    static public DmcAttribute<?> rem" + functionName + "(" + this.baseWrapper + " corew){\n");
        sb.append("        if (corew == null)\n");
        sb.append("            return(null);\n");
        sb.append("        DmcAttribute<?> rc = corew.getDmcObject().rem(__" + ad.getName() + ");\n");
        sb.append("        removeAuxIfRequired(corew);\n");
        sb.append("        return(rc);\n");
        sb.append("    }\n");
        sb.append("\n");
        sb.append("    /**\n");
        sb.append("     * @return The number of " + typeName + "DMO items.\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    static public int get" + functionName + "Size(" + this.baseWrapper + " corew){\n");
        sb.append("        DmcAttribute<?> attr = corew.getDmcObject().get(__" + ad.getName() + ");\n");
        sb.append("        if (attr == null)\n");
        sb.append("            return(0);\n");
        sb.append("        \n");
        sb.append("        return(attr.getMVSize());\n");
        sb.append("    }\n\n");
        sb.append("    /**\n");
        sb.append("     * @return true if there are no " + typeName + "DMO items.\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    static public boolean get" + functionName + "IsEmpty(" + this.baseWrapper + " corew){\n");
        sb.append("        DmcAttribute<?> attr = corew.getDmcObject().get(__" + ad.getName() + ");\n");
        sb.append("        if (attr == null)\n");
        sb.append("            return(true);\n");
        sb.append("        \n");
        sb.append("        return(false);\n");
        sb.append("    }\n\n");
        sb.append("    /**\n");
        sb.append("     * @return true if there are any " + typeName + "DMO items.\n");
        sb.append("     */\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    static public boolean get" + functionName + "HasValue(" + this.baseWrapper + " corew){\n");
        sb.append("        DmcAttribute<?> attr = corew.getDmcObject().get(__" + ad.getName() + ");\n");
        sb.append("        if (attr == null)\n");
        sb.append("            return(false);\n");
        sb.append("        \n");
        sb.append("        return(true);\n");
        sb.append("    }\n\n");
        if (ad.getType().getIsRefType().booleanValue()) {
            String itClass = ad.getType().getOriginalClass().getDmwIteratorClass();
            sb.append("    /**\n");
            sb.append("     * @return An Iterator of " + typeName + "DMO objects.\n");
            sb.append("     */\n");
            sb.append("    @SuppressWarnings(\"unchecked\")\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    static public " + itClass + " get" + functionName + "Iterable(" + this.baseWrapper + " corew){\n");
            sb.append("        DmcAttribute attr = corew.getDmcObject().get(__" + ad.getName() + ");\n");
            sb.append("        if (attr == null)\n");
            sb.append("            return(" + itClass + ".emptyList);\n");
            sb.append("        \n");
            sb.append("        return(new " + itClass + "(attr.getMV()));\n");
            sb.append("    }\n\n");
            sb.append("    /**\n");
            sb.append("     * Adds another " + ad.getName() + " value.\n");
            sb.append("     * @param value A value compatible with " + typeName + "\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    static public DmcAttribute<?> add" + functionName + "(" + this.baseWrapper + " corew, " + auxHolderClass + " value) throws DmcValueException {\n");
            sb.append("        DmcAttribute<?> attr = corew.getDmcObject().get(__" + ad.getName() + ");\n");
            sb.append("        if (attr == null){\n");
            sb.append("            attr = new " + attrType + "();\n");
            sb.append("            attr.add(value.getDmcObject());\n");
            sb.append("            addAuxIfRequired(corew);\n");
            sb.append("        }\n");
            sb.append("        else\n");
            sb.append("            attr.add(value);\n");
            sb.append("        \n");
            sb.append("        corew.getDmcObject().add(__" + ad.getName() + ",attr);\n");
            sb.append("        \n");
            sb.append("        return(attr);\n");
            sb.append("    }\n\n");
            sb.append("    /**\n");
            sb.append("     * Deletes a " + ad.getName() + " value.\n");
            sb.append("     * @param value The " + typeName + " to be deleted from set of attribute values.\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    static public void del" + functionName + "(" + this.baseWrapper + " corew, " + auxHolderClass + " value){\n");
            sb.append("        corew.getDmcObject().del(__" + ad.getName() + ", value);\n");
            sb.append("        removeAuxIfRequired(corew);\n");
            sb.append("    }\n\n");
        } else {
            sb.append("    /**\n");
            sb.append("     * @return An Iterator of " + typeName + " objects.\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    static public Iterator<" + typeName + "> get" + functionName + "(" + this.baseWrapper + " corew){\n");
            sb.append("        " + attrType + " attr = (" + attrType + ") corew.getDmcObject().get(__" + ad.getName() + ");\n");
            sb.append("        if(attr == null)\n");
            sb.append("            return(null);\n");
            sb.append("        return(attr.getMV());\n");
            sb.append("    }\n\n");
            sb.append("    /**\n");
            sb.append("     * Adds another " + ad.getName() + " value.\n");
            sb.append("     * @param value A value compatible with " + typeName + "\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    static public void add" + functionName + "(" + this.baseWrapper + " corew, Object value) throws DmcValueException {\n");
            sb.append("        addAuxIfRequired(corew);\n");
            sb.append("        DmcAttribute<?> attr = corew.getDmcObject().get(__" + ad.getName() + ");\n");
            sb.append("        if (attr == null)\n");
            sb.append("            attr = new " + attrType + "(__" + ad.getName() + ");\n");
            sb.append("        \n");
            sb.append("        try{\n");
            sb.append("            corew.getDmcObject().add(__" + ad.getName() + ",attr);\n");
            sb.append("        }\n");
            sb.append("        catch(DmcValueException ex){\n");
            sb.append("            throw(new IllegalStateException(\"The type specific add() method shouldn't throw exceptions!\",ex));\n");
            sb.append("        }\n");
            sb.append("    }\n\n");
            sb.append("    /**\n");
            sb.append("     * Deletes a " + ad.getName() + " value.\n");
            sb.append("     * @param value The " + typeName + " to be deleted from set of attribute values.\n");
            sb.append("     */\n");
            sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    static public void del" + functionName + "(" + this.baseWrapper + " corew, Object value){\n");
            sb.append("        corew.getDmcObject().del(__" + ad.getName() + ", value);\n");
            sb.append("        removeAuxIfRequired(corew);\n");
            sb.append("    }\n\n");
        }
    }

    protected void createIfRequired(String outdir) {
        if (outdir == null) {
            return;
        }
        File dir = new File(outdir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }
}

