/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmg.generators;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmg.generated.dmo.DmgConfigDMO;
import org.dmd.dmg.generators.BaseDMWGenerator;
import org.dmd.dmg.generators.DSDArtifactFormatter;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.ClassDefinition;
import org.dmd.dms.ComplexTypeDefinition;
import org.dmd.dms.DSDefinitionModule;
import org.dmd.dms.EnumDefinition;
import org.dmd.dms.SchemaDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.TypeDefinition;
import org.dmd.dms.generated.dmw.ClassDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.ComplexTypeDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.EnumDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.TypeDefinitionIterableDMW;
import org.dmd.dms.generated.enums.ClassTypeEnum;
import org.dmd.dms.generated.enums.WrapperTypeEnum;
import org.dmd.dms.util.GenUtility;
import org.dmd.util.UtilityOptions;
import org.dmd.util.codegen.ImplementsManager;
import org.dmd.util.codegen.ImportManager;
import org.dmd.util.codegen.Manipulator;
import org.dmd.util.codegen.MemberManager;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.parsing.ConfigFinder;
import org.dmd.util.parsing.ConfigLocation;

public class DMWGenerator
extends BaseDMWGenerator {
    DSDArtifactFormatter dsdFormatter;

    public DMWGenerator() {
        this.genContext = "dmw";
        this.genSuffix = "DMW";
        this.baseWrapperImport = "org.dmd.dmw.DmwWrapper";
        this.namedWrapperImport = "org.dmd.dmw.DmwNamedObjectWrapper";
        this.hierarchicWrapperImport = "org.dmd.dmw.DmwHierarchicObjectWrapper";
        this.fullJavaEnvironment = true;
        this.dsdFormatter = new DSDArtifactFormatter();
    }

    @Override
    public void generateCode(DmgConfigDMO config, ConfigLocation loc, ConfigFinder f, SchemaManager sm) throws IOException, ResultException, DmcNameClashException, DmcValueException {
        this.gendir = loc.getConfigParentDirectory() + File.separator + "generated";
        this.extendedDir = loc.getConfigParentDirectory() + File.separator + "extended";
        this.dmwdir = this.gendir + File.separator + "dmw";
        this.createIfRequired(this.gendir);
        this.schema = sm;
        this.createTypeIterables(config, loc, f, sm);
        this.createWrappers(config, loc, f, sm);
        this.createExtendedWrapperClasses(config, loc, f, sm);
        this.sformatter.setFileHeader(this.fileHeader);
        this.sformatter.setProgressStream(this.progress);
        SchemaDefinition sd = sm.isSchema(config.getSchemaToLoad());
        this.sformatter.dumpSchema(this.gendir, config.getGenPackage(), sd, sm);
        this.dsdFormatter.setFileHeader(this.fileHeader);
        this.dsdFormatter.setProgressStream(this.progress);
        this.dsdFormatter.generateCode(config, loc, f, sd, sm);
    }

    void createTypeIterables(DmgConfigDMO config, ConfigLocation loc, ConfigFinder f, SchemaManager sm) throws IOException, ResultException {
        ComplexTypeDefinitionIterableDMW ctypes;
        EnumDefinitionIterableDMW enums;
        TypeDefinitionIterableDMW types;
        ClassDefinitionIterableDMW classes;
        SchemaDefinition sd = sm.isSchema(config.getSchemaToLoad());
        if (!UtilityOptions.instance().quietProgress()) {
            sd.dumpInfo();
        }
        if ((classes = sd.getClassDefList()) != null) {
            this.createIfRequired(this.dmwdir);
            while (classes.hasNext()) {
                ClassDefinition cd = (ClassDefinition)classes.next();
                if (cd.getClassType() == ClassTypeEnum.AUXILIARY || cd.getIsNamedBy() != null) continue;
                String dmwImport = cd.getDmwImport();
                if (cd.getUseWrapperType() == WrapperTypeEnum.EXTENDED) {
                    dmwImport = cd.getDmeImport();
                }
                GenUtility.dumpObjectIterable(this.dmwdir, sd.getDmwPackage(), cd.getDmoImport(), cd.getName().getNameString(), dmwImport, "", this.fileHeader, this.progress);
            }
        }
        if ((types = sd.getTypeDefList()) != null) {
            while (types.hasNext()) {
                TypeDefinition td = (TypeDefinition)types.next();
                String genericArgs = td.getGenericArgs();
                if (genericArgs == null) {
                    genericArgs = "";
                }
                GenUtility.dumpIterable(this.dmwdir, sd.getDmwPackage(), td.getPrimitiveType(), td.getName().getNameString(), genericArgs, this.fileHeader, this.progress);
            }
        }
        if ((enums = sd.getEnumDefList()) != null) {
            while (enums.hasNext()) {
                EnumDefinition ed = (EnumDefinition)enums.next();
                String enumPrimitive = sd.getSchemaPackage() + ".generated.enums." + ed.getName().getNameString();
                GenUtility.dumpIterable(this.dmwdir, sd.getDmwPackage(), enumPrimitive, ed.getName().getNameString(), "", this.fileHeader, this.progress);
            }
        }
        if ((ctypes = sd.getComplexTypeDefList()) != null) {
            while (ctypes.hasNext()) {
                ComplexTypeDefinition ctd = (ComplexTypeDefinition)ctypes.next();
                DebugInfo.debug("Generating Iterator for: " + ctd.getName().getNameString());
                String primitive = sd.getSchemaPackage() + ".generated.types." + ctd.getName().getNameString();
                GenUtility.dumpIterable(this.dmwdir, sd.getDmwPackage(), primitive, ctd.getName().getNameString(), "", this.fileHeader, this.progress);
            }
        }
    }

    @Override
    protected void createCloneItMethod(BufferedWriter out, DmgConfigDMO config, ConfigLocation loc, ConfigFinder f, SchemaManager sm, ClassDefinition cd) throws IOException {
        if (cd.getClassType() == ClassTypeEnum.STRUCTURAL) {
            if (cd.getDmwWrapperType(this.genContext) == WrapperTypeEnum.EXTENDED) {
                out.write("    public " + cd.getName() + " cloneIt() {\n");
                out.write("        " + cd.getName() + " rc = new " + cd.getName() + "();\n");
                out.write("        rc.setDmcObject(getDMO().cloneIt());\n");
                out.write("        return(rc);\n");
                out.write("    }\n\n");
            } else {
                out.write("    public " + cd.getName() + this.genSuffix + " cloneIt() {\n");
                out.write("        " + cd.getName() + this.genSuffix + " rc = new " + cd.getName() + this.genSuffix + "();\n");
                out.write("        rc.setDmcObject(getDMO().cloneIt());\n");
                out.write("        return(rc);\n");
                out.write("    }\n\n");
            }
        }
    }

    @Override
    public void getAdditionalWrapperImports(DmgConfigDMO config, ConfigLocation loc, ConfigFinder f, SchemaManager sm, ClassDefinition cd, ImportManager imports) throws IOException {
        if (cd.getDsdModuleDefinition() != null) {
            DSDefinitionModule dsdm = cd.getDsdModuleDefinition();
            imports.addImport(dsdm.getScopedInterfaceImport(), "Required to manage module definition");
            imports.addImport("org.dmd.dmc.definitions.DmcDefinitionSet", "Our base to provide definition set storage");
            dsdm.getImportsForInterface(imports, true);
        }
        if (cd.getPartOfDefinitionModule() != null && cd.getClassType() == ClassTypeEnum.STRUCTURAL) {
            AttributeDefinition attr = cd.getPartOfDefinitionModule().getDefinedInModuleAttribute();
            TypeDefinition td = attr.getType();
            imports.addImport(td.getOriginalClass().getDmtREFImport(), "Required to access defined in module name");
        }
    }

    @Override
    public void getAdditionalWrapperInterfaces(DmgConfigDMO config, ConfigLocation loc, ConfigFinder f, SchemaManager sm, ClassDefinition cd, ImplementsManager implManager) throws IOException {
        if (cd.getDsdModuleDefinition() != null) {
            DSDefinitionModule dsdm = cd.getDsdModuleDefinition();
            implManager.addImplements(dsdm.getScopedInterfaceName());
        }
    }

    @Override
    public void dumpAdditionalWrapperDefinitions(DmgConfigDMO config, ConfigLocation loc, ConfigFinder f, SchemaManager sm, ClassDefinition cd, BufferedWriter out) throws IOException {
        if (cd.getDsdModuleDefinition() != null) {
            DSDefinitionModule dsdm = cd.getDsdModuleDefinition();
            MemberManager members = new MemberManager();
            dsdm.getScopedInterfaceMembers(members, dsdm.getName().getNameString());
            out.write(members.getFormattedMembers() + "\n");
        }
    }

    @Override
    public void dumpAdditionalWrapperFunctions(DmgConfigDMO config, ConfigLocation loc, ConfigFinder f, SchemaManager sm, ClassDefinition cd, BufferedWriter out) throws IOException {
        if (cd.getDsdModuleDefinition() != null) {
            DSDefinitionModule dsdm = cd.getDsdModuleDefinition();
            out.write(dsdm.getInterfaceMethodsImplementations(true));
        }
        if (cd.getPartOfDefinitionModule() != null && cd.getClassType() == ClassTypeEnum.STRUCTURAL) {
            if (cd.getDsdModuleDefinition() != null) {
                out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                out.write("    /**\n");
                out.write("     * This method indicates the name of the module from which this definition was loaded.\n");
                out.write("     * And, since this is a module, it's just the name of the module.\n");
                out.write("     */\n");
                out.write("    @Override\n");
                out.write("    public String getNameOfModuleWhereThisCameFrom(){\n");
                out.write("        return(getName().getNameString());\n");
                out.write("    }\n\n");
            } else {
                AttributeDefinition attr = cd.getPartOfDefinitionModule().getDefinedInModuleAttribute();
                String attrNamePart = Manipulator.capFirstChar(attr.getName().getNameString());
                out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                out.write("    /**\n");
                out.write("     * This method indicates the name of the module from which this definition was loaded.\n");
                out.write("     */\n");
                out.write("    @Override\n");
                out.write("    public String getNameOfModuleWhereThisCameFrom(){\n");
                out.write("        " + cd.getPartOfDefinitionModule().getName() + "REF ref = ((" + cd.getName() + "DMO) core).get" + attrNamePart + "();\n");
                out.write("        return(ref.getName().getNameString());\n");
                out.write("    }\n\n");
            }
        }
    }

    @Override
    public void dumpExtendedClass(DmgConfigDMO config, ConfigLocation loc, ConfigFinder f, SchemaManager sm, ClassDefinition cd) throws IOException {
        String subfolder = "";
        String outdir = this.extendedDir;
        if (cd.getSubpackage() != null) {
            subfolder = cd.getSubpackage().replaceAll("\\.", "/");
            DebugInfo.debug("Subfolder = " + subfolder);
            outdir = this.extendedDir + "/" + subfolder;
        }
        this.createIfRequired(outdir);
        String outfn = outdir + "/" + cd.getName().getNameString() + ".java";
        File file = new File(outfn);
        if (file.exists()) {
            return;
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(outfn));
        String abstractClass = "";
        if (cd.getClassType() == ClassTypeEnum.ABSTRACT) {
            abstractClass = "abstract ";
        }
        ImportManager imports = new ImportManager();
        imports.addImport(cd.getDmwPackage(this.genContext) + ".generated." + this.genContext + "." + cd.getName() + this.genSuffix, "The wrapper we're extending");
        imports.addImport(cd.getDmoImport(), "The wrapper we're extending");
        imports.addImport("org.dmd.dms.ClassDefinition", "Used in derived constructors");
        imports.addImport("org.dmd.util.exceptions.ResultException", "To report errors from validation");
        String defAccess = cd.getPartOfDefinitionModule().getModuleClassName() + "DefinitionsIF";
        imports.addImport(config.getGenPackage() + ".generated.dsd." + defAccess, "Definitions access");
        if (cd.getDsdModuleDefinition() != null) {
            imports.addImport("java.util.Iterator", "To iterate definitions");
        }
        int lastDot = cd.getDmeImport().lastIndexOf(".");
        out.write("package " + cd.getDmeImport().substring(0, lastDot) + ";\n\n");
        out.write(imports.getFormattedImports() + "\n");
        out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write(abstractClass + "public class " + cd.getName() + " extends " + cd.getName() + this.genSuffix + " {\n\n");
        out.write("    private boolean initialized;\n\n");
        out.write("    public " + cd.getName() + "(){\n");
        out.write("        super();\n");
        out.write("    }\n\n");
        out.write("    public " + cd.getName() + "(" + cd.getName() + "DMO dmo, ClassDefinition cd){\n");
        out.write("        super(dmo,cd);\n");
        out.write("    }\n\n");
        out.write("    public void initialize(" + defAccess + " definitions) throws ResultException {\n");
        out.write("        if (!initialized){\n");
        out.write("            // Add any required initialization or validation checks\n");
        out.write("            // If you fail validation, throw a ResultException that includes a clear\n");
        out.write("            // error description and location - uncomment the following example:\n");
        out.write("//            ResultException ex = new ResultException(\"Error description\");\n");
        out.write("//            ex.moreMessages(\"Additional error information\");\n");
        out.write("//            ex.setLocationInfo(getFile(), getLineNumber());\n");
        out.write("//            throw(ex);\n");
        out.write("            initialized = true;\n");
        out.write("        }\n");
        out.write("    }\n\n");
        if (cd.getDsdModuleDefinition() != null) {
            String baseDefName = cd.getDsdModuleDefinition().getBaseDefinition().getName().getNameString();
            out.write("    /**\n");
            out.write("     * @return the module in JSON format.\n");
            out.write("     */\n");
            out.write("    @Override\n");
            out.write("    public String toJSON() {\n");
            out.write("        StringBuffer sb = new StringBuffer();\n");
            out.write("        \n");
            out.write("        core.toJSON(sb, 0, \"\");\n");
            out.write("        \n");
            out.write("        if (get" + baseDefName + "Count() > 0) {\n");
            out.write("            // Remove the final }\\n\n");
            out.write("            sb.deleteCharAt(sb.length()-1);\n");
            out.write("            sb.deleteCharAt(sb.length()-1);\n");
            out.write("            \n");
            out.write("            sb.append(\",\\n\");\n");
            out.write("            sb.append(\"    \\\"definitions\\\": [\\n\");\n");
            out.write("            \n");
            out.write("            Iterator<" + baseDefName + "> it = getAll" + baseDefName + "();\n");
            out.write("            while(it.hasNext()) {\n");
            out.write("                " + baseDefName + " def = it.next();                \n");
            out.write("                def.getDMO().toJSON(sb, 0, \"      \");\n");
            out.write("                \n");
            out.write("                if (it.hasNext())\n");
            out.write("                    sb.append(\",\\n\");\n");
            out.write("            }\n");
            out.write("            sb.append(\"\\n    ]\\n\");\n");
            out.write("            \n");
            out.write("            sb.append(\"}\");\n");
            out.write("        }\n");
            out.write("        \n");
            out.write("        return(sb.toString());\n");
            out.write("    }\n");
        }
        out.write("}\n\n");
        out.close();
    }
}

