/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmg.tools.dmggenerator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.Iterator;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmg.generated.dmo.DmgConfigDMO;
import org.dmd.dmg.tools.dmggenerator.DmgParser;
import org.dmd.dmg.types.Generator;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.util.DmoGenerator;
import org.dmd.dms.util.DmsSchemaParser;
import org.dmd.util.BooleanVar;
import org.dmd.util.FileUpdateManager;
import org.dmd.util.UtilityOptions;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.formatting.PrintfFormat;
import org.dmd.util.parsing.CommandLine;
import org.dmd.util.parsing.ConfigFinder;
import org.dmd.util.parsing.ConfigLocation;
import org.dmd.util.parsing.ConfigVersion;
import org.dmd.util.parsing.StringArrayList;

public class DmgGenUtility {
    SchemaManager baseSchema;
    SchemaManager baseWithDMGSchema;
    SchemaManager readSchemas;
    ConfigFinder schemaFinder;
    ConfigFinder configFinder;
    DmsSchemaParser schemaParser;
    DmgParser parser;
    DmoGenerator codeGenerator;
    PrintfFormat format;
    String fileHeader;
    CommandLine cl;
    StringBuffer help;
    BooleanVar helpFlag = new BooleanVar();
    StringArrayList srcdir = new StringArrayList();
    StringBuffer workspace = new StringBuffer();
    BooleanVar autogen = new BooleanVar();
    StringBuffer cfg = new StringBuffer();
    BooleanVar debug = new BooleanVar();
    StringArrayList jars = new StringArrayList();
    StringArrayList targets = new StringArrayList();
    BooleanVar qwarnings = new BooleanVar();
    BooleanVar qprogress = new BooleanVar();

    public DmgGenUtility(String[] args) throws ResultException, IOException, DmcValueException, DmcValueExceptionSet, DmcRuleExceptionSet, DmcNameClashException {
        this.initHelp();
        this.cl = new CommandLine();
        this.cl.addOption("-h", this.helpFlag, "Dumps the help message.");
        this.cl.addOption("-srcdir", this.srcdir, "The source directories to search.");
        this.cl.addOption("-workspace", this.workspace, "The workspace prefix");
        this.cl.addOption("-autogen", this.autogen, "Indicates that you want to generate from all configs automatically.");
        this.cl.addOption("-cfg", this.cfg, "The configuration file to load.");
        this.cl.addOption("-debug", this.debug, "Dump debug information.");
        this.cl.addOption("-jars", this.jars, "The prefixs of jars to search for .dms config files.");
        this.cl.addOption("-targets", this.targets, "Indicates you only want to generate for the specified configs.");
        this.cl.addOption("-qwarnings", this.qwarnings, "Indicates that we don't want to see warning messages");
        this.cl.addOption("-qprogress", this.qprogress, "Indicates that we don't want to see progress messages");
        this.cl.parseArgs(args);
        if (this.helpFlag.booleanValue()) {
            System.out.println(this.help.toString());
        }
        if (this.qwarnings.booleanValue()) {
            UtilityOptions.instance().quiteWarnings(this.qwarnings.booleanValue());
        }
        if (this.qprogress.booleanValue()) {
            UtilityOptions.instance().quiteProgress(this.qprogress.booleanValue());
        }
        this.baseSchema = new SchemaManager();
        this.baseWithDMGSchema = new SchemaManager();
        this.readSchemas = null;
        StringArrayList searchdirs = new StringArrayList();
        if (this.srcdir.size() > 0) {
            searchdirs = new StringArrayList();
            for (String dir : this.srcdir) {
                searchdirs.add(this.workspace.toString() + "/" + dir);
            }
        } else {
            searchdirs = this.srcdir;
        }
        this.schemaFinder = new ConfigFinder(searchdirs.iterator());
        if (this.jars.size() > 0) {
            for (String jar : this.jars) {
                this.schemaFinder.addJarPrefix(jar);
            }
        }
        if (this.debug.booleanValue()) {
            this.schemaFinder.debug(true);
        }
        this.schemaFinder.addSuffix(".dms");
        this.schemaFinder.findConfigs();
        this.schemaParser = new DmsSchemaParser(this.baseSchema, this.schemaFinder);
        this.schemaParser.parseSchema(this.baseWithDMGSchema, "dmg", true);
        this.configFinder = new ConfigFinder(searchdirs.iterator());
        this.configFinder.addSuffix(".dmg");
        this.configFinder.findConfigs();
        if (this.debug.booleanValue()) {
            this.configFinder.debug(true);
        }
        this.parser = new DmgParser(this.baseWithDMGSchema, this.configFinder);
        this.codeGenerator = new DmoGenerator(System.out);
        String f = "%-" + this.configFinder.getLongestName() + "s";
        this.format = new PrintfFormat(f);
        this.fileHeader = "";
    }

    void initHelp() {
        String userHome = System.getProperty("user.home");
        this.help = new StringBuffer();
        this.help.append("dmwgen -h -cfg -workspace -srcdir -autogen\n\n");
        this.help.append("The dmwgen tool generates Dark Matter Wrappers based on a specified schema.\n");
        this.help.append("Schemas configurations (that end with a .dms extension) are recursivley discovered\n");
        this.help.append("in your development environment using information you provide in one of several ways.\n");
        this.help.append("\n");
        this.help.append("The default behaviour is to look for a .darkmatter folder in " + userHome + "\n");
        this.help.append("and to read the sourcedirs.txt file that resides there. The sourcedirs.txt file\n");
        this.help.append("specifies file paths to search, one path per line. The path must be fully qualified\n");
        this.help.append("i.e. C:/mydev/myproject/src\n");
        this.help.append("\n");
        this.help.append("The tool can also search .jar files that contain schemas defined by others. \n");
        this.help.append("Just specify a line with the jar file name (or the last part thereof). As long\n");
        this.help.append("the line ends with .jar, all jars that end with that suffix will be searched for\n");
        this.help.append("schema configurations.\n");
        this.help.append("\n");
        this.help.append("You can also specify code locations on the command line via the -srcdir option.\n");
        this.help.append("\n");
        this.help.append("If you specify the -workspace option, this prefix will be placed in front of all \n");
        this.help.append("arguments to the -srcdir option.\n");
        this.help.append("\n");
        this.help.append("Or you can specify a configuration file (formatted like sourcedirs.txt) to load.\n");
        this.help.append("via the -cfg option.\n");
        this.help.append("\n");
        this.help.append("-h dumps the help information.\n");
        this.help.append("\n");
        this.help.append("\n");
        this.help.append("\n");
        this.help.append("\n");
        this.help.append("example: dmwgen -workspace C:/eclipse/workspace -srcdir proj1/src proj2/src proj3/src\n");
        this.help.append("\n");
    }

    /*
     * Unable to fully structure code
     */
    public void run() throws DmcValueExceptionSet, DmcRuleExceptionSet, DmcNameClashException {
        in = new BufferedReader(new InputStreamReader(System.in));
        currLine = null;
        if (this.autogen.booleanValue()) {
            if (this.autogen.booleanValue()) {
                for (ConfigVersion version : this.configFinder.getVersions().values()) {
                    loc = version.getLatestVersion();
                    if (loc.isFromJAR()) continue;
                    if (this.targets.contains(loc.getConfigName())) {
                        this.generateFromConfig(version);
                        continue;
                    }
                    if (UtilityOptions.instance().quietWarnings()) continue;
                    System.out.println("DMWGEN: " + loc.getConfigName() + " is not in the -targets list - not generating:  " + loc.getDirectory() + "\n");
                }
                return;
            }
            System.exit(0);
        }
        System.out.println("\ndmg generator - enter the name of the Dark Matter Generator config\n");
        System.out.println("Enter ? for a list of configs...\n\n");
        block6: while (true) {
            try {
                while (true) lbl-1000:
                // 6 sources

                {
                    if ((s = in.readLine()) == null) {
                        return;
                    }
                    currLine = s.trim();
                    if (currLine.length() == 0) continue;
                    currConfig = this.configFinder.getConfig(currLine);
                    if (currLine.equals("?")) {
                        System.out.println("");
                        System.out.println(this.configFinder.getSearchInfo() + "\n");
                        for (ConfigVersion version : this.configFinder.getVersions().values()) {
                            loc = version.getLatestVersion();
                            if (loc.getJarFilename() == null) {
                                System.out.println(this.format.sprintf(loc.getConfigName()) + "   version: " + loc.getVersion());
                                System.out.println(this.format.sprintf("") + " " + loc.getConfigParentDirectory() + "\n");
                                continue;
                            }
                            System.out.println(this.format.sprintf("JAR " + loc.getConfigName()) + " " + loc.getDirectory());
                            System.out.println(this.format.sprintf("") + " " + loc.getConfigParentDirectory() + "\n");
                        }
                        System.out.println("");
                        continue;
                    }
                    if (currConfig == null) {
                        System.err.println("\n" + currLine + " is not a recoginized config name.\n\n");
                        continue;
                    }
                    try {
                        this.parser.parseConfig(currConfig.getLatestVersion());
                        this.loadRequiredSchemas();
                        generators = this.parser.getTheConfig().getGenerator();
                        this.readFileHeader(this.parser.getTheConfig(), currConfig.getLatestVersion());
                        if (generators == null) continue block6;
                        while (true) {
                            if (!generators.hasNext()) continue block6;
                            g = generators.next();
                            g.getGenerator().setProgressStream(System.out);
                            g.getGenerator().setFileHeader(this.fileHeader);
                            FileUpdateManager.instance().reportProgress(System.out);
                            FileUpdateManager.instance().reportErrors(System.err);
                            FileUpdateManager.instance().generationStarting();
                            g.getGenerator().generateCode(this.parser.getTheConfig(), currConfig.getLatestVersion(), this.configFinder, this.readSchemas);
                            FileUpdateManager.instance().generationComplete();
                        }
                    }
                    catch (ResultException e) {
                        e.printStackTrace();
                    }
                    catch (DmcValueException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                System.out.println("IOException:\n" + e.getMessage());
                System.exit(1);
                continue;
            }
            ** GOTO lbl-1000
            break;
        }
    }

    void loadRequiredSchemas() throws ResultException, DmcValueException, DmcValueExceptionSet, DmcRuleExceptionSet, DmcNameClashException {
        this.readSchemas = new SchemaManager();
        this.schemaParser.parseSchema(this.readSchemas, this.parser.getTheConfig().getSchemaToLoad(), true);
    }

    void readFileHeader(DmgConfigDMO config, ConfigLocation sl) throws IOException {
        this.fileHeader = "";
        if (config.getGeneratedFileHeader() != null) {
            StringBuffer sb = new StringBuffer();
            if (sl.getJarFilename() != null) {
                String str;
                URL url = new URL("jar:file:" + sl.getJarFilename() + "!/" + sl.getJarDirectory() + "/" + config.getGeneratedFileHeader());
                LineNumberReader in = new LineNumberReader(new InputStreamReader(url.openStream()));
                while ((str = in.readLine()) != null) {
                    sb.append(str + "\n");
                }
                in.close();
            } else {
                String str;
                LineNumberReader in = new LineNumberReader(new FileReader(sl.getDirectory() + File.separator + config.getGeneratedFileHeader()));
                while ((str = in.readLine()) != null) {
                    sb.append(str + "\n");
                }
                in.close();
            }
            this.fileHeader = sb.toString();
        }
    }

    void generateFromConfig(ConfigVersion currConfig) throws DmcRuleExceptionSet, DmcNameClashException {
        try {
            this.parser.parseConfig(currConfig.getLatestVersion());
            this.loadRequiredSchemas();
            Iterator<Generator> generators = this.parser.getTheConfig().getGenerator();
            this.readFileHeader(this.parser.getTheConfig(), currConfig.getLatestVersion());
            if (generators != null) {
                while (generators.hasNext()) {
                    Generator g = generators.next();
                    g.getGenerator().setProgressStream(System.out);
                    g.getGenerator().setFileHeader(this.fileHeader);
                    FileUpdateManager.instance().reportProgress(System.out);
                    FileUpdateManager.instance().reportErrors(System.err);
                    FileUpdateManager.instance().generationStarting();
                    g.getGenerator().generateCode(this.parser.getTheConfig(), currConfig.getLatestVersion(), this.configFinder, this.readSchemas);
                    FileUpdateManager.instance().generationComplete();
                }
            }
        }
        catch (ResultException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (DmcValueException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (DmcValueExceptionSet e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

