/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmg.util;

import java.util.StringTokenizer;
import java.util.TreeMap;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.ClassDefinition;
import org.dmd.dms.TypeDefinition;
import org.dmd.dms.generated.dmw.AttributeDefinitionIterableDMW;
import org.dmd.util.BooleanVar;

public class GeneratorUtils {
    public static void getAttributesAndImports(ClassDefinition cd, String baseClass, TreeMap<DefinitionName, AttributeDefinition> allAttr, StringBuffer sb) {
        BooleanVar needJavaUtil = new BooleanVar(false);
        TreeMap<DefinitionName, TypeDefinition> types = new TreeMap<DefinitionName, TypeDefinition>();
        GeneratorUtils.collectAllAttributes(cd, allAttr, types, needJavaUtil);
        if (needJavaUtil.booleanValue()) {
            sb.append("import java.util.*;\n\n");
        }
        if (cd.getIsNamedBy() != null) {
            sb.append("import org.dmd.dmc.DmcAttribute;\n");
        }
        sb.append("import org.dmd.dmc.DmcValueException;\n");
        for (TypeDefinition td : types.values()) {
            if (td.getPrimitiveType() == null) continue;
            if (td.getIsRefType().booleanValue()) {
                sb.append("import " + td.getOriginalClass().getInternalTypeRef().getHelperClassName() + ";\n");
                continue;
            }
            sb.append("import " + td.getPrimitiveType() + ";\n");
        }
        sb.append("\n");
        if (cd.getIsNamedBy() != null) {
            sb.append("import org.dmd.dmc.DmcNamedObjectIF;\n");
        }
        if (baseClass != null) {
            sb.append("import " + baseClass + ";\n");
        }
        sb.append("import " + cd.getDmoImport() + ";\n");
        sb.append("\n");
    }

    static void collectAllAttributes(ClassDefinition cd, TreeMap<DefinitionName, AttributeDefinition> allAttr, TreeMap<DefinitionName, TypeDefinition> types, BooleanVar needJavaUtil) {
        AttributeDefinitionIterableDMW must;
        AttributeDefinitionIterableDMW may;
        if (cd.getDerivedFrom() != null) {
            GeneratorUtils.collectAllAttributes(cd.getDerivedFrom(), allAttr, types, needJavaUtil);
        }
        if (cd.getIsNamedBy() != null) {
            TypeDefinition td = cd.getIsNamedBy().getType();
            types.put(td.getName(), td);
        }
        if ((may = cd.getMay()) != null) {
            while (may.hasNext()) {
                AttributeDefinition ad = (AttributeDefinition)may.next();
                TypeDefinition td = ad.getType();
                types.put(td.getName(), td);
                switch (ad.getValueType()) {
                    case SINGLE: {
                        break;
                    }
                    case MULTI: {
                        needJavaUtil.set(true);
                        break;
                    }
                    case HASHMAPPED: {
                        break;
                    }
                    case TREEMAPPED: {
                        break;
                    }
                    case HASHSET: {
                        break;
                    }
                }
                allAttr.put(ad.getName(), ad);
            }
        }
        if ((must = cd.getMust()) != null) {
            while (must.hasNext()) {
                AttributeDefinition ad = (AttributeDefinition)must.next();
                TypeDefinition td = ad.getType();
                types.put(td.getName(), td);
                switch (ad.getValueType()) {
                    case SINGLE: {
                        break;
                    }
                    case MULTI: {
                        needJavaUtil.set(true);
                        break;
                    }
                    case HASHMAPPED: {
                        break;
                    }
                    case TREEMAPPED: {
                        break;
                    }
                    case HASHSET: {
                        break;
                    }
                }
                allAttr.put(ad.getName(), ad);
            }
        }
    }

    public static String dotNameToCamelCase(String in) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(in, ".");
        while (tokenizer.hasMoreTokens()) {
            StringBuffer t = new StringBuffer(tokenizer.nextToken());
            t.setCharAt(0, Character.toUpperCase(t.charAt(0)));
            sb.append(t.toString());
        }
        return sb.toString();
    }

    public static String dotNameToUpperCaseConstant(String in) {
        String upper = in.toUpperCase();
        return upper.replaceAll("\\.", "_");
    }

    public static String getClassNameFromImport(String i) {
        int lastDot = i.lastIndexOf(".");
        if (lastDot == -1) {
            return "";
        }
        return i.substring(lastDot + 1);
    }
}

