/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmg.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcNamedObjectREF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dmc.types.DotName;
import org.dmd.dmg.util.GeneratorUtils;
import org.dmd.dms.ActionDefinition;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.ClassDefinition;
import org.dmd.dms.ComplexTypeDefinition;
import org.dmd.dms.DSDefinitionModule;
import org.dmd.dms.DmsDefinition;
import org.dmd.dms.EnumDefinition;
import org.dmd.dms.RuleDefinition;
import org.dmd.dms.SchemaDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.TypeDefinition;
import org.dmd.dms.generated.dmo.DmsDefinitionDMO;
import org.dmd.dms.generated.dmo.MetaDMSAG;
import org.dmd.dms.generated.dmo.SchemaDefinitionDMO;
import org.dmd.dms.generated.dmw.ActionDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.AttributeDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.ClassDefinitionDMW;
import org.dmd.dms.generated.dmw.ClassDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.ComplexTypeDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.DSDefinitionModuleIterableDMW;
import org.dmd.dms.generated.dmw.EnumDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.RuleDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.TypeDefinitionIterableDMW;
import org.dmd.dms.generated.enums.ClassTypeEnum;
import org.dmd.util.FileUpdateManager;
import org.dmd.util.ManagedFileWriter;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.formatting.CodeFormatter;

public class SchemaFormatter {
    static final int BREAKOUT_SIZE = 100;
    String fileHeader = "";
    PrintStream progress = null;
    ArrayList<VarToObject> allVars = new ArrayList();
    ArrayList<VarToObject> classVars = new ArrayList();
    ArrayList<VarToObject> attributeVars = new ArrayList();
    ArrayList<VarToObject> typeVars = new ArrayList();
    ArrayList<VarToObject> complexTypeVars = new ArrayList();
    ArrayList<VarToObject> actionVars = new ArrayList();
    ArrayList<VarToObject> enumVars = new ArrayList();
    ArrayList<VarToObject> ruleVars = new ArrayList();
    ArrayList<VarToObject> dsdModuleVars = new ArrayList();
    SchemaManager schemaManager;
    TreeMap<DefinitionName, String> auxImports;
    TreeMap<String, String> skip = new TreeMap();

    public SchemaFormatter() {
        this.skip.put(DmcObject.__objectClass.name, DmcObject.__objectClass.name);
        this.skip.put(MetaDMSAG.__derivedClasses.name, MetaDMSAG.__derivedClasses.name);
        this.skip.put(MetaDMSAG.__dmeClass.name, MetaDMSAG.__dmeClass.name);
        this.skip.put(MetaDMSAG.__dmeImport.name, MetaDMSAG.__dmeImport.name);
        this.skip.put(MetaDMSAG.__dmoClass.name, MetaDMSAG.__dmoClass.name);
        this.skip.put(MetaDMSAG.__dmoImport.name, MetaDMSAG.__dmoImport.name);
        this.skip.put(MetaDMSAG.__dmtClass.name, MetaDMSAG.__dmtClass.name);
        this.skip.put(MetaDMSAG.__dmtImport.name, MetaDMSAG.__dmtImport.name);
        this.skip.put(MetaDMSAG.__dmwClass.name, MetaDMSAG.__dmwClass.name);
        this.skip.put(MetaDMSAG.__dmwImport.name, MetaDMSAG.__dmwImport.name);
        this.skip.put(MetaDMSAG.__internalTypeRef.name, MetaDMSAG.__internalTypeRef.name);
        this.skip.put(MetaDMSAG.__javaClass.name, MetaDMSAG.__javaClass.name);
        this.skip.put(MetaDMSAG.__nameAttributeDef.name, MetaDMSAG.__nameAttributeDef.name);
    }

    public void setProgressStream(PrintStream ps) {
        this.progress = ps;
    }

    public void setFileHeader(String fh) {
        this.fileHeader = fh;
    }

    public void dumpSchema(String genDir, String genPackage, SchemaDefinition schema, SchemaManager sm) throws IOException {
        String sclass;
        SchemaDefinition ds;
        String dep;
        Iterator<String> dependsOn;
        boolean hasDependency = false;
        this.auxImports = new TreeMap();
        if (schema.getDependsOn() != null) {
            hasDependency = true;
        }
        this.schemaManager = sm;
        String schemaName = GeneratorUtils.dotNameToCamelCase(schema.getName().getNameString()) + "SchemaAG";
        String asagName = GeneratorUtils.dotNameToCamelCase(schema.getName().getNameString()) + "DMSAG";
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(genDir, schemaName + ".java");
        if (this.fileHeader != null) {
            out.write(this.fileHeader);
        }
        out.write("package " + genPackage + ".generated;\n\n");
        String staticRefs = this.getStaticRefs(schema);
        this.getInstantiations();
        out.write("import org.dmd.dmc.DmcOmni;\n");
        out.write("import org.dmd.dmc.DmcValueException;\n");
        out.write("import org.dmd.dms.*;\n");
        out.write("import org.dmd.dms.generated.dmo.*;\n");
        out.write("import " + schema.getSchemaPackage() + ".generated.dmo." + asagName + ";\n\n");
        for (DefinitionName key : this.auxImports.keySet()) {
            out.write("import " + this.auxImports.get(key) + ";\n");
        }
        out.write("\n");
        out.write("/**\n");
        CodeFormatter.dumpCodeComment(schema.getDescription(), (BufferedWriter)out, " * ");
        out.write(" * <P>\n");
        out.write(" * Generated from the " + schema.getName() + " schema at version " + schema.getVersion() + "\n");
        out.write(" * <P>\n");
        out.write(" * This code was auto-generated by the dmggenerator utility and shouldn't be alterred manually!\n");
        out.write(" * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write(" */\n");
        out.write("public class " + schemaName + " extends SchemaDefinition {\n\n");
        out.write(staticRefs);
        out.write("    static " + schemaName + " instance;\n\n");
        out.write("    public " + schemaName + "() throws DmcValueException {\n");
        out.write("        generatedSchema = true;\n");
        out.write("        staticRefName   = \"" + genPackage + ".generated." + schemaName + "\";\n\n");
        if (hasDependency) {
            dependsOn = schema.getDependsOn();
            while (dependsOn.hasNext()) {
                dep = dependsOn.next();
                ds = sm.isSchema(dep);
                sclass = ds.getDmwPackage() + ".generated." + GeneratorUtils.dotNameToCamelCase(dep) + "SchemaAG";
                out.write("        dependsOnSchemaClasses.put(\"" + dep + "\",\"" + sclass + "\");\n");
            }
            out.write("\n");
        }
        out.write("    }\n\n");
        out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    private void initialize() throws DmcValueException {\n");
        out.write("        if (instance == null){\n");
        out.write("            instance        = this;\n");
        out.write("            SchemaDefinitionDMO me = (SchemaDefinitionDMO) this.getDmcObject();\n");
        out.write("            me.setName(\"" + schema.getName() + "\");\n");
        out.write("            me.setDotName(\"" + schema.getName() + "\");\n");
        out.write("            me.setSchemaPackage(\"" + schema.getSchemaPackage() + "\");\n");
        out.write("            me.setDmwPackage(\"" + schema.getDmwPackage() + "\");\n");
        out.write("            me.setFile(\"" + schema.getFile() + "\");\n\n");
        if (hasDependency) {
            dependsOn = schema.getDependsOn();
            out.write("\n");
            while (dependsOn.hasNext()) {
                dep = dependsOn.next();
                out.write("            me.addDependsOn(\"" + dep + "\");\n");
                ds = sm.isSchema(dep);
                sclass = ds.getDmwPackage() + ".generated." + GeneratorUtils.dotNameToCamelCase(dep) + "SchemaAG";
                out.write("            dependsOnSchemaClasses.put(\"" + dep + "\",\"" + sclass + "\");\n\n");
            }
            out.write("\n");
        }
        out.write("            initClasses();\n");
        out.write(this.getSplitFunctionNames("initAttributes", this.attributeVars));
        out.write("            initTypes();\n");
        out.write("            initComplexTypes();\n");
        out.write("            initActions();\n");
        out.write("            initEnums();\n");
        out.write("            initRules();\n");
        out.write("            initDSDModules();\n");
        out.write("            DmcOmni.instance().addCompactSchema(" + asagName + ".instance());\n");
        out.write("        }\n");
        out.write("    }\n\n");
        this.dumpInitFunction(out, "initClasses", this.classVars);
        this.dumpSplitInitFunctions(out, "initAttributes", this.attributeVars);
        this.dumpInitFunction(out, "initTypes", this.typeVars);
        this.dumpInitFunction(out, "initComplexTypes", this.complexTypeVars);
        this.dumpInitFunction(out, "initActions", this.actionVars);
        this.dumpInitFunction(out, "initEnums", this.enumVars);
        this.dumpInitFunction(out, "initRules", this.ruleVars);
        this.dumpInitFunction(out, "initDSDModules", this.dsdModuleVars);
        out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("\n");
        out.write("    @Override\n");
        out.write("    public synchronized " + schemaName + " getInstance() throws DmcValueException{\n");
        out.write("    \t   if (instance == null)\n");
        out.write("    \t\t   initialize();\n");
        out.write("    \t   return(instance);\n");
        out.write("    }\n");
        out.write("}\n\n");
        ((BufferedWriter)out).close();
    }

    String getSplitFunctionNames(String funcName, ArrayList<VarToObject> vars) {
        StringBuffer sb = new StringBuffer();
        int breakout = vars.size() / 100;
        int remainder = vars.size() % 100;
        if (remainder > 0) {
            ++breakout;
        }
        int i = 0;
        int x = 1;
        while (i < breakout) {
            sb.append("            " + funcName + x + "();\n");
            ++i;
            ++x;
        }
        return sb.toString();
    }

    void dumpInitFunction(BufferedWriter out, String funcName, ArrayList<VarToObject> vars) throws IOException {
        out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    private void " + funcName + "() throws DmcValueException {\n");
        out.write(this.getInstantiations(vars));
        out.write("    }\n\n");
    }

    void dumpSplitInitFunctions(BufferedWriter out, String funcName, ArrayList<VarToObject> vars) throws IOException {
        int breakout = vars.size() / 100;
        int remainder = vars.size() % 100;
        if (remainder > 0) {
            ++breakout;
        }
        int i = 0;
        int func = 1;
        while (i < breakout) {
            out.write("    private void " + funcName + func + "() throws DmcValueException {\n");
            int start = i * 100;
            int end = start + 100;
            if (end > vars.size()) {
                end = vars.size();
            }
            for (int j = start; j < end; ++j) {
                out.write(this.getInstantiation(vars.get(j)));
            }
            out.write("    }\n\n");
            ++i;
            ++func;
        }
    }

    String getInstantiations() {
        StringBuffer sb = new StringBuffer();
        sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        for (VarToObject var : this.allVars) {
            if (var.name.length() == 0) {
                sb.append("\n");
                continue;
            }
            this.getObjectAsCode(var, "            ", sb);
            if (var.type.equals("ClassDefinition")) {
                sb.append("            addClassDefList(" + var.name + ");\n");
            } else if (var.type.equals("AttributeDefinition")) {
                sb.append("            addAttributeDefList(" + var.name + ");\n");
            } else if (var.type.equals("EnumDefinition")) {
                sb.append("            addEnumDefList(" + var.name + ");\n");
            } else if (var.type.equals("TypeDefinition")) {
                sb.append("            addTypeDefList(" + var.name + ");\n");
            } else if (var.type.equals("ComplexTypeDefinition")) {
                sb.append("            addComplexTypeDefList(" + var.name + ");\n");
            } else if (var.type.equals("ActionDefinition")) {
                sb.append("            addActionDefList(" + var.name + ");\n");
            } else if (var.type.equals("RuleDefinition")) {
                sb.append("            addRuleDefinitionList(" + var.name + ");\n");
            } else if (var.type.equals("DSDefinitionModule")) {
                sb.append("            addDsdModuleList(" + var.name + ");\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    String getInstantiations(ArrayList<VarToObject> vars) {
        StringBuffer sb = new StringBuffer();
        for (VarToObject var : vars) {
            if (var.name.length() == 0) {
                sb.append("\n");
                continue;
            }
            this.getObjectAsCode(var, "            ", sb);
            if (var.type.equals("ClassDefinition")) {
                sb.append("            addClassDefList(" + var.name + ");\n");
            } else if (var.type.equals("AttributeDefinition")) {
                sb.append("            addAttributeDefList(" + var.name + ");\n");
            } else if (var.type.equals("EnumDefinition")) {
                sb.append("            addEnumDefList(" + var.name + ");\n");
            } else if (var.type.equals("TypeDefinition")) {
                sb.append("            addTypeDefList(" + var.name + ");\n");
            } else if (var.type.equals("ComplexTypeDefinition")) {
                sb.append("            addComplexTypeDefList(" + var.name + ");\n");
            } else if (var.type.equals("ActionDefinition")) {
                sb.append("            addActionDefList(" + var.name + ");\n");
            } else if (var.type.equals("RuleDefinition")) {
                sb.append("            addRuleDefinitionList(" + var.name + ");\n");
            } else if (var.type.equals("DSDefinitionModule")) {
                sb.append("            addDsdModuleList(" + var.name + ");\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    String getInstantiation(VarToObject var) {
        StringBuffer sb = new StringBuffer();
        if (var.name.length() == 0) {
            sb.append("\n");
        } else {
            this.getObjectAsCode(var, "            ", sb);
            if (var.type.equals("ClassDefinition")) {
                sb.append("            addClassDefList(" + var.name + ");\n");
            } else if (var.type.equals("AttributeDefinition")) {
                sb.append("            addAttributeDefList(" + var.name + ");\n");
            } else if (var.type.equals("EnumDefinition")) {
                sb.append("            addEnumDefList(" + var.name + ");\n");
            } else if (var.type.equals("TypeDefinition")) {
                sb.append("            addTypeDefList(" + var.name + ");\n");
            } else if (var.type.equals("ComplexTypeDefinition")) {
                sb.append("            addComplexTypeDefList(" + var.name + ");\n");
            } else if (var.type.equals("ActionDefinition")) {
                sb.append("            addActionDefList(" + var.name + ");\n");
            } else if (var.type.equals("RuleDefinition")) {
                sb.append("            addRuleDefinitionList(" + var.name + ");\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    String getStaticRefs(SchemaDefinition schema) {
        DSDefinitionModuleIterableDMW dsdModules;
        RuleDefinitionIterableDMW rules;
        EnumDefinitionIterableDMW enums;
        ActionDefinitionIterableDMW actions;
        ComplexTypeDefinitionIterableDMW complextypes;
        TypeDefinitionIterableDMW types;
        AttributeDefinitionIterableDMW attributes;
        StringBuffer sb = new StringBuffer();
        String asagName = GeneratorUtils.dotNameToCamelCase(schema.getName().getNameString()) + "DMSAG";
        ClassDefinitionIterableDMW classes = schema.getClassDefList();
        if (classes != null) {
            while (classes.hasNext()) {
                ClassDefinition cd = (ClassDefinition)classes.next();
                sb.append("    public static ClassDefinition _" + cd.getName() + ";\n");
                this.allVars.add(new VarToObject("_" + cd.getName(), cd, "ClassDefinition", asagName));
                this.classVars.add(new VarToObject("_" + cd.getName(), cd, "ClassDefinition", asagName));
            }
            sb.append("\n");
            this.allVars.add(new VarToObject("", null, null));
        }
        if ((attributes = schema.getAttributeDefList()) != null) {
            while (attributes.hasNext()) {
                AttributeDefinition ad = (AttributeDefinition)attributes.next();
                sb.append("    public static AttributeDefinition _" + ad.getName() + ";\n");
                this.allVars.add(new VarToObject("_" + ad.getName(), ad, "AttributeDefinition"));
                this.attributeVars.add(new VarToObject("_" + ad.getName(), ad, "AttributeDefinition"));
            }
            sb.append("\n");
            this.allVars.add(new VarToObject("", null, null));
        }
        if ((types = schema.getTypeDefList()) != null) {
            while (types.hasNext()) {
                TypeDefinition td = (TypeDefinition)types.next();
                sb.append("    public static TypeDefinition _" + td.getName() + ";\n");
                this.allVars.add(new VarToObject("_" + td.getName(), td, "TypeDefinition"));
                this.typeVars.add(new VarToObject("_" + td.getName(), td, "TypeDefinition"));
            }
            sb.append("\n");
            this.allVars.add(new VarToObject("", null, null));
        }
        if ((complextypes = schema.getComplexTypeDefList()) != null) {
            while (complextypes.hasNext()) {
                ComplexTypeDefinition td = (ComplexTypeDefinition)complextypes.next();
                sb.append("    public static ComplexTypeDefinition _" + td.getName() + ";\n");
                this.allVars.add(new VarToObject("_" + td.getName(), td, "ComplexTypeDefinition"));
                this.complexTypeVars.add(new VarToObject("_" + td.getName(), td, "ComplexTypeDefinition"));
            }
            sb.append("\n");
            this.allVars.add(new VarToObject("", null, null));
        }
        if ((actions = schema.getActionDefList()) != null) {
            while (actions.hasNext()) {
                ActionDefinition ad = (ActionDefinition)actions.next();
                sb.append("    public static ActionDefinition _" + ad.getName() + ";\n");
                this.allVars.add(new VarToObject("_" + ad.getName(), ad, "ActionDefinition"));
                this.actionVars.add(new VarToObject("_" + ad.getName(), ad, "ActionDefinition"));
            }
            sb.append("\n");
            this.allVars.add(new VarToObject("", null, null));
        }
        if ((enums = schema.getEnumDefList()) != null) {
            while (enums.hasNext()) {
                EnumDefinition ed = (EnumDefinition)enums.next();
                sb.append("    public static EnumDefinition _" + ed.getName() + ";\n");
                this.allVars.add(new VarToObject("_" + ed.getName(), ed, "EnumDefinition"));
                this.enumVars.add(new VarToObject("_" + ed.getName(), ed, "EnumDefinition"));
            }
            sb.append("\n");
            this.allVars.add(new VarToObject("", null, null));
        }
        if ((rules = schema.getRuleDefinitionList()) != null) {
            while (rules.hasNext()) {
                RuleDefinition rd = (RuleDefinition)rules.next();
                sb.append("    public static RuleDefinition _" + rd.getName() + ";\n");
                this.allVars.add(new VarToObject("_" + rd.getName(), rd, "RuleDefinition"));
                this.ruleVars.add(new VarToObject("_" + rd.getName(), rd, "RuleDefinition"));
            }
            sb.append("\n");
            this.allVars.add(new VarToObject("", null, null));
        }
        if ((dsdModules = schema.getDsdModuleList()) != null) {
            while (dsdModules.hasNext()) {
                DSDefinitionModule dsdm = (DSDefinitionModule)dsdModules.next();
                sb.append("    public static DSDefinitionModule _" + dsdm.getName() + "DSD;\n");
                this.allVars.add(new VarToObject("_" + dsdm.getName() + "DSD", dsdm, "DSDefinitionModule"));
                this.dsdModuleVars.add(new VarToObject("_" + dsdm.getName() + "DSD", dsdm, "DSDefinitionModule"));
            }
            sb.append("\n");
            this.allVars.add(new VarToObject("", null, null));
        }
        return sb.toString();
    }

    void getObjectAsCode(VarToObject var, String indent, StringBuffer sb) {
        String obj = var.name + "OBJ";
        sb.append("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append(indent + var.type + "DMO " + var.name + "OBJ = new " + var.type + "DMO();\n");
        if (var.dmsagClassRef == null) {
            sb.append(indent + var.name + " = new " + var.type + "(" + var.name + "OBJ);\n");
        } else {
            sb.append(indent + var.name + " = new " + var.type + "(" + var.name + "OBJ," + var.dmsagClassRef + ");\n");
        }
        for (DmcAttribute<?> attr : var.def.getDmcObject().getAttributes().values()) {
            String value;
            String an = GeneratorUtils.dotNameToCamelCase(attr.getName());
            String prefix = "";
            if (this.skip.get(attr.getName()) != null) continue;
            DotName dn = null;
            try {
                dn = new DotName(attr.getAttributeInfo().qualifiedName + ".AttributeDefinition");
            }
            catch (DmcValueException e) {
                e.printStackTrace();
            }
            AttributeDefinition ad = this.schemaManager.attributeDefinitions.getDefinition(dn);
            ClassDefinition aux = this.isAuxAttribute(var.def, ad);
            TypeDefinition td = ad.getType();
            if (aux == null) {
                DmcNamedObjectREF ref;
                if (attr.getMVSize() > 0) {
                    Iterator<?> vals = attr.getMV();
                    while (vals.hasNext()) {
                        DmcNamedObjectREF ref2;
                        prefix = "";
                        Object val = vals.next();
                        if (td.getIsRefType().booleanValue() && (ref2 = (DmcNamedObjectREF)val).getObject() instanceof DmsDefinitionDMO && !(ref2.getObject() instanceof SchemaDefinitionDMO)) {
                            DmsDefinitionDMO def = (DmsDefinitionDMO)ref2.getObject();
                            if (!val.toString().contains(".")) {
                                prefix = def.getDefinedIn().getObjectName().getNameString() + ".";
                            }
                        }
                        String value2 = val.toString();
                        if (an.equals("Description") && value2.length() > 500) {
                            DebugInfo.debug("Truncating description: " + value2.length());
                            value2 = "Way too long!";
                        }
                        if (value2.indexOf("\"") != -1) {
                            value2 = value2.replaceAll("\"", "\\\\\"");
                        }
                        sb.append(indent + obj + ".add" + an + "(\"" + prefix + value2 + "\");\n");
                    }
                    continue;
                }
                prefix = "";
                if (td.getIsRefType().booleanValue() && (ref = (DmcNamedObjectREF)attr.getSV()).getObject() instanceof DmsDefinitionDMO && !(ref.getObject() instanceof SchemaDefinitionDMO)) {
                    DmsDefinitionDMO def = (DmsDefinitionDMO)ref.getObject();
                    if (!attr.getSV().toString().contains(".")) {
                        prefix = def.getDefinedIn().getObjectName().getNameString() + ".";
                    }
                }
                boolean doubleQuotes = false;
                if (attr.getName().equals("nullReturnValue") && attr.getSV().toString().startsWith("\"")) {
                    doubleQuotes = true;
                }
                if (attr.getName().equals(MetaDMSAG.__definedIn.name)) {
                    sb.append(indent + var.name + ".set" + an + "(this);\n");
                    continue;
                }
                if (doubleQuotes) {
                    sb.append(indent + obj + ".set" + an + "(" + attr.getSV().toString() + ");\n");
                    continue;
                }
                value = attr.getSV().toString();
                if (value.indexOf("\"") != -1) {
                    value = value.replaceAll("\"", "\\\"");
                }
                sb.append(indent + obj + ".set" + an + "(\"" + prefix + value + "\");\n");
                continue;
            }
            if (attr.getSV() == null) {
                Iterator<?> vals = attr.getMV();
                while (vals.hasNext()) {
                    sb.append(indent + aux.getDmwAuxClass() + ".add" + an + "(" + var.name + ", \"" + vals.next().toString() + "\");\n");
                }
                continue;
            }
            boolean doubleQuotes = false;
            if (attr.getName().equals("nullReturnValue") && attr.getSV().toString().startsWith("\"")) {
                doubleQuotes = true;
            }
            if (doubleQuotes) {
                sb.append(indent + aux.getDmwAuxClass() + ".set" + an + "(" + var.name + ", " + attr.getSV().toString() + ");\n");
                continue;
            }
            value = attr.getSV().toString();
            if (value.indexOf("\"") != -1) {
                value = value.replaceAll("\"", "\\\"");
            }
            sb.append(indent + aux.getDmwAuxClass() + ".set" + an + "(" + var.name + ", \"" + value + "\");\n");
        }
    }

    ClassDefinition isAuxAttribute(DmsDefinition def, AttributeDefinition ad) {
        ClassDefinitionDMW rc = null;
        ClassDefinitionIterableDMW oc = def.getObjectClass();
        if (oc == null) {
            DebugInfo.debug("No class info for " + def.getName());
            DebugInfo.debug(def.toOIF(15));
        }
        while (oc.hasNext()) {
            ClassDefinition cd = (ClassDefinition)oc.next();
            if (cd.hasAttribute(ad.getName()) == null) continue;
            rc = cd;
            break;
        }
        if (rc != null && rc.getClassType() == ClassTypeEnum.AUXILIARY) {
            this.auxImports.put(rc.getName(), rc.getDmwAuxClassImport());
        } else {
            rc = null;
        }
        return rc;
    }

    class VarToObject {
        String name;
        DmsDefinition def;
        String type;
        String dmsagClassRef;

        VarToObject(String vn, DmsDefinition d, String vt) {
            this.name = vn;
            this.def = d;
            this.type = vt;
            this.dmsagClassRef = null;
        }

        VarToObject(String vn, DmsDefinition d, String vt, String schema) {
            this.name = vn;
            this.def = d;
            this.type = vt;
            this.dmsagClassRef = schema + "._" + vn;
        }
    }
}

