/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.server.extended;

import java.util.Iterator;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcNamedObjectIF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcObjectName;
import org.dmd.dmc.DmcOmni;
import org.dmd.dmc.DmcSliceInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.Modifier;
import org.dmd.dmp.server.extended.SetRequest;
import org.dmd.dmp.server.generated.dmw.DMPEventDMW;
import org.dmd.dmp.shared.generated.dmo.DMPEventDMO;
import org.dmd.dmp.shared.generated.enums.DMPEventTypeEnum;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.generated.dmo.MetaDMSAG;
import org.dmd.dms.generated.enums.DataTypeEnum;
import org.dmd.dms.generated.enums.ModifyTypeEnum;
import org.dmd.dms.generated.types.DmcTypeModifierMV;
import org.dmd.dmw.DmwOmni;
import org.dmd.dmw.DmwWrapper;

public class DMPEvent
extends DMPEventDMW {
    public DMPEvent() {
    }

    public DMPEvent(DMPEventDMO obj) {
        super(obj);
    }

    public DMPEvent(DMPEventTypeEnum et, DmwWrapper w) {
        DmcObjectName on;
        this.setEventTypeDMP(et);
        this.setSourceObjectClass(w.getConstructionClass());
        if (w instanceof DmcNamedObjectIF && (on = ((DmcNamedObjectIF)((Object)w)).getObjectName()) != null) {
            this.setSource(on);
        }
        if (et == DMPEventTypeEnum.CREATED) {
            this.setSourceObject(w.getDmcObject());
        } else if (et == DMPEventTypeEnum.LOADED) {
            this.setSourceObject(w.getDmcObject());
        } else if (et == DMPEventTypeEnum.DELETED) {
            if (w instanceof DmcNamedObjectIF && (on = ((DmcNamedObjectIF)((Object)w)).getObjectName()) != null) {
                this.setSource(on);
            }
        } else if (et == DMPEventTypeEnum.MODIFIED) {
            if (w.getModifier() == null) {
                throw new IllegalStateException("Tried to create a MODIFIED event for an object with no modifications.");
            }
            if (w.getModifier().getMVSize() > 0) {
                this.setModify(w.getModifier());
            }
        }
    }

    public DMPEvent clone() {
        return new DMPEvent((DMPEventDMO)this.getDMO().shallowCopy());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasPersistentData() {
        boolean rc = false;
        if (this.getSourceObjectClass() == null) {
            throw new IllegalStateException("Malformed DMPEvent. Missing source object class for a " + this.getEventTypeDMP() + " event.");
        }
        if (this.getSourceObjectClass().getDataType() != DataTypeEnum.PERSISTENT) {
            return rc;
        }
        if (this.getEventTypeDMP() == DMPEventTypeEnum.CREATED || this.getEventTypeDMP() == DMPEventTypeEnum.LOADED) {
            DmcAttribute<?> attr;
            if (this.getSourceObject() == null) {
                throw new IllegalStateException("Malformed DMPEvent. Missing source object for a CREATE event.");
            }
            Iterator<DmcAttribute<?>> iterator = this.getSourceObject().getAttributes().values().iterator();
            do {
                if (!iterator.hasNext()) return rc;
            } while ((attr = iterator.next()).getID() == DmcObject.__objectClass.id || attr.getAttributeInfo().dataType != DataTypeEnum.PERSISTENT);
            return true;
        }
        if (this.getEventTypeDMP() == DMPEventTypeEnum.DELETED) {
            return true;
        }
        if (this.getEventTypeDMP() != DMPEventTypeEnum.MODIFIED) return rc;
        if (this.getModifyAttribute() == null) {
            throw new IllegalStateException("Malformed DMPEvent. Missing modify attribute for a MODIFIED event.");
        }
        Iterator<Modifier> modifiers = this.getModifyAttribute().getMV();
        if (modifiers == null) return rc;
        while (modifiers.hasNext()) {
            Modifier mod = modifiers.next();
            if (mod.getAttribute() == null) {
                AttributeDefinition ad;
                if (mod.getModifyType() == ModifyTypeEnum.REM) {
                    ad = DmwOmni.instance().getSchema().adef(mod.getAttributeName());
                    if (ad == null) {
                        throw new IllegalStateException("Malformed DMPEvent. Could not get definition for attribute: " + mod.getAttributeName());
                    }
                    if (ad.getDataType() != DataTypeEnum.PERSISTENT) continue;
                    return true;
                }
                if (mod.getModifyType() != ModifyTypeEnum.NTH) throw new IllegalStateException("Malformed DMPEvent. Missing attribute for a Modifier: " + mod.toString());
                ad = DmwOmni.instance().getSchema().adef(mod.getAttributeName());
                if (ad == null) {
                    throw new IllegalStateException("Malformed DMPEvent. Could not get definition for attribute: " + mod.getAttributeName());
                }
                if (ad.getDataType() != DataTypeEnum.PERSISTENT) continue;
                return true;
            }
            if (mod.getAttribute().getAttributeInfo().dataType == DataTypeEnum.PERSISTENT) return true;
        }
        return rc;
    }

    public DMPEvent getPersistentForm() {
        DMPEvent rc = null;
        if (this.getSourceObjectClass() == null) {
            throw new IllegalStateException("Malformed DMPEvent. Missing source object class for a " + this.getEventTypeDMP() + " event.");
        }
        if (this.getSourceObjectClass().getDataType() != DataTypeEnum.PERSISTENT) {
            return rc;
        }
        try {
            if (this.getEventTypeDMP() == DMPEventTypeEnum.CREATED || this.getEventTypeDMP() == DMPEventTypeEnum.LOADED) {
                if (this.getSourceObject() == null) {
                    throw new IllegalStateException("Malformed DMPEvent. Missing source object for a CREATE event.");
                }
                DmcObject clonedSourceObj = this.getSourceObject().getNew();
                int nonPersistentCount = 0;
                for (DmcAttribute<?> attr : this.getSourceObject().getAttributes().values()) {
                    if (attr.getID() == DmcObject.__objectClass.id) continue;
                    if (attr.getAttributeInfo().dataType == DataTypeEnum.PERSISTENT) {
                        clonedSourceObj.add(attr.getAttributeInfo(), attr.cloneIt());
                        continue;
                    }
                    ++nonPersistentCount;
                }
                if (nonPersistentCount > 0) {
                    rc = this.clone();
                    rc.remSourceObject();
                    rc.setSourceObject(clonedSourceObj);
                } else {
                    rc = this;
                }
            } else if (this.getEventTypeDMP() == DMPEventTypeEnum.DELETED) {
                rc = this;
            } else if (this.getEventTypeDMP() == DMPEventTypeEnum.MODIFIED) {
                if (this.getModifyAttribute() == null) {
                    throw new IllegalStateException("Malformed DMPEvent. Missing modify attribute for a MODIFIED event.");
                }
                DmcTypeModifierMV newModifier = new DmcTypeModifierMV(MetaDMSAG.__modify);
                Iterator<Modifier> modifiers = this.getModifyAttribute().getMV();
                if (modifiers != null) {
                    while (modifiers.hasNext()) {
                        Modifier mod = modifiers.next();
                        DmcAttributeInfo ai = mod.getAttributeInfo();
                        if (ai == null) {
                            throw new IllegalStateException("Unknown attribute in modify: " + mod.getAttributeName());
                        }
                        if (ai.dataType != DataTypeEnum.PERSISTENT) continue;
                        newModifier.add(new Modifier(mod));
                    }
                    if (newModifier.getMVSize() > 0) {
                        rc = this.clone();
                        rc.remModify();
                        rc.getDMO().add(MetaDMSAG.__modify, newModifier);
                    }
                }
            }
        }
        catch (DmcValueException ex) {
            throw new IllegalStateException("Shouldn't have value exceptions for attribute: " + ex.getAttributeName() + "\n" + ex.toString());
        }
        return rc;
    }

    public DMPEvent(SetRequest request) {
        this.setEventTypeDMP(DMPEventTypeEnum.MODIFIED);
        this.setSource(request.getTarget());
        if (request.getTargetObjectClass() != null) {
            this.setSourceObjectClass(request.getTargetObjectClass());
        }
        if (request.getModifyAttribute() == null) {
            throw new IllegalStateException("Tried to create a MODIFIED event from a SetRequest with no modifications.");
        }
        this.setModify(request.getModifyAttribute());
    }

    @Override
    public DmcTypeModifierMV getModifier() {
        throw new IllegalStateException("It makes no sense to retrieve the modifier from an event - you probably meant getModify().");
    }

    public DmcObjectName getSourceName() {
        if (this.getSource() == null) {
            return null;
        }
        return this.getSource().getName();
    }

    public void setModify(DmcTypeModifierMV mods) {
        try {
            this.getDmcObject().add(MetaDMSAG.__modify, mods);
        }
        catch (DmcValueException e) {
            throw new IllegalStateException("Setting the modify attribute directly with a DmcTypeModifierMV shouldn't thrown an exception.", e);
        }
    }

    public DmcTypeModifierMV getModifyAttribute() {
        return (DmcTypeModifierMV)this.getDmcObject().get(MetaDMSAG.__modify);
    }

    public DmwWrapper getSourceObjectWrapped() throws DmcNameClashException, DmcValueException {
        if (this.getSourceObject() == null) {
            return null;
        }
        return DmwOmni.instance().wrapIt(this.getSourceObject());
    }

    public DmcSliceInfo getSliceInfo() {
        if (this.getSlice() == null) {
            return null;
        }
        return DmcOmni.instance().getSliceInfo(this.getSlice());
    }

    public DMPEvent getSlice(DmcSliceInfo dsi) {
        DMPEvent rc = null;
        if (this.getEventTypeDMP() == DMPEventTypeEnum.MODIFIED) {
            DmcTypeModifierMV source = this.getModifyAttribute();
            DmcTypeModifierMV sliced = this.getModifierSlice(dsi, source);
            if (sliced != null) {
                rc = new DMPEvent((DMPEventDMO)this.getDMO().shallowCopy());
                rc.setSlice(dsi.getName());
                rc.remModify();
                try {
                    rc.getDMO().set(MetaDMSAG.__modify, sliced);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("Dropping the sliced modifier in our shallow copy shouldn't throw an exception!");
                }
            }
        } else if (this.getEventTypeDMP() == DMPEventTypeEnum.CREATED || this.getEventTypeDMP() == DMPEventTypeEnum.LOADED) {
            DmcObject sliced = this.getSourceObject().getSlice(dsi);
            rc = new DMPEvent((DMPEventDMO)this.getDMO().shallowCopy());
            rc.setSlice(dsi.getName());
            rc.remSourceObject();
            rc.setSourceObject(sliced);
        } else if (this.getEventTypeDMP() == DMPEventTypeEnum.DELETED) {
            rc = new DMPEvent((DMPEventDMO)this.getDMO().shallowCopy());
            rc.setSlice(dsi.getName());
        }
        return rc;
    }

    DmcTypeModifierMV getModifierSlice(DmcSliceInfo slice, DmcTypeModifierMV source) {
        DmcTypeModifierMV rc = new DmcTypeModifierMV();
        Iterator<Modifier> mods = source.getMV();
        while (mods.hasNext()) {
            Modifier mod = mods.next();
            if (!slice.contains(mod.getAttributeID())) continue;
            try {
                rc.add(mod);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Should not throw an exception adding a Modifier to a DmcTypeModifier");
            }
        }
        if (rc.getMVSize() == 0) {
            rc = null;
        }
        return rc;
    }

    public boolean thisAttributeModified(DmcAttributeInfo ai) {
        DmcTypeModifierMV mods;
        if (this.getEventTypeDMP() == DMPEventTypeEnum.MODIFIED && (mods = this.getModifyAttribute()) != null) {
            for (int i = 0; i < mods.getMVSize(); ++i) {
                Modifier mod = mods.getMVnth(i);
                DmcAttributeInfo modai = mod.getAttributeInfo();
                if (modai == null) {
                    throw new IllegalStateException("Couldn't get attribute info for: " + mod.getAttributeName());
                }
                if (modai.id != ai.id) continue;
                return true;
            }
        }
        return false;
    }
}

