/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.shared.generated.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.dmd.dmc.DmcEnumIF;

public enum DMPEventTypeEnum implements DmcEnumIF
{
    CREATED(0, "Indicates that an object was created."),
    DELETED(1, "Indicates that an object was deleted."),
    MODIFIED(2, "Indicates that an object was modified."),
    LOADED(3, "Indicates that an object has been loaded in the cache.");

    private static final Map<Integer, DMPEventTypeEnum> lookup;
    private static final Map<String, DMPEventTypeEnum> lookupString;
    private int ival;
    private String dval;

    private DMPEventTypeEnum(int i, String d) {
        this.ival = i;
        this.dval = d;
    }

    public int intValue() {
        return this.ival;
    }

    @Override
    public String displayValue() {
        return this.dval;
    }

    public static DMPEventTypeEnum get(int code) {
        return lookup.get(code);
    }

    public static DMPEventTypeEnum get(String str) {
        return lookupString.get(str.toUpperCase());
    }

    static {
        lookup = new HashMap<Integer, DMPEventTypeEnum>();
        for (DMPEventTypeEnum s : EnumSet.allOf(DMPEventTypeEnum.class)) {
            lookup.put(s.intValue(), s);
        }
        lookupString = new HashMap<String, DMPEventTypeEnum>();
        for (DMPEventTypeEnum s : EnumSet.allOf(DMPEventTypeEnum.class)) {
            lookupString.put(s.name(), s);
        }
    }
}

