/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.shared.generated.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.dmd.dmc.DmcEnumIF;

public enum ResponseCategoryEnum implements DmcEnumIF
{
    UNKNOWN(0, "An uncategorized response."),
    SOFTWARE(1, "A response related to software."),
    SECURITY(2, "A response related to security."),
    REPOSITORY(3, "A response related to the repository."),
    COMMS(4, "A response related to communication."),
    OPERATIONAL(5, "A response related to an operation.");

    private static final Map<Integer, ResponseCategoryEnum> lookup;
    private static final Map<String, ResponseCategoryEnum> lookupString;
    private int ival;
    private String dval;

    private ResponseCategoryEnum(int i, String d) {
        this.ival = i;
        this.dval = d;
    }

    public int intValue() {
        return this.ival;
    }

    @Override
    public String displayValue() {
        return this.dval;
    }

    public static ResponseCategoryEnum get(int code) {
        return lookup.get(code);
    }

    public static ResponseCategoryEnum get(String str) {
        return lookupString.get(str.toUpperCase());
    }

    static {
        lookup = new HashMap<Integer, ResponseCategoryEnum>();
        for (ResponseCategoryEnum s : EnumSet.allOf(ResponseCategoryEnum.class)) {
            lookup.put(s.intValue(), s);
        }
        lookupString = new HashMap<String, ResponseCategoryEnum>();
        for (ResponseCategoryEnum s : EnumSet.allOf(ResponseCategoryEnum.class)) {
            lookupString.put(s.name(), s);
        }
    }
}

