/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.shared.generated.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.dmd.dmc.DmcEnumIF;

public enum ResponseFormatEnum implements DmcEnumIF
{
    STANDARD(0, "Indicates that the responses should be in standard flat format."),
    DOM(1, "Indicates that the response should be in DOM format i.e. the hierarchic structure of the data should be reflected by indenting children in subarrays beneath an object.");

    private static final Map<Integer, ResponseFormatEnum> lookup;
    private static final Map<String, ResponseFormatEnum> lookupString;
    private int ival;
    private String dval;

    private ResponseFormatEnum(int i, String d) {
        this.ival = i;
        this.dval = d;
    }

    public int intValue() {
        return this.ival;
    }

    @Override
    public String displayValue() {
        return this.dval;
    }

    public static ResponseFormatEnum get(int code) {
        return lookup.get(code);
    }

    public static ResponseFormatEnum get(String str) {
        return lookupString.get(str.toUpperCase());
    }

    static {
        lookup = new HashMap<Integer, ResponseFormatEnum>();
        for (ResponseFormatEnum s : EnumSet.allOf(ResponseFormatEnum.class)) {
            lookup.put(s.intValue(), s);
        }
        lookupString = new HashMap<String, ResponseFormatEnum>();
        for (ResponseFormatEnum s : EnumSet.allOf(ResponseFormatEnum.class)) {
            lookupString.put(s.name(), s);
        }
    }
}

