/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.shared.generated.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.dmd.dmc.DmcEnumIF;

public enum ResponseTypeEnum implements DmcEnumIF
{
    UNKNOWN(0, "An unknown type of response; shouldn't happen."),
    SUCCESS(1, "Indicates that the request was successful."),
    WARNING(2, "Indicates that the request was sucessful but that there were warnings generated and that there is some descriptive text that indicates what happened."),
    ERROR(3, "Indicates that the request failed and that there is some descriptive text that indicates what happened."),
    PROGRESSTEXT(4, "Indicates that the request is proceeding and that this is a textual update on the progress of the request."),
    PROGRESSPERCENT(5, "Indicates that the request is proceeding and that this is the percentage of the processing that's complete."),
    HEARTBEAT(6, "Indicates that an action is still in progress."),
    CANCELLED(7, "Indicates that an operation has been cancelled; generally used when an action is cancelled."),
    PROGRESSOBJECTS(8, "Indicates that the objectList will contain application specific objects that indicate some sort of progress.");

    private static final Map<Integer, ResponseTypeEnum> lookup;
    private static final Map<String, ResponseTypeEnum> lookupString;
    private int ival;
    private String dval;

    private ResponseTypeEnum(int i, String d) {
        this.ival = i;
        this.dval = d;
    }

    public int intValue() {
        return this.ival;
    }

    @Override
    public String displayValue() {
        return this.dval;
    }

    public static ResponseTypeEnum get(int code) {
        return lookup.get(code);
    }

    public static ResponseTypeEnum get(String str) {
        return lookupString.get(str.toUpperCase());
    }

    static {
        lookup = new HashMap<Integer, ResponseTypeEnum>();
        for (ResponseTypeEnum s : EnumSet.allOf(ResponseTypeEnum.class)) {
            lookup.put(s.intValue(), s);
        }
        lookupString = new HashMap<String, ResponseTypeEnum>();
        for (ResponseTypeEnum s : EnumSet.allOf(ResponseTypeEnum.class)) {
            lookupString.put(s.name(), s);
        }
    }
}

