/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.shared.generated.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.dmd.dmc.DmcEnumIF;

public enum ScopeEnum implements DmcEnumIF
{
    NONE(0, "Indicates that no value has been set."),
    BASE(1, "Applies the operation only to the object named in the request."),
    NEXT(2, "Applies the operation to the children, or next layer, of objects below the target object."),
    ALL(3, "Applies the operation to the entire sub-tree of objects beneath the target object.");

    private static final Map<Integer, ScopeEnum> lookup;
    private static final Map<String, ScopeEnum> lookupString;
    private int ival;
    private String dval;

    private ScopeEnum(int i, String d) {
        this.ival = i;
        this.dval = d;
    }

    public int intValue() {
        return this.ival;
    }

    @Override
    public String displayValue() {
        return this.dval;
    }

    public static ScopeEnum get(int code) {
        return lookup.get(code);
    }

    public static ScopeEnum get(String str) {
        return lookupString.get(str.toUpperCase());
    }

    static {
        lookup = new HashMap<Integer, ScopeEnum>();
        for (ScopeEnum s : EnumSet.allOf(ScopeEnum.class)) {
            lookup.put(s.intValue(), s);
        }
        lookupString = new HashMap<String, ScopeEnum>();
        for (ScopeEnum s : EnumSet.allOf(ScopeEnum.class)) {
            lookupString.put(s.name(), s);
        }
    }
}

