/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmp.shared.generated.dmo.ActionResponseDMO;
import org.dmd.dmp.shared.generated.types.DmcTypeActionResponseREF;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeActionResponseREFSET
extends DmcTypeActionResponseREF
implements Serializable {
    private static final Iterator<ActionResponseDMO> emptyList = new HashSet().iterator();
    protected Set<ActionResponseDMO> value;

    public DmcTypeActionResponseREFSET() {
        this.value = null;
    }

    public DmcTypeActionResponseREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<ActionResponseDMO>() : new TreeSet<ActionResponseDMO>();
    }

    public DmcTypeActionResponseREFSET getNew() {
        return new DmcTypeActionResponseREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<ActionResponseDMO> cloneIt() {
        DmcTypeActionResponseREFSET dmcTypeActionResponseREFSET = this;
        synchronized (dmcTypeActionResponseREFSET) {
            DmcTypeActionResponseREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ActionResponseDMO val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionResponseDMO add(Object v) throws DmcValueException {
        DmcTypeActionResponseREFSET dmcTypeActionResponseREFSET = this;
        synchronized (dmcTypeActionResponseREFSET) {
            ActionResponseDMO rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionResponseDMO del(Object v) {
        DmcTypeActionResponseREFSET dmcTypeActionResponseREFSET = this;
        synchronized (dmcTypeActionResponseREFSET) {
            ActionResponseDMO rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ActionResponseDMO> getMV() {
        DmcTypeActionResponseREFSET dmcTypeActionResponseREFSET = this;
        synchronized (dmcTypeActionResponseREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<ActionResponseDMO>(this.value).iterator();
            }
            return new TreeSet<ActionResponseDMO>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ActionResponseDMO> getMVCopy() {
        DmcTypeActionResponseREFSET dmcTypeActionResponseREFSET = this;
        synchronized (dmcTypeActionResponseREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<ActionResponseDMO>();
                }
                return new HashSet<ActionResponseDMO>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<ActionResponseDMO>(this.value);
            }
            return new TreeSet<ActionResponseDMO>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeActionResponseREFSET dmcTypeActionResponseREFSET = this;
        synchronized (dmcTypeActionResponseREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeActionResponseREFSET dmcTypeActionResponseREFSET = this;
        synchronized (dmcTypeActionResponseREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                ActionResponseDMO val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

