/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmp.shared.generated.dmo.DMPEventDMO;
import org.dmd.dmp.shared.generated.types.DmcTypeDMPEventREF;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeDMPEventREFSET
extends DmcTypeDMPEventREF
implements Serializable {
    private static final Iterator<DMPEventDMO> emptyList = new HashSet().iterator();
    protected Set<DMPEventDMO> value;

    public DmcTypeDMPEventREFSET() {
        this.value = null;
    }

    public DmcTypeDMPEventREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<DMPEventDMO>() : new TreeSet<DMPEventDMO>();
    }

    public DmcTypeDMPEventREFSET getNew() {
        return new DmcTypeDMPEventREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<DMPEventDMO> cloneIt() {
        DmcTypeDMPEventREFSET dmcTypeDMPEventREFSET = this;
        synchronized (dmcTypeDMPEventREFSET) {
            DmcTypeDMPEventREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (DMPEventDMO val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DMPEventDMO add(Object v) throws DmcValueException {
        DmcTypeDMPEventREFSET dmcTypeDMPEventREFSET = this;
        synchronized (dmcTypeDMPEventREFSET) {
            DMPEventDMO rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DMPEventDMO del(Object v) {
        DmcTypeDMPEventREFSET dmcTypeDMPEventREFSET = this;
        synchronized (dmcTypeDMPEventREFSET) {
            DMPEventDMO rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<DMPEventDMO> getMV() {
        DmcTypeDMPEventREFSET dmcTypeDMPEventREFSET = this;
        synchronized (dmcTypeDMPEventREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<DMPEventDMO>(this.value).iterator();
            }
            return new TreeSet<DMPEventDMO>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DMPEventDMO> getMVCopy() {
        DmcTypeDMPEventREFSET dmcTypeDMPEventREFSET = this;
        synchronized (dmcTypeDMPEventREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<DMPEventDMO>();
                }
                return new HashSet<DMPEventDMO>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<DMPEventDMO>(this.value);
            }
            return new TreeSet<DMPEventDMO>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeDMPEventREFSET dmcTypeDMPEventREFSET = this;
        synchronized (dmcTypeDMPEventREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeDMPEventREFSET dmcTypeDMPEventREFSET = this;
        synchronized (dmcTypeDMPEventREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                DMPEventDMO val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

