/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmp.shared.generated.enums.DMPEventTypeEnum;
import org.dmd.dmp.shared.generated.types.DmcTypeDMPEventTypeEnum;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeDMPEventTypeEnumSET
extends DmcTypeDMPEventTypeEnum
implements Serializable {
    private static final Iterator<DMPEventTypeEnum> emptyList = new HashSet().iterator();
    protected Set<DMPEventTypeEnum> value;

    public DmcTypeDMPEventTypeEnumSET() {
        this.value = null;
    }

    public DmcTypeDMPEventTypeEnumSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<DMPEventTypeEnum>() : new TreeSet<DMPEventTypeEnum>();
    }

    public DmcTypeDMPEventTypeEnumSET getNew() {
        return new DmcTypeDMPEventTypeEnumSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<DMPEventTypeEnum> cloneIt() {
        DmcTypeDMPEventTypeEnumSET dmcTypeDMPEventTypeEnumSET = this;
        synchronized (dmcTypeDMPEventTypeEnumSET) {
            DmcTypeDMPEventTypeEnumSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (DMPEventTypeEnum val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DMPEventTypeEnum add(Object v) throws DmcValueException {
        DmcTypeDMPEventTypeEnumSET dmcTypeDMPEventTypeEnumSET = this;
        synchronized (dmcTypeDMPEventTypeEnumSET) {
            DMPEventTypeEnum rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DMPEventTypeEnum del(Object v) {
        DmcTypeDMPEventTypeEnumSET dmcTypeDMPEventTypeEnumSET = this;
        synchronized (dmcTypeDMPEventTypeEnumSET) {
            DMPEventTypeEnum rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<DMPEventTypeEnum> getMV() {
        DmcTypeDMPEventTypeEnumSET dmcTypeDMPEventTypeEnumSET = this;
        synchronized (dmcTypeDMPEventTypeEnumSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<DMPEventTypeEnum>(this.value).iterator();
            }
            return new TreeSet<DMPEventTypeEnum>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DMPEventTypeEnum> getMVCopy() {
        DmcTypeDMPEventTypeEnumSET dmcTypeDMPEventTypeEnumSET = this;
        synchronized (dmcTypeDMPEventTypeEnumSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<DMPEventTypeEnum>();
                }
                return new HashSet<DMPEventTypeEnum>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<DMPEventTypeEnum>(this.value);
            }
            return new TreeSet<DMPEventTypeEnum>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeDMPEventTypeEnumSET dmcTypeDMPEventTypeEnumSET = this;
        synchronized (dmcTypeDMPEventTypeEnumSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeDMPEventTypeEnumSET dmcTypeDMPEventTypeEnumSET = this;
        synchronized (dmcTypeDMPEventTypeEnumSET) {
            if (this.value == null) {
                return false;
            }
            try {
                DMPEventTypeEnum val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

