/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmp.shared.generated.dmo.NotifyResponseDMO;
import org.dmd.dmp.shared.generated.types.DmcTypeNotifyResponseREF;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeNotifyResponseREFSET
extends DmcTypeNotifyResponseREF
implements Serializable {
    private static final Iterator<NotifyResponseDMO> emptyList = new HashSet().iterator();
    protected Set<NotifyResponseDMO> value;

    public DmcTypeNotifyResponseREFSET() {
        this.value = null;
    }

    public DmcTypeNotifyResponseREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<NotifyResponseDMO>() : new TreeSet<NotifyResponseDMO>();
    }

    public DmcTypeNotifyResponseREFSET getNew() {
        return new DmcTypeNotifyResponseREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<NotifyResponseDMO> cloneIt() {
        DmcTypeNotifyResponseREFSET dmcTypeNotifyResponseREFSET = this;
        synchronized (dmcTypeNotifyResponseREFSET) {
            DmcTypeNotifyResponseREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (NotifyResponseDMO val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotifyResponseDMO add(Object v) throws DmcValueException {
        DmcTypeNotifyResponseREFSET dmcTypeNotifyResponseREFSET = this;
        synchronized (dmcTypeNotifyResponseREFSET) {
            NotifyResponseDMO rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotifyResponseDMO del(Object v) {
        DmcTypeNotifyResponseREFSET dmcTypeNotifyResponseREFSET = this;
        synchronized (dmcTypeNotifyResponseREFSET) {
            NotifyResponseDMO rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<NotifyResponseDMO> getMV() {
        DmcTypeNotifyResponseREFSET dmcTypeNotifyResponseREFSET = this;
        synchronized (dmcTypeNotifyResponseREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<NotifyResponseDMO>(this.value).iterator();
            }
            return new TreeSet<NotifyResponseDMO>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NotifyResponseDMO> getMVCopy() {
        DmcTypeNotifyResponseREFSET dmcTypeNotifyResponseREFSET = this;
        synchronized (dmcTypeNotifyResponseREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<NotifyResponseDMO>();
                }
                return new HashSet<NotifyResponseDMO>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<NotifyResponseDMO>(this.value);
            }
            return new TreeSet<NotifyResponseDMO>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeNotifyResponseREFSET dmcTypeNotifyResponseREFSET = this;
        synchronized (dmcTypeNotifyResponseREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeNotifyResponseREFSET dmcTypeNotifyResponseREFSET = this;
        synchronized (dmcTypeNotifyResponseREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                NotifyResponseDMO val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

