/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmp.shared.generated.dmo.ResponseDMO;
import org.dmd.dmp.shared.generated.types.DmcTypeResponseREF;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeResponseREFSET
extends DmcTypeResponseREF
implements Serializable {
    private static final Iterator<ResponseDMO> emptyList = new HashSet().iterator();
    protected Set<ResponseDMO> value;

    public DmcTypeResponseREFSET() {
        this.value = null;
    }

    public DmcTypeResponseREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<ResponseDMO>() : new TreeSet<ResponseDMO>();
    }

    public DmcTypeResponseREFSET getNew() {
        return new DmcTypeResponseREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<ResponseDMO> cloneIt() {
        DmcTypeResponseREFSET dmcTypeResponseREFSET = this;
        synchronized (dmcTypeResponseREFSET) {
            DmcTypeResponseREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ResponseDMO val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseDMO add(Object v) throws DmcValueException {
        DmcTypeResponseREFSET dmcTypeResponseREFSET = this;
        synchronized (dmcTypeResponseREFSET) {
            ResponseDMO rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseDMO del(Object v) {
        DmcTypeResponseREFSET dmcTypeResponseREFSET = this;
        synchronized (dmcTypeResponseREFSET) {
            ResponseDMO rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ResponseDMO> getMV() {
        DmcTypeResponseREFSET dmcTypeResponseREFSET = this;
        synchronized (dmcTypeResponseREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<ResponseDMO>(this.value).iterator();
            }
            return new TreeSet<ResponseDMO>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ResponseDMO> getMVCopy() {
        DmcTypeResponseREFSET dmcTypeResponseREFSET = this;
        synchronized (dmcTypeResponseREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<ResponseDMO>();
                }
                return new HashSet<ResponseDMO>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<ResponseDMO>(this.value);
            }
            return new TreeSet<ResponseDMO>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeResponseREFSET dmcTypeResponseREFSET = this;
        synchronized (dmcTypeResponseREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeResponseREFSET dmcTypeResponseREFSET = this;
        synchronized (dmcTypeResponseREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                ResponseDMO val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

