/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmp.shared.generated.enums.ResponseTypeEnum;
import org.dmd.dmp.shared.generated.types.DmcTypeResponseTypeEnum;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeResponseTypeEnumSET
extends DmcTypeResponseTypeEnum
implements Serializable {
    private static final Iterator<ResponseTypeEnum> emptyList = new HashSet().iterator();
    protected Set<ResponseTypeEnum> value;

    public DmcTypeResponseTypeEnumSET() {
        this.value = null;
    }

    public DmcTypeResponseTypeEnumSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<ResponseTypeEnum>() : new TreeSet<ResponseTypeEnum>();
    }

    public DmcTypeResponseTypeEnumSET getNew() {
        return new DmcTypeResponseTypeEnumSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<ResponseTypeEnum> cloneIt() {
        DmcTypeResponseTypeEnumSET dmcTypeResponseTypeEnumSET = this;
        synchronized (dmcTypeResponseTypeEnumSET) {
            DmcTypeResponseTypeEnumSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ResponseTypeEnum val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseTypeEnum add(Object v) throws DmcValueException {
        DmcTypeResponseTypeEnumSET dmcTypeResponseTypeEnumSET = this;
        synchronized (dmcTypeResponseTypeEnumSET) {
            ResponseTypeEnum rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseTypeEnum del(Object v) {
        DmcTypeResponseTypeEnumSET dmcTypeResponseTypeEnumSET = this;
        synchronized (dmcTypeResponseTypeEnumSET) {
            ResponseTypeEnum rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ResponseTypeEnum> getMV() {
        DmcTypeResponseTypeEnumSET dmcTypeResponseTypeEnumSET = this;
        synchronized (dmcTypeResponseTypeEnumSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<ResponseTypeEnum>(this.value).iterator();
            }
            return new TreeSet<ResponseTypeEnum>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ResponseTypeEnum> getMVCopy() {
        DmcTypeResponseTypeEnumSET dmcTypeResponseTypeEnumSET = this;
        synchronized (dmcTypeResponseTypeEnumSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<ResponseTypeEnum>();
                }
                return new HashSet<ResponseTypeEnum>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<ResponseTypeEnum>(this.value);
            }
            return new TreeSet<ResponseTypeEnum>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeResponseTypeEnumSET dmcTypeResponseTypeEnumSET = this;
        synchronized (dmcTypeResponseTypeEnumSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeResponseTypeEnumSET dmcTypeResponseTypeEnumSET = this;
        synchronized (dmcTypeResponseTypeEnumSET) {
            if (this.value == null) {
                return false;
            }
            try {
                ResponseTypeEnum val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

