/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmp.shared.generated.enums.ScopeEnum;
import org.dmd.dmp.shared.generated.types.DmcTypeScopeEnum;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeScopeEnumSET
extends DmcTypeScopeEnum
implements Serializable {
    private static final Iterator<ScopeEnum> emptyList = new HashSet().iterator();
    protected Set<ScopeEnum> value;

    public DmcTypeScopeEnumSET() {
        this.value = null;
    }

    public DmcTypeScopeEnumSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<ScopeEnum>() : new TreeSet<ScopeEnum>();
    }

    public DmcTypeScopeEnumSET getNew() {
        return new DmcTypeScopeEnumSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<ScopeEnum> cloneIt() {
        DmcTypeScopeEnumSET dmcTypeScopeEnumSET = this;
        synchronized (dmcTypeScopeEnumSET) {
            DmcTypeScopeEnumSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ScopeEnum val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScopeEnum add(Object v) throws DmcValueException {
        DmcTypeScopeEnumSET dmcTypeScopeEnumSET = this;
        synchronized (dmcTypeScopeEnumSET) {
            ScopeEnum rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScopeEnum del(Object v) {
        DmcTypeScopeEnumSET dmcTypeScopeEnumSET = this;
        synchronized (dmcTypeScopeEnumSET) {
            ScopeEnum rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ScopeEnum> getMV() {
        DmcTypeScopeEnumSET dmcTypeScopeEnumSET = this;
        synchronized (dmcTypeScopeEnumSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<ScopeEnum>(this.value).iterator();
            }
            return new TreeSet<ScopeEnum>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ScopeEnum> getMVCopy() {
        DmcTypeScopeEnumSET dmcTypeScopeEnumSET = this;
        synchronized (dmcTypeScopeEnumSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<ScopeEnum>();
                }
                return new HashSet<ScopeEnum>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<ScopeEnum>(this.value);
            }
            return new TreeSet<ScopeEnum>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeScopeEnumSET dmcTypeScopeEnumSET = this;
        synchronized (dmcTypeScopeEnumSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeScopeEnumSET dmcTypeScopeEnumSET = this;
        synchronized (dmcTypeScopeEnumSET) {
            if (this.value == null) {
                return false;
            }
            try {
                ScopeEnum val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

