/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmp.shared.generated.dmo.SetResponseDMO;
import org.dmd.dmp.shared.generated.types.DmcTypeSetResponseREF;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeSetResponseREFSET
extends DmcTypeSetResponseREF
implements Serializable {
    private static final Iterator<SetResponseDMO> emptyList = new HashSet().iterator();
    protected Set<SetResponseDMO> value;

    public DmcTypeSetResponseREFSET() {
        this.value = null;
    }

    public DmcTypeSetResponseREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<SetResponseDMO>() : new TreeSet<SetResponseDMO>();
    }

    public DmcTypeSetResponseREFSET getNew() {
        return new DmcTypeSetResponseREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<SetResponseDMO> cloneIt() {
        DmcTypeSetResponseREFSET dmcTypeSetResponseREFSET = this;
        synchronized (dmcTypeSetResponseREFSET) {
            DmcTypeSetResponseREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (SetResponseDMO val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetResponseDMO add(Object v) throws DmcValueException {
        DmcTypeSetResponseREFSET dmcTypeSetResponseREFSET = this;
        synchronized (dmcTypeSetResponseREFSET) {
            SetResponseDMO rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetResponseDMO del(Object v) {
        DmcTypeSetResponseREFSET dmcTypeSetResponseREFSET = this;
        synchronized (dmcTypeSetResponseREFSET) {
            SetResponseDMO rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<SetResponseDMO> getMV() {
        DmcTypeSetResponseREFSET dmcTypeSetResponseREFSET = this;
        synchronized (dmcTypeSetResponseREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<SetResponseDMO>(this.value).iterator();
            }
            return new TreeSet<SetResponseDMO>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<SetResponseDMO> getMVCopy() {
        DmcTypeSetResponseREFSET dmcTypeSetResponseREFSET = this;
        synchronized (dmcTypeSetResponseREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<SetResponseDMO>();
                }
                return new HashSet<SetResponseDMO>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<SetResponseDMO>(this.value);
            }
            return new TreeSet<SetResponseDMO>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeSetResponseREFSET dmcTypeSetResponseREFSET = this;
        synchronized (dmcTypeSetResponseREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeSetResponseREFSET dmcTypeSetResponseREFSET = this;
        synchronized (dmcTypeSetResponseREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                SetResponseDMO val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

