/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmr.server.base.extended;

import java.util.Iterator;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmr.server.base.extended.HierarchicObject;
import org.dmd.dmr.server.base.generated.dmw.DotNamedObjectDMW;
import org.dmd.dmr.shared.base.generated.dmo.DotNamedObjectDMO;
import org.dmd.dms.ClassDefinition;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;

public class DotNamedObject
extends DotNamedObjectDMW {
    protected DotNamedObject(DotNamedObjectDMO obj, ClassDefinition cd) {
        super(obj, cd);
    }

    public DotNamedObject() {
    }

    @Override
    public void resetParent(HierarchicObject newParent) throws ResultException, DmcValueException {
        if (this.getName() == null) {
            ResultException ex = new ResultException();
            ex.addError("Missing value for dotName. You must set dotName on this object.");
            throw ex;
        }
        if (newParent == null) {
            this.setFQN(this.getName());
            if (this.parent != null) {
                this.parent.removeSubComponent(this);
            }
            this.parent = newParent;
        } else {
            if (newParent != this.parent) {
                if (this.parent != null) {
                    this.parent.removeSubComponent(this);
                }
                newParent.addSubComponent(this);
            }
            this.parent = newParent;
            this.setFQN(this.parent.getFQN() + "." + this.getName());
        }
        Iterator<HierarchicObject> it = this.getSubComps();
        while (it.hasNext()) {
            it.next().resetParent(this);
        }
    }

    @Override
    public void setParentObject(HierarchicObject p, boolean buildFQN) throws ResultException, DmcValueException {
        if (p != null && p.getFQN() == null) {
            ResultException ex = new ResultException();
            ex.addErrorWithStack("The object being set as the parent hasn't been properly initialized. Ensure that its setParentObject() function has been called.", DebugInfo.getCurrentStack());
            throw ex;
        }
        this.parent = p;
        if (!buildFQN) {
            return;
        }
        if (this.getName() == null) {
            ResultException ex = new ResultException();
            ex.addError("Missing value for dotName. You must set dotName on this object.");
            throw ex;
        }
        if (this.parent == null) {
            this.setFQN(this.getName());
        } else {
            this.setFQN(this.parent.getFQN() + "." + this.getName());
            this.parent.addSubComponent(this);
        }
    }
}

